/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log;

import java.io.IOException;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.provider.log.LogMethodHandlerFactory;
import org.shiftone.jrat.provider.log.io.LogOutput;

public class LogMethodHandler
implements MethodHandler {
    private MethodKey methodKey = null;
    private LogMethodHandlerFactory factory = null;

    public LogMethodHandler(MethodKey methodKey, LogMethodHandlerFactory factory) {
        this.methodKey = methodKey;
        this.factory = factory;
    }

    private final LogOutput getLogOutput() {
        return this.factory.getLogOutput();
    }

    public void onMethodStart(Object obj, Object[] args) {
        try {
            this.getLogOutput().writeMethodStart(this.methodKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMethodFinish(Object obj, Object[] args, Object ret, long duration, boolean success) {
        try {
            this.getLogOutput().writeMethodFinish(this.methodKey, duration, success);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void onMethodError(Object obj, Object[] args, Throwable e) {
        try {
            this.getLogOutput().writeMethodError(this.methodKey, e);
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

