/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.io;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.log.io.LogFileFormatException;
import org.shiftone.jrat.provider.log.io.ThreadNames;
import org.shiftone.jrat.provider.log.io.message.CloseMessage;
import org.shiftone.jrat.provider.log.io.message.EnterMessage;
import org.shiftone.jrat.provider.log.io.message.ErrorMessage;
import org.shiftone.jrat.provider.log.io.message.FinishMessage;
import org.shiftone.jrat.provider.log.io.message.Message;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class LogInput {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$log$io$LogInput == null ? (class$org$shiftone$jrat$provider$log$io$LogInput = LogInput.class$("org.shiftone.jrat.provider.log.io.LogInput")) : class$org$shiftone$jrat$provider$log$io$LogInput);
    private DataInput in = null;
    private Map threadMap = new HashMap();
    private Map methodMap = new HashMap();
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$io$LogInput;

    public LogInput(DataInput dataInput) throws IOException {
        LOG.info("LogInput " + dataInput);
        this.in = dataInput;
    }

    public void readPreamble() throws IOException {
        LOG.info("readPreamble " + this.in);
        while (this.in.readByte() != 13) {
        }
        if (this.in.readByte() != 10 || this.in.readByte() != 74) {
            throw new LogFileFormatException("log file preamble is corrupt");
        }
    }

    public synchronized Message readMessage() throws IOException {
        Message message = null;
        if (this.in == null) {
            return null;
        }
        byte c = this.in.readByte();
        while (c == 77 || c == 84) {
            if (c == 77) {
                this.readMethodDef();
            } else if (c == 84) {
                this.readThreadDef();
            }
            c = this.in.readByte();
        }
        if (c == 66) {
            message = new EnterMessage(this, this.in);
        } else if (c == 69) {
            message = new FinishMessage(this, this.in);
        } else if (c == 82) {
            message = new ErrorMessage(this, this.in);
        } else if (c == 67) {
            message = new CloseMessage(this, this.in);
        } else {
            throw new LogFileFormatException("bad message format : " + c + " = " + (char)c);
        }
        return message;
    }

    private void readThreadDef() throws IOException {
        int threadId = this.in.readInt();
        String groupName = this.in.readUTF();
        String name = this.in.readUTF();
        this.defineThread(threadId, groupName, name);
    }

    public void defineThread(int threadId, String groupName, String name) {
        ThreadNames names = new ThreadNames();
        names.groupName = groupName;
        names.name = name;
        this.threadMap.put(new Integer(threadId), names);
    }

    ThreadNames getThreadNames(int threadId) {
        ThreadNames names = (ThreadNames)this.threadMap.get(new Integer(threadId));
        return names;
    }

    public String getThreadName(int threadId) {
        return this.getThreadNames((int)threadId).name;
    }

    String getThreadGroupName(int threadId) {
        return this.getThreadNames((int)threadId).groupName;
    }

    private void readMethodDef() throws IOException {
        int methodId = this.in.readInt();
        String className = this.in.readUTF();
        String methodName = this.in.readUTF();
        String signature = this.in.readUTF();
        MethodKey methodKey = new MethodKey(className, methodName, signature);
        LOG.debug("method def : " + methodKey);
        this.defineMethod(methodId, methodKey);
    }

    private void defineMethod(int methodId, MethodKey methodKey) {
        this.methodMap.put(new Integer(methodId), methodKey);
    }

    public MethodKey getMethodKey(int methodId) {
        return (MethodKey)this.methodMap.get(new Integer(methodId));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

