/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.shiftone.jrat.core.spi.RuntimeOutput;
import org.shiftone.jrat.provider.log.io.Converter;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class LogConvertPanel
extends JPanel
implements ActionListener {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$log$ui$LogConvertPanel == null ? (class$org$shiftone$jrat$provider$log$ui$LogConvertPanel = LogConvertPanel.class$("org.shiftone.jrat.provider.log.ui.LogConvertPanel")) : class$org$shiftone$jrat$provider$log$ui$LogConvertPanel);
    private static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd HH:mm:ss,SSS";
    private RuntimeOutput runtimeOutput;
    private JFileChooser chooser;
    private final JCheckBox seqBox;
    private final JCheckBox depthBox;
    private final JCheckBox indentBox;
    private final JCheckBox qualifyBox;
    private final JTextField dateText;
    private final JTextField fileText;
    private final JButton convert;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$ui$LogConvertPanel;

    public LogConvertPanel(RuntimeOutput runtimeOutput) {
        this.runtimeOutput = runtimeOutput;
        this.chooser = new JFileChooser();
        this.chooser.setControlButtonsAreShown(false);
        this.chooser.setFileSelectionMode(1);
        this.seqBox = new JCheckBox("include message sequence identifier", true);
        this.depthBox = new JCheckBox("include thread stack depth", true);
        this.indentBox = new JCheckBox("indent thread stack depth", false);
        this.qualifyBox = new JCheckBox("use fully qualified class names", false);
        this.dateText = new JTextField(DEFAULT_DATE_FORMAT);
        this.fileText = new JTextField(this.getDefaultLogName());
        this.convert = new JButton("Convert " + this.getFileName() + " Now!");
        this.convert.setBackground(new Color(150, 255, 150));
        this.setLayout(new BorderLayout());
        this.add((Component)this.chooser, "Center");
        this.add((Component)this.getOptionsPanel(), "South");
    }

    private String getFileName() {
        return this.runtimeOutput.getInputFile().getName();
    }

    private String getDefaultLogName() {
        String name = this.getFileName();
        int firstDot = name.indexOf(46);
        if (firstDot > 1) {
            name = name.substring(0, firstDot) + ".log";
        }
        return name;
    }

    public JPanel getOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.seqBox);
        panel.add(this.depthBox);
        panel.add(this.indentBox);
        panel.add(this.qualifyBox);
        panel.add(new JLabel("Date Format :"));
        panel.add(this.dateText);
        panel.add(new JLabel("Log File Name :"));
        panel.add(this.fileText);
        panel.add(Box.createVerticalStrut(1));
        panel.add(this.convert);
        this.convert.addActionListener(this);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.convert) {
            Converter converter = new Converter();
            converter.setDateFormat(this.dateText.getText());
            converter.setPrintQualifiedClasses(this.qualifyBox.isSelected());
            converter.setPrintThreadDepth(this.depthBox.isSelected());
            converter.setPrintSeqId(this.seqBox.isSelected());
            LOG.info("actionPerformed:convert");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

