/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.rate.ui;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.shiftone.jrat.core.Accumulator;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.ParseException;
import org.shiftone.jrat.provider.rate.ui.RateModelSample;
import org.shiftone.jrat.ui.util.ColorSet;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class RateModel {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$rate$ui$RateModel == null ? (class$org$shiftone$jrat$provider$rate$ui$RateModel = RateModel.class$("org.shiftone.jrat.provider.rate.ui.RateModel")) : class$org$shiftone$jrat$provider$rate$ui$RateModel);
    private int handlerMax = 0;
    private long rateStartTimeMs = 0L;
    private long sysStartTimeMs = 0L;
    private long periodMs = 0L;
    private boolean wasShutdown = false;
    private List samples = null;
    private List methodKeys = null;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$rate$ui$RateModel;

    public void load(InputStream inputStream) throws IOException, ParseException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        LineNumberReader lineReader = new LineNumberReader(reader);
        String line = null;
        lineReader.readLine();
        this.handlerMax = Integer.parseInt(lineReader.readLine());
        this.sysStartTimeMs = Long.parseLong(lineReader.readLine());
        this.rateStartTimeMs = Long.parseLong(lineReader.readLine());
        this.periodMs = Long.parseLong(lineReader.readLine());
        this.wasShutdown = false;
        this.samples = new ArrayList();
        this.methodKeys = new ArrayList();
        while ((line = lineReader.readLine()) != null) {
            this.processLine(line);
        }
        IOUtil.close(inputStream);
    }

    private void processLine(String line) throws ParseException {
        String[] tokens = StringUtil.tokenize(line, "\t", false);
        if (tokens.length < 3) {
            LOG.info("line only has " + tokens.length + " tokens");
            return;
        }
        if (!tokens[tokens.length - 1].equals("END")) {
            LOG.info("line does not end with END token : " + line);
            return;
        }
        if (tokens[0].equals("METHOD")) {
            this.addMethod(tokens);
        } else if (tokens[0].equals("SAMPLE")) {
            this.addSample(tokens);
        } else if (tokens[0].equals("SHUTDOWN")) {
            this.wasShutdown = true;
        }
    }

    private void addMethod(String[] tokens) throws ParseException {
        if (tokens.length != 6) {
            throw new ParseException("error in format of method key : " + tokens);
        }
        this.methodKeys.add(Integer.parseInt(tokens[1]), new MethodKey(tokens[2], tokens[3], tokens[4]));
    }

    private void addSample(String[] tokens) throws ParseException {
        this.samples.add(new RateModelSample(tokens));
    }

    public int getSampleCount() {
        return this.samples.size();
    }

    public int getMethodCount() {
        return this.methodKeys.size();
    }

    public MethodKey getMethodKey(int index) {
        return (MethodKey)this.methodKeys.get(index);
    }

    public Color getMethodColor(int index) {
        return ColorSet.COLOR_SET_5.getColor(index);
    }

    public RateModelSample getSample(int sampleNumber) {
        return (RateModelSample)this.samples.get(sampleNumber);
    }

    public Accumulator getAccumulator(int sampleNumber, int methodNumber) {
        return this.getSample(sampleNumber).getAccumulator(methodNumber);
    }

    public long getFreeMemory(int sampleNumber) {
        return this.getSample(sampleNumber).getFreeMemory();
    }

    public long getMaxMemory(int sampleNumber) {
        return this.getSample(sampleNumber).getMaxMemory();
    }

    public int getMaxDuration(int methodNumber) {
        Long currentMax = null;
        int max = 0;
        for (int i = 0; i < this.getSampleCount(); ++i) {
            currentMax = this.getAccumulator(i, methodNumber).getMaxDuration();
            if (currentMax == null) continue;
            max = Math.max(max, currentMax.intValue());
        }
        return max;
    }

    public long getRateStartTimeMs() {
        return this.rateStartTimeMs;
    }

    public long getSysStartTimeMs() {
        return this.sysStartTimeMs;
    }

    public boolean isWasShutdown() {
        return this.wasShutdown;
    }

    public long getPeriodMs() {
        return this.periodMs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

