/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.proxy.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.shiftone.jrat.proxy.jdbc.ProxyXAConnection;
import org.shiftone.jrat.util.IntrospectionUtil;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ProxyXADataSource
implements XADataSource,
Referenceable {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$proxy$jdbc$ProxyXADataSource == null ? (class$org$shiftone$jrat$proxy$jdbc$ProxyXADataSource = ProxyXADataSource.class$("org.shiftone.jrat.proxy.jdbc.ProxyXADataSource")) : class$org$shiftone$jrat$proxy$jdbc$ProxyXADataSource);
    private Properties properties = new Properties();
    private String targetDriverClassName = null;
    private String targetProperties = null;
    XADataSource targetDataSource = null;
    static /* synthetic */ Class class$org$shiftone$jrat$proxy$jdbc$ProxyXADataSource;

    public ProxyXADataSource() {
        LOG.info("new ProxyXADataSource");
    }

    public XAConnection getXAConnection() throws SQLException {
        LOG.info("getXAConnection()");
        return new ProxyXAConnection(this.getTargetDataSource().getXAConnection());
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        LOG.info("getXAConnection(" + user + ", " + password + ")");
        return new ProxyXAConnection(this.getTargetDataSource().getXAConnection(user, password));
    }

    private synchronized XADataSource getTargetDataSource() throws SQLException {
        if (this.targetDataSource == null) {
            this.targetDataSource = ProxyXADataSource.newXADataSourceInstance(this.targetDriverClassName, this.properties);
        }
        return this.targetDataSource;
    }

    public static XADataSource newXADataSourceInstance(String driverName, Properties properties) throws SQLException {
        Class<?> klass = null;
        Object instance = null;
        Enumeration<Object> keys = null;
        String key = null;
        String value = null;
        Method method = null;
        Object param = null;
        try {
            LOG.info("new XADataSource : " + driverName);
            klass = Class.forName(driverName);
            instance = klass.newInstance();
        }
        catch (Exception e) {
            throw new SQLException("unable to create instance of driver : " + driverName + " - " + e.getMessage());
        }
        keys = properties.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            value = properties.getProperty(key);
            try {
                method = IntrospectionUtil.getMethod(klass, "set" + key, 1);
                param = IntrospectionUtil.convert(value, method.getParameterTypes()[0]);
                LOG.info("calling " + method.getName() + "( " + value + " )");
                method.invoke(instance, param);
            }
            catch (Exception e) {
                LOG.warn("error setting driver property : " + key + " to " + value + " - " + e.getMessage());
            }
        }
        return instance;
    }

    public int getLoginTimeout() throws SQLException {
        XADataSource ds = this.getTargetDataSource();
        int loginTimeout = ds.getLoginTimeout();
        LOG.info("getLoginTimeout() -> " + loginTimeout);
        return loginTimeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        LOG.debug("getLogWriter()");
        return this.getTargetDataSource().getLogWriter();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        LOG.info("setLoginTimeout(" + seconds + ")");
        this.getTargetDataSource().setLoginTimeout(seconds);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        LOG.info("setLogWriter(.)");
        this.getTargetDataSource().setLogWriter(out);
    }

    public Reference getReference() throws NamingException {
        Reference reference = null;
        LOG.info("getReference()");
        try {
            XADataSource ds = this.getTargetDataSource();
            if (ds instanceof Referenceable) {
                reference = ((Referenceable)((Object)ds)).getReference();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (reference == null) {
            throw new UnsupportedOperationException("getReference() failed for : " + this.targetDriverClassName);
        }
        return reference;
    }

    public void setTargetDriver(String targetDriverClassName) {
        this.targetDriverClassName = targetDriverClassName;
    }

    public String getTargetDriver() {
        return this.targetDriverClassName;
    }

    public void setTargetProperties(String targetProperties) {
        this.targetProperties = targetProperties;
        StringUtil.parsePropertiesString(targetProperties, this.properties);
    }

    public String getTargetProperties() {
        return this.targetProperties;
    }

    private void setProperty(String name, String value) {
        LOG.info("setProperty(" + name + " , " + value + ")");
        this.properties.setProperty(name, value);
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setUser(String s) {
        this.setProperty("user", s);
    }

    public String getDatabaseName() {
        return this.properties.getProperty("databaseName");
    }

    public String getDataSourceName() {
        return this.properties.getProperty("dataSourceName");
    }

    public String getDescription() {
        return this.properties.getProperty("description");
    }

    public String getDriverType() {
        return this.properties.getProperty("driverType");
    }

    public String getExplicitCachingEnabled() throws SQLException {
        return this.properties.getProperty("explicitCachingEnabled");
    }

    public String getImplicitCachingEnabled() throws SQLException {
        return this.properties.getProperty("implicitCachingEnabled");
    }

    public String getMaxStatements() throws SQLException {
        return this.getProperty("maxStatements");
    }

    public String getNetworkProtocol() {
        return this.getProperty("networkProtocol");
    }

    protected String getPassword() {
        return this.getProperty("password");
    }

    public String getPortNumber() {
        return this.getProperty("portNumber");
    }

    public String getServerName() {
        return this.getProperty("serverName");
    }

    public String getServiceName() {
        return this.getProperty("serviceName");
    }

    public String getTNSEntryName() {
        return this.getProperty("TNSEntryName");
    }

    public String getURL() throws SQLException {
        return this.getProperty("URL");
    }

    public String getUser() {
        return this.getProperty("user");
    }

    public void setDatabaseName(String s) {
        this.setProperty("databaseName", s);
    }

    public void setDataSourceName(String s) {
        this.setProperty("dataSourceName", s);
    }

    public void setDescription(String s) {
        this.setProperty("description", s);
    }

    public void setDriverType(String s) {
        this.setProperty("driverType", s);
    }

    public void setExplicitCachingEnabled(String b) throws SQLException {
        this.setProperty("explicitCachingEnabled", b);
    }

    public void setImplicitCachingEnabled(String b) throws SQLException {
        this.setProperty("implicitCachingEnabled", b);
    }

    public void setMaxStatements(String i) throws SQLException {
        this.setProperty("maxStatements", i);
    }

    public void setNetworkProtocol(String s) {
        this.setProperty("networkProtocol", s);
    }

    public void setPassword(String s) {
        this.setProperty("password", s);
    }

    public void setPortNumber(String i) {
        this.setProperty("portNumber", i);
    }

    public void setServerName(String s) {
        this.setProperty("serverName", s);
    }

    public void setServiceName(String s) {
        this.setProperty("serviceName", s);
    }

    public void setTNSEntryName(String s) {
        this.setProperty("TNSEntryName", s);
    }

    public void setURL(String s) {
        this.setProperty("url", s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

