/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.shiftone.jrat.core.ConfigurationException;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class PropertiesTree {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$PropertiesTree == null ? (class$org$shiftone$jrat$util$PropertiesTree = PropertiesTree.class$("org.shiftone.jrat.util.PropertiesTree")) : class$org$shiftone$jrat$util$PropertiesTree);
    private Node root = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$PropertiesTree;

    public PropertiesTree() {
        this.initialize(new Properties());
    }

    public PropertiesTree(Properties properties) {
        this.initialize(properties);
    }

    private void initialize(Properties properties) {
        Assert.assertNotNull("properties", properties);
        this.root = new Node("ROOT", null);
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            this.root.createNode(key, value);
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties, this.root, "");
        return properties;
    }

    private void populateProperties(Properties properties, Node node, String prefix) {
        Collection children = node.getChildren();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            Node child = (Node)i.next();
            String key = prefix + child.getKey();
            String value = child.getValue();
            if (value != null) {
                properties.setProperty(key, value);
            }
            this.populateProperties(properties, child, key + ".");
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public Node getNode(String key) throws ConfigurationException {
        return this.root.getNode(key);
    }

    public void print(PrintStream out) {
        this.print(out, this.root, 0);
    }

    private void print(PrintStream out, Node node, int indentLevel) {
        Collection children = node.getChildren();
        if (children.size() == 0) {
            out.println(StringUtil.bufferString(indentLevel, '\t') + "<" + node.getKey() + " value=\"" + node.getValue() + "\"/>");
        } else {
            out.println(StringUtil.bufferString(indentLevel, '\t') + "<" + node.getKey() + " value=\"" + node.getValue() + "\">");
            Iterator i = children.iterator();
            while (i.hasNext()) {
                this.print(out, (Node)i.next(), indentLevel + 1);
            }
            out.println(StringUtil.bufferString(indentLevel, '\t') + "</" + node.getKey() + ">");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Node {
        private Map children = new HashMap();
        private String key = null;
        private String value = null;

        public Node(String key, String value) {
            this.value = value;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public Collection getChildren() {
            return this.children.values();
        }

        public Node getNode(String key) throws ConfigurationException {
            return this.getNode(StringUtil.tokenize(key, ".", false), 0);
        }

        private Node getNode(String[] keyParts, int partIndex) throws ConfigurationException {
            if (keyParts.length == partIndex) {
                return this;
            }
            String part = keyParts[partIndex];
            Node nextChild = (Node)this.children.get(part);
            if (nextChild == null) {
                throw new ConfigurationException("node not found : " + this.fullKey(keyParts, partIndex));
            }
            return nextChild.getNode(keyParts, partIndex + 1);
        }

        private String fullKey(String[] keyParts, int partIndex) {
            String fullKey = keyParts[0];
            for (int i = 1; i < partIndex; ++i) {
                fullKey = fullKey + "." + keyParts[i];
            }
            return fullKey;
        }

        public void createNode(String key, String value) {
            this.createNode(StringUtil.tokenize(key, ".", false), 0, value);
        }

        private void createNode(String[] keyParts, int partIndex, String value) {
            if (keyParts.length == partIndex) {
                this.value = value;
            } else {
                Node nextChild = null;
                String part = keyParts[partIndex];
                if (this.children.containsKey(part)) {
                    nextChild = (Node)this.children.get(part);
                } else {
                    nextChild = new Node(part, null);
                    this.children.put(part, nextChild);
                }
                nextChild.createNode(keyParts, partIndex + 1, value);
            }
        }
    }
}

