/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util.log;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class SimpleLog
implements Log {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$log$SimpleLog == null ? (class$org$shiftone$jrat$util$log$SimpleLog = SimpleLog.class$("org.shiftone.jrat.util.log.SimpleLog")) : class$org$shiftone$jrat$util$log$SimpleLog);
    private static final String DATE_FORMAT = " MM.dd HH:mm:ss,SSS - ";
    private static final int CURRENT_LEVEL = Integer.getInteger("jrat.log.level", 2);
    private static PrintWriter OUT = new PrintWriter(System.out);
    private DateFormat dateFormat = new SimpleDateFormat(" MM.dd HH:mm:ss,SSS - ");
    private String className = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$log$SimpleLog;

    SimpleLog(String className) {
        this.className = className;
    }

    public static synchronized void setPrintWriter(PrintWriter out) {
        OUT.flush();
        OUT = out;
    }

    public static synchronized void close() {
        LOG.info("shutting down log...");
        OUT.flush();
        OUT = new PrintWriter(System.out);
        LOG.info("log shut down.");
    }

    private synchronized void log(int level, Object obj, Throwable t) {
        if (level >= CURRENT_LEVEL) {
            OUT.print(Log.LEVEL_NAMES[level]);
            OUT.print(" ");
            OUT.print(Thread.currentThread().getName());
            OUT.print(this.dateFormat.format(new Date()));
            OUT.print(this.className);
            OUT.print(" - ");
            OUT.println(String.valueOf(obj));
            if (t != null) {
                t.printStackTrace(OUT);
            }
        }
    }

    public synchronized void trace(Object obj) {
        this.log(0, obj, null);
    }

    public synchronized void debug(Object obj) {
        this.log(1, obj, null);
    }

    public synchronized void debug(Object obj, Throwable t) {
        this.log(1, obj, t);
    }

    public synchronized void info(Object obj) {
        this.log(2, obj, null);
    }

    public synchronized void info(Object obj, Throwable t) {
        this.log(2, obj, t);
    }

    public synchronized void warn(Object obj) {
        this.log(3, obj, null);
    }

    public synchronized void warn(Object obj, Throwable t) {
        this.log(3, obj, t);
    }

    public synchronized void error(Object obj) {
        this.log(4, obj, null);
    }

    public synchronized void error(Object obj, Throwable t) {
        this.log(4, obj, t);
    }

    public synchronized void fatal(Object obj) {
        this.log(5, obj, null);
    }

    public synchronized void fatal(Object obj, Throwable t) {
        this.log(5, obj, t);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

