/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.shiftone.jrat.core.FlushHook;
import org.shiftone.jrat.core.ShutdownHook;
import org.shiftone.jrat.core.spi.FlushListener;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.core.spi.ShutdownListener;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.NullOutputStream;
import org.shiftone.jrat.util.Sequence;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;
import org.shiftone.jrat.util.log.SimpleLog;

class RuntimeContextImpl
implements RuntimeContext,
ShutdownListener,
FlushListener {
    public static final int BUFFER_SIZE = 32;
    public static final String OUTPUT_DIR_NAME = "JRatOutput";
    public static final String LOG_FILE_NAME = "JRat-LOG.jrat";
    public static final String DIR_DATE_FORMAT = "yyyy-MM-dd_a-hh-mm-ss";
    public static final String FILE_NUM_FORMAT = "000";
    public static final long MAX_OUTPUT_FILES = 300L;
    public static final long MAX_OPEN_FILES = 300L;
    public static final String SYS_PROP_APP = "jrat.app";
    private static final String JRAT_APP = System.getProperty("jrat.app");
    protected static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$RuntimeContextImpl == null ? (class$org$shiftone$jrat$core$RuntimeContextImpl = RuntimeContextImpl.class$("org.shiftone.jrat.core.RuntimeContextImpl")) : class$org$shiftone$jrat$core$RuntimeContextImpl);
    protected final Set openOutputStreams;
    private final NumberFormat fileSeqFormat;
    private final Sequence sequence;
    private final Sequence fileSequence;
    private final long startTimeMs;
    private final Date startDate;
    private final File outputDir;
    private final ShutdownHook shutdownHook;
    private final FlushHook flushHook;
    static /* synthetic */ Class class$org$shiftone$jrat$core$RuntimeContextImpl;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$viewer$SimpleTextOutputViewerFactory;

    RuntimeContextImpl(ShutdownHook shutdownHook, FlushHook flushHook) {
        LOG.debug("new RuntimeContextImpl");
        this.startTimeMs = System.currentTimeMillis();
        this.fileSeqFormat = new DecimalFormat(FILE_NUM_FORMAT);
        this.sequence = new Sequence();
        this.fileSequence = new Sequence();
        this.startDate = new Date(this.startTimeMs);
        this.shutdownHook = shutdownHook;
        this.flushHook = flushHook;
        this.openOutputStreams = new HashSet();
        this.outputDir = this.createOutputDir();
        this.redirectLogStream();
        this.addShutdownListener(this);
        this.addFlushListener(this);
    }

    private void redirectLogStream() {
        try {
            OutputStream outputStream = this.newOutputStream(LOG_FILE_NAME);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "US-ASCII");
            PrintWriter printWriter = new PrintWriter((Writer)writer, false);
            printWriter.print("viewer=\"");
            printWriter.print((class$org$shiftone$jrat$ui$viewer$SimpleTextOutputViewerFactory == null ? (class$org$shiftone$jrat$ui$viewer$SimpleTextOutputViewerFactory = RuntimeContextImpl.class$("org.shiftone.jrat.ui.viewer.SimpleTextOutputViewerFactory")) : class$org$shiftone$jrat$ui$viewer$SimpleTextOutputViewerFactory).getName());
            printWriter.println("\"");
            SimpleLog.setPrintWriter(printWriter);
            LOG.info("logfile created");
            LOG.info("Running JRat version " + VersionUtil.getVersion() + " - built on " + VersionUtil.getBuiltOn());
        }
        catch (Exception e) {
            LOG.warn("unable to redirect LOG to file", e);
        }
    }

    private File createOutputDir() {
        File desiredDir;
        SimpleDateFormat format = new SimpleDateFormat(DIR_DATE_FORMAT);
        File cwd = new File("");
        StringBuffer sb = new StringBuffer();
        sb.append(cwd.getAbsolutePath());
        sb.append(File.separator);
        sb.append(OUTPUT_DIR_NAME);
        sb.append(File.separator);
        if (JRAT_APP != null) {
            sb.append(JRAT_APP);
            sb.append(File.separator);
        }
        sb.append(format.format((Object)this.startDate));
        File outputDir = desiredDir = new File(sb.toString());
        while (outputDir.exists()) {
            outputDir = new File(desiredDir.getAbsolutePath() + "-" + RuntimeContextImpl.randomInt());
        }
        try {
            IOUtil.mkdir(outputDir);
        }
        catch (Exception e) {
            LOG.error("error creating desired output directory", e);
            outputDir = cwd;
        }
        LOG.info("output DIR = " + outputDir);
        return outputDir;
    }

    public OutputStream newOutputStream(String fileName) throws IOException {
        return this.newOutputStream(fileName, false);
    }

    private String getFileName(String name, long fileNumber, boolean compress) {
        String path = this.outputDir.getAbsolutePath() + File.separator + this.fileSeqFormat.format(fileNumber) + "_" + name;
        if (compress) {
            path = path + ".gz";
        }
        return path;
    }

    public synchronized void shutdown() {
        SimpleLog.close();
        Iterator iterator = this.openOutputStreams.iterator();
        while (iterator.hasNext()) {
            OutputStream out = (OutputStream)iterator.next();
            LOG.info("shutdown closing : " + out);
            IOUtil.close(out);
        }
    }

    public synchronized void flush() {
        Iterator iterator = this.openOutputStreams.iterator();
        while (iterator.hasNext()) {
            OutputStream out = (OutputStream)iterator.next();
            LOG.info("flushing stream : " + out);
            IOUtil.flush(out);
        }
    }

    private synchronized OutputStream createFileOutputStream(File file, boolean compress) {
        OutputStream stream = null;
        LOG.info("createFileOutputStream " + file);
        if ((long)this.openOutputStreams.size() > 300L) {
            LOG.info("max number of open output files exceeded : 300");
        } else {
            try {
                stream = new SafeFileOutputStream(file);
                this.openOutputStreams.add(stream);
                stream = compress ? new GZIPOutputStream(stream, 32) : new BufferedOutputStream(stream, 32);
            }
            catch (Exception e) {
                LOG.error("unable to create output stream", e);
            }
        }
        if (stream == null) {
            LOG.info("the requested file was not created : " + file);
            LOG.info("returning a null output stream (/dev/null) for file");
            LOG.info("output will be sent to the abyss");
            stream = NullOutputStream.INSTANCE;
        }
        LOG.info("stream created " + stream);
        return stream;
    }

    public OutputStream newOutputStream(String fileName, boolean compress) throws IOException {
        Assert.assertNotNull("fileName", fileName);
        long fileNumber = this.fileSequence.getNextValue();
        String filePath = this.getFileName(fileName, fileNumber, compress);
        File file = new File(filePath);
        OutputStream outputStream = this.createFileOutputStream(file, compress);
        return outputStream;
    }

    public synchronized long uniqNumber() {
        return this.sequence.getNextValue();
    }

    public Date getStartupDate() {
        return this.startDate;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getUpTimeMs() {
        return System.currentTimeMillis() - this.getStartTimeMs();
    }

    private static int randomInt() {
        return (int)(Math.random() * 2.147483647E9);
    }

    public void addShutdownListener(ShutdownListener listener) {
        Assert.assertNotNull("ShutdownListener", listener);
        this.shutdownHook.addShutdownListener(listener);
    }

    public void addFlushListener(FlushListener listener) {
        Assert.assertNotNull("FlushListener", listener);
        this.flushHook.addFlushListener(listener);
    }

    public String toString() {
        return "RuntimeContextImpl created @ " + this.startDate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SafeFileOutputStream
    extends FileOutputStream {
        private boolean closed = false;
        private File file = null;

        SafeFileOutputStream(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        public synchronized void close() throws IOException {
            RuntimeContextImpl.this.openOutputStreams.remove(this);
            try {
                if (!this.closed) {
                    super.close();
                    this.closed = true;
                    LOG.info("file closed successfully : " + this.file);
                }
            }
            catch (IOException e) {
                System.out.println("close error");
                e.printStackTrace();
                throw e;
            }
        }

        public String toString() {
            return "SafeFileOutputStream@" + this.file.getAbsolutePath();
        }
    }
}

