/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.flush;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import org.shiftone.jrat.core.FlushHook;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class FlushWebServer
extends Thread {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$flush$FlushWebServer == null ? (class$org$shiftone$jrat$core$flush$FlushWebServer = FlushWebServer.class$("org.shiftone.jrat.core.flush.FlushWebServer")) : class$org$shiftone$jrat$core$flush$FlushWebServer);
    private static final int LISTEN_PORT = 2121;
    private ServerSocket serverSocket = null;
    private int flushNumber;
    private FlushHook flushHook;
    static /* synthetic */ Class class$org$shiftone$jrat$core$flush$FlushWebServer;

    public FlushWebServer(FlushHook flushHook) {
        this.setDaemon(true);
        this.setName("flush listener");
        this.flushHook = flushHook;
    }

    private boolean readRequest(Socket socket) throws IOException {
        boolean doRefresh = false;
        InputStream inputStream = null;
        LineNumberReader reader = null;
        inputStream = socket.getInputStream();
        reader = new LineNumberReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        boolean bl = doRefresh = line.indexOf("flush") != -1;
        while (line != null && line.length() > 0) {
            line = reader.readLine();
            LOG.info("<<< " + line);
        }
        return doRefresh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket = null;
        OutputStream outputStream = null;
        OutputStreamWriter writer = null;
        Object reader = null;
        try {
            LOG.info("starting on port 2121...");
            this.serverSocket = new ServerSocket(2121);
            while (true) {
                socket = this.serverSocket.accept();
                LOG.info("accept");
                try {
                    outputStream = socket.getOutputStream();
                    writer = new OutputStreamWriter(outputStream);
                    long start = System.currentTimeMillis();
                    ++this.flushNumber;
                    boolean refresh = this.readRequest(socket);
                    writer.write("HTTP/1.1 200 OK\n");
                    writer.write("Content-Type: text/html\n");
                    writer.write("Cache-Control: no-store, no-cache, must-revalidate\n");
                    writer.write("Cache-Control: post-check=0, pre-check=0");
                    writer.write("Pragma: no-cache\n");
                    writer.write("Expires: Sat, 6 May 1995 12:00:00 GMT\n");
                    writer.write("\n\n");
                    writer.write("<h2>JRat " + VersionUtil.getVersion() + "</h2>");
                    writer.write("<h3>built on " + VersionUtil.getBuiltOn() + "</h3>");
                    if (refresh) {
                        writer.write("Flush #" + this.flushNumber + " initiated @ " + new Date() + "...<br/>");
                        ((Writer)writer).flush();
                        this.flushHook.flushNow();
                        writer.write("Flushed listeners in " + (System.currentTimeMillis() - start) + "ms<br/>");
                    }
                    writer.write("<a href='/flush?" + Double.doubleToRawLongBits(Math.random()) + "'>click to flush</a>");
                    ((Writer)writer).flush();
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        LOG.error("Flush error", e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        IOUtil.close(outputStream);
                        IOUtil.close(socket);
                        throw throwable;
                    }
                    IOUtil.close(writer);
                    IOUtil.close(outputStream);
                    IOUtil.close(socket);
                    continue;
                }
                IOUtil.close(writer);
                IOUtil.close(outputStream);
                IOUtil.close(socket);
                continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.error("unable to listen on port : 2121");
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

