/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.jda.env;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class EnvPrinter {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$jda$env$EnvPrinter == null ? (class$org$shiftone$jrat$jda$env$EnvPrinter = EnvPrinter.class$("org.shiftone.jrat.jda.env.EnvPrinter")) : class$org$shiftone$jrat$jda$env$EnvPrinter);
    public static final String MAIN_TAG = "jrat-example-connectors";
    public static final String LAUNCH_TAG = "launching-connector";
    public static final String ATTACH_TAG = "attaching-connector";
    public static final String LISTEN_TAG = "listening-connector";
    static /* synthetic */ Class class$org$shiftone$jrat$jda$env$EnvPrinter;

    private String rpad(String str, int length) {
        while (str.length() < length) {
            str = str + " ";
        }
        return str;
    }

    private String required(Connector.Argument arg) {
        return arg.mustSpecify() ? "required" : "optional";
    }

    private String dataType(Connector.Argument arg) {
        if (arg instanceof Connector.BooleanArgument) {
            return "boolean";
        }
        if (arg instanceof Connector.IntegerArgument) {
            return "integer";
        }
        if (arg instanceof Connector.StringArgument) {
            return "string";
        }
        if (arg instanceof Connector.SelectedArgument) {
            List<String> choices = ((Connector.SelectedArgument)arg).choices();
            return "selected " + choices;
        }
        return "unknown";
    }

    private void printConnector(String tag, Connector connector, PrintStream out) {
        Map<String, Connector.Argument> args = connector.defaultArguments();
        Iterator<String> keyIterator = args.keySet().iterator();
        out.println("<!-- " + connector.description() + " -->");
        out.println("<!-- Transport : " + connector.transport().name() + " -->");
        out.println("<" + tag + " name=\"" + connector.name() + "\">\n");
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            Connector.Argument value = args.get(key);
            out.println("\t<!-- " + value.label() + " - " + this.required(value) + " " + this.dataType(value) + " -->");
            out.println("\t<!-- " + value.description() + " -->");
            out.print("\t<argument ");
            out.print(this.rpad("name=\"" + key + "\"", 15));
            out.println("value=\"" + value.value() + "\"/>\n");
        }
        out.println("</" + tag + ">\n");
    }

    private void printConnector(Connector connector, PrintStream out) {
        if (connector instanceof LaunchingConnector) {
            this.printConnector(LAUNCH_TAG, connector, out);
        }
        if (connector instanceof AttachingConnector) {
            this.printConnector(ATTACH_TAG, connector, out);
        }
        if (connector instanceof ListeningConnector) {
            this.printConnector(LISTEN_TAG, connector, out);
        }
    }

    public void printAvalibleConfigs() {
        PrintStream out = System.out;
        VirtualMachineManager vmManager = null;
        List<Connector> connectors = null;
        vmManager = Bootstrap.virtualMachineManager();
        connectors = vmManager.allConnectors();
        out.println("<jrat-example-connectors>");
        for (int i = 0; i < connectors.size(); ++i) {
            this.printConnector(connectors.get(i), out);
        }
        out.println("</jrat-example-connectors>");
    }

    public static void main(String[] args) {
        EnvPrinter printer = new EnvPrinter();
        printer.printAvalibleConfigs();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

