/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.chain;

import java.io.InputStream;
import java.util.Stack;
import org.shiftone.jrat.core.ConfigurationException;
import org.shiftone.jrat.core.spi.MethodHandlerFactory;
import org.shiftone.jrat.provider.chain.ChainMethodHandlerFactory;
import org.shiftone.jrat.provider.chain.FactoryMatcher;
import org.shiftone.jrat.provider.chain.MatchCriteria;
import org.shiftone.jrat.util.BeanWrapper;
import org.shiftone.jrat.util.ResourceUtil;
import org.shiftone.jrat.util.XMLUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;
import org.shiftone.jrat.util.log.LoggingSAXErrorHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXConfigurator
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$chain$SAXConfigurator == null ? (class$org$shiftone$jrat$provider$chain$SAXConfigurator = SAXConfigurator.class$("org.shiftone.jrat.provider.chain.SAXConfigurator")) : class$org$shiftone$jrat$provider$chain$SAXConfigurator);
    private static final String ELEMENT_ROOT = "jrat";
    private static final String ELEMENT_HANDLER = "handler";
    private static final String ELEMENT_INCLUDE = "include";
    private static final String ELEMENT_EXCLUDE = "exclude";
    private static final String ELEMENT_FACTORY = "factory";
    private static final String ELEMENT_PROPERTY = "property";
    private Stack tagStack = new Stack();
    private ChainMethodHandlerFactory chainFactory = null;
    private FactoryMatcher currentMatcher = null;
    private MethodHandlerFactory currentFactory = null;
    private BeanWrapper currentFactoryWrapper = null;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$chain$SAXConfigurator;

    public SAXConfigurator(ChainMethodHandlerFactory chainFactory) {
        this.chainFactory = chainFactory;
    }

    private void startHandler() {
        this.currentMatcher = new FactoryMatcher();
    }

    private void startFactory(String className) throws ConfigurationException {
        if (className == null || className.length() == 0) {
            throw new ConfigurationException("<factory> has null or zero lenght 'class' attribute");
        }
        this.currentFactory = (MethodHandlerFactory)ResourceUtil.newInstance(className);
        this.currentFactoryWrapper = new BeanWrapper(this.currentFactory);
    }

    private void addMatchCriteria(boolean include, String classNamePattern, String methodNamePattern, String signaturePattern) {
        MatchCriteria criteria = new MatchCriteria(classNamePattern, methodNamePattern, signaturePattern);
        if (include) {
            this.currentMatcher.addPositiveMatchCriteria(criteria);
        } else {
            this.currentMatcher.addNegativeMatchCriteria(criteria);
        }
    }

    private void addProperty(String name, String value) throws ConfigurationException {
        if (name == null || name.length() == 0) {
            throw new ConfigurationException("<property> has null or zero lenght 'name' attribute");
        }
        this.currentFactoryWrapper.setProperty(name, value);
    }

    private void endHandler() {
        this.chainFactory.addFactoryMatcher(this.currentMatcher);
        this.currentMatcher = null;
    }

    private void endFactory() {
        this.currentMatcher.addFactory(this.currentFactory);
        this.currentFactory = null;
        this.currentFactoryWrapper = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        this.tagStack.push(qName);
        try {
            if (ELEMENT_HANDLER.equals(qName)) {
                this.startHandler();
            } else if (ELEMENT_FACTORY.equals(qName)) {
                this.startFactory(attribs.getValue("class"));
            } else if (ELEMENT_INCLUDE.equals(qName) || ELEMENT_EXCLUDE.equals(qName)) {
                this.addMatchCriteria(ELEMENT_INCLUDE.equals(qName), attribs.getValue("className"), attribs.getValue("methodName"), attribs.getValue("signature"));
            } else if (ELEMENT_PROPERTY.equals(qName)) {
                this.addProperty(attribs.getValue("name"), attribs.getValue("value"));
            }
        }
        catch (ConfigurationException e) {
            LOG.error("tag stack when error occured : " + this.tagStack);
            throw new SAXException("error processing XML configuration", e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ELEMENT_HANDLER.equals(qName)) {
            this.endHandler();
        } else if (ELEMENT_FACTORY.equals(qName)) {
            this.endFactory();
        }
        this.tagStack.pop();
    }

    public static MethodHandlerFactory buildFactory(InputStream inputStream) throws ConfigurationException {
        InputSource inputSource = null;
        ChainMethodHandlerFactory factory = null;
        ChainMethodHandlerFactory chainFactory = null;
        XMLReader xmlReader = null;
        SAXConfigurator configHandler = null;
        try {
            inputSource = new InputSource(inputStream);
            xmlReader = XMLUtil.getXMLReader();
            chainFactory = new ChainMethodHandlerFactory();
            configHandler = new SAXConfigurator(chainFactory);
            xmlReader.setContentHandler(configHandler);
            xmlReader.setErrorHandler(new LoggingSAXErrorHandler());
            xmlReader.parse(inputSource);
            if (chainFactory.getMatcherCount() == 0) {
                LOG.warn("the XML configuration did not create any handlers");
            } else {
                factory = chainFactory;
            }
        }
        catch (Exception e) {
            LOG.error("error building XML configured factory", e);
        }
        if (factory == null) {
            LOG.info("returning NULL handler");
        }
        return factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

