/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.spi.FlushListener;
import org.shiftone.jrat.core.spi.ShutdownListener;
import org.shiftone.jrat.provider.log.io.ThreadInfo;
import org.shiftone.jrat.util.Sequence;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class LogOutput
implements ShutdownListener,
FlushListener {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$log$io$LogOutput == null ? (class$org$shiftone$jrat$provider$log$io$LogOutput = LogOutput.class$("org.shiftone.jrat.provider.log.io.LogOutput")) : class$org$shiftone$jrat$provider$log$io$LogOutput);
    private static final Class VIEWER_CLASS = class$org$shiftone$jrat$provider$log$ui$LogOutputViewerFactory == null ? (class$org$shiftone$jrat$provider$log$ui$LogOutputViewerFactory = LogOutput.class$("org.shiftone.jrat.provider.log.ui.LogOutputViewerFactory")) : class$org$shiftone$jrat$provider$log$ui$LogOutputViewerFactory;
    private static final String VIEWER_TEXT = VIEWER_CLASS.getName();
    public static final int PAGE_SIZE_IN_MESSAGES = 18432;
    public static final byte PREFIX_THREAD = 84;
    public static final byte PREFIX_METHOD = 77;
    public static final byte PREFIX_METHOD_BEGIN = 66;
    public static final byte PREFIX_METHOD_END = 69;
    public static final byte PREFIX_METHOD_ERROR = 82;
    public static final byte PREFIX_CLOSE = 67;
    public static final byte PREFIX_FOOTER = 70;
    public static final byte PREFIX_FOOTER_METHOD_TABLE = 109;
    public static final byte PREFIX_FOOTER_THREAD_TABLE = 116;
    public static final byte PREFIX_FOOTER_OFFSET_TABLE = 111;
    public static final byte EOF = 26;
    private final DataOutputStream out;
    private final ThreadLocal infoThreadLocal;
    private final Sequence logMessageSeq;
    private final Sequence threadSeq;
    private final Map methodMap;
    private final List methodList;
    private final List offsetList;
    private final List threadList;
    private int messagesCounter = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$io$LogOutput;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$ui$LogOutputViewerFactory;

    public LogOutput(OutputStream outputStream, Sequence logMessageSeq) throws IOException {
        this.logMessageSeq = logMessageSeq;
        this.threadSeq = new Sequence();
        this.methodMap = new HashMap();
        this.methodList = new ArrayList(1024);
        this.offsetList = new ArrayList(1024);
        this.threadList = new ArrayList(10);
        this.infoThreadLocal = new ThreadLocal();
        this.out = new DataOutputStream(outputStream);
        this.out.write(StringUtil.toBytes("viewer=\"" + VIEWER_TEXT + "\""));
        this.out.writeByte(13);
        this.out.writeByte(10);
        this.out.writeByte(74);
        this.out.flush();
    }

    private int getMethodId(MethodKey methodKey) throws IOException {
        Integer methodId = (Integer)this.methodMap.get(methodKey);
        if (methodId == null) {
            int id = this.methodMap.size();
            methodId = new Integer(id);
            this.methodMap.put(methodKey, methodId);
            this.methodList.add(id, methodKey);
            this.writeMethodDef(this.out, methodKey, methodId);
        }
        return methodId;
    }

    private synchronized ThreadInfo getThreadInfo() throws IOException {
        ThreadInfo threadInfo = (ThreadInfo)this.infoThreadLocal.get();
        if (threadInfo == null) {
            Thread thread = Thread.currentThread();
            ThreadGroup group = thread.getThreadGroup();
            String groupName = group != null ? group.getName() : "[null]";
            threadInfo = new ThreadInfo();
            threadInfo.name = thread.getName();
            threadInfo.groupName = groupName;
            threadInfo.threadId = this.threadList.size();
            threadInfo.stackDepth = 0;
            LOG.info("getThreadInfo " + threadInfo.threadId);
            this.threadList.add(threadInfo.threadId, threadInfo);
            this.writeThreadDef(this.out, threadInfo);
            this.infoThreadLocal.set(threadInfo);
        }
        return threadInfo;
    }

    private void writeMethodDef(DataOutput output, MethodKey methodKey, int methodId) throws IOException {
        output.writeByte(77);
        output.writeInt(methodId);
        this.writeString(output, methodKey.getClassName());
        this.writeString(output, methodKey.getMethodName());
        this.writeString(output, methodKey.getSignature());
    }

    private void writeThreadDef(DataOutput output, ThreadInfo threadInfo) throws IOException {
        output.writeByte(84);
        output.writeInt(threadInfo.threadId);
        this.writeString(output, threadInfo.groupName);
        this.writeString(output, threadInfo.name);
    }

    private void writeEventPrefix(byte c, ThreadInfo threadInfo, int methodId) throws IOException {
        if (this.messagesCounter % 18432 == 0) {
            this.offsetList.add(new Integer(this.out.size()));
        }
        ++this.messagesCounter;
        this.out.writeByte(c);
        this.out.writeLong(System.currentTimeMillis());
        this.out.writeInt((int)this.logMessageSeq.getNextValue());
        this.out.writeInt(threadInfo.threadId);
        this.out.writeInt(threadInfo.stackDepth);
        this.out.writeInt(methodId);
    }

    public synchronized void writeMethodStart(MethodKey methodKey) throws IOException {
        ThreadInfo threadInfo = this.getThreadInfo();
        int methodId = this.getMethodId(methodKey);
        ++threadInfo.stackDepth;
        this.writeEventPrefix((byte)66, threadInfo, methodId);
    }

    public synchronized void writeMethodFinish(MethodKey methodKey, long duration, boolean success) throws IOException {
        ThreadInfo threadInfo = this.getThreadInfo();
        int methodId = this.getMethodId(methodKey);
        this.writeEventPrefix((byte)69, threadInfo, methodId);
        this.out.writeLong(duration);
        this.out.writeBoolean(success);
        --threadInfo.stackDepth;
    }

    public synchronized void writeMethodError(MethodKey methodKey, Throwable e) throws IOException {
        ThreadInfo threadInfo = this.getThreadInfo();
        int methodId = this.getMethodId(methodKey);
        this.writeEventPrefix((byte)82, threadInfo, methodId);
        this.writeString(this.out, e.getClass().getName());
        this.writeString(this.out, e.getMessage());
    }

    private synchronized void writeClose(DataOutput output) throws IOException {
        output.writeByte(67);
        output.writeLong(System.currentTimeMillis());
        output.writeInt((int)this.logMessageSeq.getNextValue());
    }

    private void writeString(DataOutput output, String text) throws IOException {
        output.writeUTF(text == null ? "" : text);
    }

    public synchronized void flush() {
        LOG.info("flush");
        this.flush();
    }

    public synchronized void shutdown() {
        LOG.info("shutdown");
        try {
            this.flush();
            this.close();
        }
        catch (Exception e) {
            LOG.error("error closing output", e);
        }
    }

    public synchronized void close() throws IOException {
        this.writeClose(this.out);
        this.writeFooter();
        this.out.flush();
        this.out.close();
    }

    private void writeFooter() throws IOException {
        ByteArrayOutputStream buffOut = null;
        DataOutputStream footer = null;
        byte[] buff = null;
        int footerStartOffset = this.out.size();
        buffOut = new ByteArrayOutputStream();
        footer = new DataOutputStream(buffOut);
        this.writeFooterThreadTable(footer);
        this.writeFooterMethodTable(footer);
        this.writeClose(footer);
        this.writeFooterOffsetTable(footer);
        footer.flush();
        buff = buffOut.toByteArray();
        this.out.write(buff);
        this.out.writeInt(footerStartOffset);
        this.out.writeByte(26);
        LOG.info("footer wrote successfully");
    }

    private void writeFooterMethodTable(DataOutput footer) throws IOException {
        MethodKey methodKey = null;
        int size = this.methodList.size();
        for (int i = 0; i < size; ++i) {
            methodKey = (MethodKey)this.methodList.get(i);
            this.writeMethodDef(footer, methodKey, i);
        }
    }

    private void writeFooterThreadTable(DataOutput footer) throws IOException {
        ThreadInfo threadInfo = null;
        int size = this.threadList.size();
        for (int i = 0; i < size; ++i) {
            threadInfo = (ThreadInfo)this.threadList.get(i);
            this.writeThreadDef(footer, threadInfo);
        }
    }

    private void writeFooterOffsetTable(DataOutput footer) throws IOException {
        Integer offset = null;
        int size = this.offsetList.size();
        footer.writeByte(111);
        footer.writeInt(18432);
        footer.writeInt(this.messagesCounter);
        footer.writeInt(size);
        for (int i = 0; i < size; ++i) {
            offset = (Integer)this.offsetList.get(i);
            footer.writeInt(offset);
        }
    }

    public String toString() {
        return "LogOutput";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

