/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.io.message;

import java.io.DataInput;
import java.io.IOException;
import org.shiftone.jrat.provider.log.io.LogInput;
import org.shiftone.jrat.provider.log.io.message.MethodMessage;
import org.shiftone.jrat.util.StringUtil;

public class FinishMessage
extends MethodMessage {
    private final long duration;
    private final boolean success;

    public FinishMessage(LogInput logIn, DataInput in) throws IOException {
        super(logIn, in);
        this.duration = in.readLong();
        this.success = in.readBoolean();
    }

    public String toString() {
        String verb = this.success ? " succeeded in " : " failed in ";
        return super.toString() + verb + this.duration + " ms ";
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getText() {
        return this.duration == 0L ? "exited" : "exited after " + StringUtil.durationToString(this.duration);
    }
}

