/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.io.message;

import java.io.DataInput;
import java.io.IOException;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.log.io.LogInput;
import org.shiftone.jrat.provider.log.io.message.Message;
import org.shiftone.jrat.util.StringUtil;

public abstract class MethodMessage
implements Message {
    private final LogInput logIn;
    private final long timeMs;
    private final int messageId;
    private final int threadId;
    private final int threadDepth;
    private final int methodId;
    private String threadName;
    private MethodKey methodKey;

    public MethodMessage(LogInput logIn, DataInput in) throws IOException {
        this.logIn = logIn;
        this.timeMs = in.readLong();
        this.messageId = in.readInt();
        this.threadId = in.readInt();
        this.threadDepth = in.readInt();
        this.methodId = in.readInt();
    }

    public String toString() {
        return StringUtil.hex(this.messageId) + " [" + this.getThreadName() + "] " + StringUtil.dateToString(this.timeMs) + " " + this.threadDepth + " " + this.getMethodKey().getMethodName();
    }

    public long getMessageId() {
        return this.messageId;
    }

    public MethodKey getMethodKey() {
        if (this.methodKey == null) {
            this.methodKey = this.logIn.getMethodKey(this.methodId);
        }
        return this.methodKey;
    }

    public int getThreadDepth() {
        return this.threadDepth;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = this.logIn.getThreadName(this.threadId);
        }
        return this.threadName;
    }

    public long getTimeMs() {
        return this.timeMs;
    }

    public abstract String getText();
}

