/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.log.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.log.io.RandomAccessLogFile;
import org.shiftone.jrat.provider.log.io.message.Message;
import org.shiftone.jrat.provider.log.io.message.MethodMessage;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class LogFileTableModel
implements TableModel {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$log$ui$LogFileTableModel == null ? (class$org$shiftone$jrat$provider$log$ui$LogFileTableModel = LogFileTableModel.class$("org.shiftone.jrat.provider.log.ui.LogFileTableModel")) : class$org$shiftone$jrat$provider$log$ui$LogFileTableModel);
    private static final String DATE_FORMAT = "yy.MM.dd HH:mm:ss,SSS";
    private static final String[] COLUMN_NAMES = new String[]{"Seq ID", "Thread", "Time", "Class", "Method", "Depth", "Message"};
    private final DateFormat format = new SimpleDateFormat("yy.MM.dd HH:mm:ss,SSS");
    private final RandomAccessLogFile logFile;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$log$ui$LogFileTableModel;
    static /* synthetic */ Class class$java$lang$String;

    LogFileTableModel(RandomAccessLogFile logFile) {
        this.logFile = logFile;
    }

    public Class getColumnClass(int columnIndex) {
        return class$java$lang$String == null ? (class$java$lang$String = LogFileTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return 7;
    }

    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    public int getRowCount() {
        return (int)this.logFile.getMethodMessageCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            Message message = this.logFile.getMessage(rowIndex);
            if (message == null) {
                return "";
            }
            if (columnIndex == 0) {
                return "0x" + Long.toHexString(message.getMessageId());
            }
            if (columnIndex == 2) {
                return this.format.format(new Date(message.getTimeMs()));
            }
            if (message instanceof MethodMessage) {
                MethodMessage methodMessage = (MethodMessage)message;
                MethodKey method = methodMessage.getMethodKey();
                switch (columnIndex) {
                    case 1: {
                        return methodMessage.getThreadName();
                    }
                    case 3: {
                        return method.getClassName();
                    }
                    case 4: {
                        return method.getMethodName() + " " + method.getSignature();
                    }
                    case 5: {
                        return String.valueOf(methodMessage.getThreadDepth());
                    }
                    case 6: {
                        return String.valueOf(methodMessage.getText());
                    }
                }
                return "";
            }
            return rowIndex + "x" + columnIndex;
        }
        catch (Exception e) {
            LOG.info("error getValueAt", e);
            return "ERROR:" + e.getClass().getName() + " " + e.getMessage();
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

