/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.rate;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.spi.AbstractMethodHandlerFactory;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.provider.rate.RateMethodHandler;
import org.shiftone.jrat.provider.rate.RateOutput;
import org.shiftone.jrat.provider.rate.RateTimerTask;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class RateMethodHandlerFactory
extends AbstractMethodHandlerFactory {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$rate$RateMethodHandlerFactory == null ? (class$org$shiftone$jrat$provider$rate$RateMethodHandlerFactory = RateMethodHandlerFactory.class$("org.shiftone.jrat.provider.rate.RateMethodHandlerFactory")) : class$org$shiftone$jrat$provider$rate$RateMethodHandlerFactory);
    private static final Runtime RT = Runtime.getRuntime();
    private Timer timer = new Timer(true);
    private RateTimerTask task = new RateTimerTask(this);
    private RateMethodHandler[] handlers = null;
    private RateOutput output = null;
    private boolean startupSucceeded = false;
    private int handlerMax = 100;
    private long period = 10000L;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$rate$RateMethodHandlerFactory;

    public synchronized MethodHandler createMethodHandler(MethodKey methodKey) {
        RateMethodHandler handler = null;
        int methodCount = this.output.getMethodCount();
        if (!this.startupSucceeded) {
            LOG.info("startup failed, returning null handler");
        } else if (methodCount >= this.handlerMax) {
            LOG.info("handler max (" + this.handlerMax + ") exceeded, returning null handler");
        } else {
            handler = this.handlers[methodCount] = new RateMethodHandler(methodKey);
            try {
                this.output.printMethodDef(methodKey);
            }
            catch (Exception e) {
                LOG.error("error writing method def : " + methodKey, e);
            }
        }
        return handler;
    }

    public void startup(RuntimeContext context) throws Exception {
        super.startup(context);
        OutputStream outputStream = null;
        this.handlers = new RateMethodHandler[this.handlerMax];
        try {
            outputStream = context.newOutputStream(this.getOutputFile() + ".jrat", this.isCompressOutput());
            this.output = new RateOutput(outputStream, this.handlerMax, context);
            this.output.printHeader(this.period);
            context.addShutdownListener(this);
            this.timer.schedule((TimerTask)this.task, this.period, this.period);
            this.startupSucceeded = true;
        }
        catch (Exception e) {
            this.output.close();
            throw e;
        }
    }

    public void writeSample() throws IOException {
        this.output.printSample(this.handlers);
    }

    public void shutdown() {
        Object methodKey = null;
        this.timer.cancel();
        this.task.cancel();
        try {
            this.output.close();
        }
        catch (Exception e) {
            LOG.error("error closing output", e);
        }
    }

    public String toString() {
        return "Rate Handler Factory";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

