/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.test;

import java.io.IOException;
import java.io.OutputStream;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class DebugOutputStream
extends OutputStream {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$test$DebugOutputStream == null ? (class$org$shiftone$jrat$test$DebugOutputStream = DebugOutputStream.class$("org.shiftone.jrat.test.DebugOutputStream")) : class$org$shiftone$jrat$test$DebugOutputStream);
    private OutputStream outputStream = null;
    private long callNumber = 0L;
    private long total = 0L;
    static /* synthetic */ Class class$org$shiftone$jrat$test$DebugOutputStream;

    public DebugOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void write(byte[] b) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("write(byte[]");
        for (int i = 0; i < b.length; ++i) {
            sb.append(" ");
            sb.append(Integer.toHexString(b[i]));
            this.total += (long)b[i];
        }
        sb.append(")");
        LOG.info(this.callNumber++ + " " + sb + " T=" + this.total);
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("write(byte[] ");
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
            sb.append(Integer.toHexString(b[i + off]));
            this.total += (long)b[i + off];
        }
        sb.append(", " + off + ", " + len + ")");
        LOG.info(this.callNumber++ + " " + sb + " T=" + this.total);
        this.outputStream.write(b, off, len);
    }

    public void flush() throws IOException {
        LOG.info("flush()");
        this.outputStream.flush();
    }

    public void close() throws IOException {
        LOG.info("close()");
        this.outputStream.close();
    }

    public void write(int b) throws IOException {
        this.total += (long)b;
        LOG.info(this.callNumber++ + " write(" + Integer.toHexString(b) + ") T=" + this.total);
        this.outputStream.write(b);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

