/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import org.shiftone.jrat.ui.UIConstants;
import org.shiftone.jrat.ui.action.ExitAction;
import org.shiftone.jrat.ui.action.RemoveAllTabsAction;
import org.shiftone.jrat.ui.action.RemoveCurrentTabAction;
import org.shiftone.jrat.ui.action.ResizeAction;
import org.shiftone.jrat.ui.action.SpawnFrameAction;
import org.shiftone.jrat.ui.help.AboutAction;
import org.shiftone.jrat.ui.help.ShowDocsAction;
import org.shiftone.jrat.ui.inject.InjectDirAction;
import org.shiftone.jrat.ui.inject.InjectJarAction;
import org.shiftone.jrat.ui.inject.InjectionManager;
import org.shiftone.jrat.ui.util.StatusBar;
import org.shiftone.jrat.ui.viewer.OpenOutputFileAction;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class DesktopFrame
extends JFrame
implements UIConstants,
ContainerListener {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$DesktopFrame == null ? (class$org$shiftone$jrat$ui$DesktopFrame = DesktopFrame.class$("org.shiftone.jrat.ui.DesktopFrame")) : class$org$shiftone$jrat$ui$DesktopFrame);
    private InjectionManager injectionManager = new InjectionManager(this);
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu(UIConstants.MENU_FILE);
    private JMenu windowMenu = new JMenu(UIConstants.MENU_WINDOW);
    private JMenu injectMenu = new JMenu(UIConstants.MENU_INSTRUMENT);
    private JMenu helpMenu = new JMenu(UIConstants.MENU_HELP);
    private StatusBar statusBar = new StatusBar();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JMenuItem open = new JMenuItem(UIConstants.MENU_OPEN);
    private JMenuItem close = new JMenuItem(UIConstants.MENU_CLOSE);
    private JMenuItem closeAll = new JMenuItem(UIConstants.MENU_CLOSE_ALL);
    private JMenuItem spawn = new JMenuItem(UIConstants.MENU_SPAWN);
    private JMenuItem exit = new JMenuItem(UIConstants.MENU_EXIT);
    private JMenuItem injectFile = new JMenuItem(UIConstants.MENU_INJECT_JAR);
    private JMenuItem injectDir = new JMenuItem(UIConstants.MENU_INJECT_DIR);
    private JMenuItem docs = new JMenuItem(UIConstants.MENU_DOCS);
    private JMenuItem about = new JMenuItem(UIConstants.MENU_ABOUT);
    private JMenuItem resize640x480 = new JMenuItem(UIConstants.MENU_640X480);
    private JMenuItem resize800x600 = new JMenuItem(UIConstants.MENU_800x600);
    static /* synthetic */ Class class$org$shiftone$jrat$ui$DesktopFrame;

    public DesktopFrame() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.statusBar, "South");
        pane.add((Component)this.tabbedPane, "Center");
        this.addMenuBar();
        this.setDimension();
        this.setTitle(UIConstants.UI_TITLE);
        this.setDefaultCloseOperation(3);
    }

    public void addMenuBar() {
        this.fileMenu.add(this.open);
        this.fileMenu.add(this.close);
        this.fileMenu.add(this.closeAll);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exit);
        this.fileMenu.setMnemonic('F');
        this.open.setMnemonic('O');
        this.exit.setMnemonic('X');
        this.windowMenu.add(this.spawn);
        this.windowMenu.add(this.resize640x480);
        this.windowMenu.add(this.resize800x600);
        this.windowMenu.setMnemonic('W');
        this.injectMenu.add(this.injectFile);
        this.injectMenu.add(this.injectDir);
        this.injectMenu.setMnemonic(73);
        this.helpMenu.add(this.docs);
        this.helpMenu.add(this.about);
        this.helpMenu.setMnemonic(72);
        this.about.setMnemonic(65);
        this.docs.setMnemonic(72);
        this.open.addActionListener(new OpenOutputFileAction(this, this.tabbedPane, this.statusBar.getProgressBar()));
        this.close.addActionListener(new RemoveCurrentTabAction(this.tabbedPane));
        this.closeAll.addActionListener(new RemoveAllTabsAction(this.tabbedPane));
        this.spawn.addActionListener(new SpawnFrameAction(this.tabbedPane));
        this.exit.addActionListener(new ExitAction());
        this.injectFile.addActionListener(new InjectJarAction(this.injectionManager, this));
        this.injectDir.addActionListener(new InjectDirAction(this.injectionManager, this));
        this.docs.addActionListener(new ShowDocsAction());
        this.about.addActionListener(new AboutAction(this));
        this.resize640x480.addActionListener(new ResizeAction(this, 640, 480));
        this.resize800x600.addActionListener(new ResizeAction(this, 800, 600));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.windowMenu);
        this.menuBar.add(this.injectMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.tabbedPane.addContainerListener(this);
        this.tabbedCountChanged(0);
    }

    public void componentAdded(ContainerEvent e) {
        this.tabbedCountChanged(this.tabbedPane.getTabCount());
    }

    public void componentRemoved(ContainerEvent e) {
        this.tabbedCountChanged(this.tabbedPane.getTabCount() - 1);
    }

    private void tabbedCountChanged(int tabCount) {
        boolean hasTabs = tabCount > 0;
        this.close.setEnabled(hasTabs);
        this.closeAll.setEnabled(hasTabs);
        this.spawn.setEnabled(hasTabs);
    }

    private void setDimension() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        int width = (int)(screenSize.getWidth() * (double)0.8f);
        int height = (int)(screenSize.getHeight() * (double)0.8f);
        int x = (int)(screenSize.getWidth() / 2.0 - (double)(width / 2));
        int y = (int)(screenSize.getHeight() / 2.0 - (double)(height / 2));
        this.setLocation(x, y);
        this.setSize(width, height);
    }

    public void setEnabled(boolean isEnable) {
        if (isEnable) {
            this.menuBar.setEnabled(true);
            this.getContentPane().setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.menuBar.setEnabled(false);
            this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

