/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.inject;

import java.awt.Frame;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.shiftone.jrat.ui.UIConstants;
import org.shiftone.jrat.util.GlobClassLoader;
import org.shiftone.jrat.util.NestedRuntimeException;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class InjectionManager
implements UIConstants {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$inject$InjectionManager == null ? (class$org$shiftone$jrat$ui$inject$InjectionManager = InjectionManager.class$("org.shiftone.jrat.ui.inject.InjectionManager")) : class$org$shiftone$jrat$ui$inject$InjectionManager);
    private static final ClassLoader PARENT_LOADER = (class$org$shiftone$jrat$ui$inject$InjectionManager == null ? (class$org$shiftone$jrat$ui$inject$InjectionManager = InjectionManager.class$("org.shiftone.jrat.ui.inject.InjectionManager")) : class$org$shiftone$jrat$ui$inject$InjectionManager).getClassLoader();
    private static final String INJECTOR_CLASS = (class$org$shiftone$jrat$inject$Injector == null ? (class$org$shiftone$jrat$inject$Injector = InjectionManager.class$("org.shiftone.jrat.inject.Injector")) : class$org$shiftone$jrat$inject$Injector).getName();
    private Frame parentFrame = null;
    private Object injector = null;
    private Class injectorClass = null;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$inject$InjectionManager;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$Injector;
    static /* synthetic */ Class class$java$io$File;

    public InjectionManager(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void inject(File file) throws Exception {
        LOG.info("inject " + file);
        if (this.canProceed()) {
            Method method = this.injectorClass.getMethod("inject", class$java$io$File == null ? (class$java$io$File = InjectionManager.class$("java.io.File")) : class$java$io$File);
            try {
                method.invoke(this.injector, file);
            }
            catch (Exception e) {
                throw new NestedRuntimeException("injection error", e);
            }
        }
    }

    public boolean setInjector(ClassLoader loader) {
        Boolean success = Boolean.FALSE;
        Method method = null;
        Object ret = null;
        Exception exception = null;
        LOG.info("setInjector()");
        try {
            this.injectorClass = loader.loadClass(INJECTOR_CLASS);
            this.injector = this.injectorClass.newInstance();
            method = this.injectorClass.getMethod("setForceOverwrite", Boolean.TYPE);
            ret = method.invoke(this.injector, Boolean.TRUE);
            method = this.injectorClass.getMethod("isBCELPresent", new Class[0]);
            ret = method.invoke(this.injector, new Object[0]);
            success = (Boolean)ret;
        }
        catch (Exception e) {
            LOG.info("error creating Processor", e);
            exception = e;
        }
        if (!success.booleanValue()) {
            this.injectorClass = null;
            this.injector = null;
            if (exception == null) {
                exception = new Exception("Processor is unable to access BCEL");
            }
        }
        return success;
    }

    public boolean setInjectorWithJarFile(File bcelJar) {
        boolean result = false;
        try {
            LOG.info("setWithJarFile");
            GlobClassLoader loader = new GlobClassLoader(bcelJar, "org.shiftone.jrat.inject.*", PARENT_LOADER);
            result = this.setInjector(loader);
        }
        catch (Exception e) {
            LOG.info("setInjectorWithJarFile", e);
        }
        return result;
    }

    public boolean setInjectorWithDefaultClassLoader() {
        LOG.info("setWithDefaultClassLoader");
        return this.setInjector(PARENT_LOADER);
    }

    public boolean setInjectorWithUserSelection() {
        File file = null;
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter(UIConstants.BCEL_FILE_FILTER);
        if (0 == chooser.showOpenDialog(this.parentFrame)) {
            file = chooser.getSelectedFile();
            LOG.info(file.getAbsolutePath());
            if (this.setInjectorWithJarFile(file)) {
                UIConstants.SETTINGS.setBcelJarFile(file);
                return true;
            }
            JOptionPane.showMessageDialog(this.parentFrame, UIConstants.BAD_BCEL_MSG, UIConstants.BAD_BCEL_TITLE, 0);
        }
        return false;
    }

    public boolean canProceed() {
        File jarFile = UIConstants.SETTINGS.getBcelJarFile();
        if (this.injectorClass != null && this.injector != null) {
            return true;
        }
        if (this.setInjectorWithDefaultClassLoader()) {
            return true;
        }
        if (jarFile != null && this.setInjectorWithJarFile(jarFile)) {
            return true;
        }
        int choice = JOptionPane.showOptionDialog(this.parentFrame, UIConstants.PICK_BCEL_MSG, UIConstants.PICK_BCEL_TITLE, 0, 3, null, new Object[]{UIConstants.YES, UIConstants.NO}, null);
        if (choice == 0) {
            return this.setInjectorWithUserSelection();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

