/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.shiftone.jrat.util.Percent;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class PercentTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$util$PercentTableCellRenderer == null ? (class$org$shiftone$jrat$ui$util$PercentTableCellRenderer = PercentTableCellRenderer.class$("org.shiftone.jrat.ui.util.PercentTableCellRenderer")) : class$org$shiftone$jrat$ui$util$PercentTableCellRenderer);
    private Object value = null;
    private DecimalFormat floatDecimalFormat = new DecimalFormat("#,##0.00");
    private DecimalFormat doubleDecimalFormat = new DecimalFormat("#,##0.0000");
    private DecimalFormat longDecimalFormat = new DecimalFormat("###,###,###");
    private static final Color COLOR_XOR = new Color(0x333300);
    static /* synthetic */ Class class$org$shiftone$jrat$ui$util$PercentTableCellRenderer;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.value = value;
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.value instanceof Percent) {
            double pct = ((Percent)this.value).doubleValue();
            if (pct > 100.0) {
                pct = 100.0;
            }
            int w = (int)((double)this.getWidth() * pct / 100.0);
            g.setXORMode(COLOR_XOR);
            g.fillRect(0, 0, w, this.getHeight());
        }
    }

    protected synchronized void setValue(Object value) {
        if (value == null) {
            value = "";
        } else if (value instanceof Number) {
            this.setHorizontalAlignment(4);
            Number num = (Number)value;
            if (value instanceof Integer || value instanceof Long) {
                value = this.longDecimalFormat.format(num);
            } else if (value instanceof Float) {
                value = this.floatDecimalFormat.format(num);
            } else if (value instanceof Double) {
                value = this.doubleDecimalFormat.format(num);
            }
        }
        super.setValue(value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

