/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.util.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.shiftone.jrat.ui.util.graph.GraphModel;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class GraphModelSet {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$util$graph$GraphModelSet == null ? (class$org$shiftone$jrat$ui$util$graph$GraphModelSet = GraphModelSet.class$("org.shiftone.jrat.ui.util.graph.GraphModelSet")) : class$org$shiftone$jrat$ui$util$graph$GraphModelSet);
    private Set listeners = new HashSet();
    private Long maxValue = null;
    private Long minValue = null;
    private Integer maxPointCount = null;
    private Map graphMap = new HashMap();
    private Map hiddenMap = new HashMap();
    private List graphs = new ArrayList();
    private String title = null;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$util$graph$GraphModelSet;

    private void invalidateCache() {
        this.maxValue = null;
        this.maxPointCount = null;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireModelChanged() {
        Iterator iterator = this.listeners.iterator();
        ChangeEvent event = new ChangeEvent(this);
        this.invalidateCache();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(event);
        }
    }

    public int getGraphModelCount() {
        return this.graphs.size();
    }

    public long getMaxValue() {
        if (this.maxValue == null) {
            this.init();
        }
        return this.maxValue;
    }

    public long getMinValue() {
        if (this.minValue == null) {
            this.init();
        }
        return this.minValue;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void init() {
        GraphModel model = null;
        long max = 0L;
        long min = 0L;
        if (this.getGraphModelCount() > 0) {
            model = this.getGraphModel(0);
            max = model.getMaxValue();
            min = model.getMinValue();
            for (int i = 1; i < this.getGraphModelCount(); ++i) {
                model = this.getGraphModel(i);
                max = Math.max(max, model.getMaxValue());
                min = Math.min(min, model.getMinValue());
            }
        }
        this.maxValue = new Long(max);
        this.minValue = new Long(min);
    }

    public int getMaxPointCount() {
        GraphModel model = null;
        int max = 0;
        if (this.maxPointCount == null) {
            for (int i = 0; i < this.getGraphModelCount(); ++i) {
                model = this.getGraphModel(i);
                max = Math.max(max, model.getPointCount());
            }
            this.maxPointCount = new Integer(max);
        }
        return this.maxPointCount;
    }

    public GraphModel getGraphModel(int index) {
        return (GraphModel)this.graphs.get(index);
    }

    public synchronized void add(Object key, GraphModel graphModel) {
        if (!this.graphMap.containsKey(key)) {
            this.graphMap.put(key, graphModel);
            this.graphs.add(graphModel);
            this.fireModelChanged();
        }
    }

    public synchronized void remove(Object key) {
        if (this.graphMap.containsKey(key)) {
            this.graphs.remove(this.graphMap.get(key));
            this.graphMap.remove(key);
            this.fireModelChanged();
        }
    }

    public synchronized void hide(Object key) {
        if (this.graphMap.containsKey(key)) {
            this.hiddenMap.put(key, this.graphMap.get(key));
            this.graphs.remove(this.graphMap.get(key));
            this.fireModelChanged();
        }
    }

    public synchronized void unhide(Object key) {
        if (this.hiddenMap.containsKey(key)) {
            this.graphs.add(this.hiddenMap.get(key));
            this.hiddenMap.remove(key);
            this.fireModelChanged();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

