/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.shiftone.jrat.core.ConfigurationException;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class BeanWrapper {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$BeanWrapper == null ? (class$org$shiftone$jrat$util$BeanWrapper = BeanWrapper.class$("org.shiftone.jrat.util.BeanWrapper")) : class$org$shiftone$jrat$util$BeanWrapper);
    private Object bean = null;
    private Class klass = null;
    private Map setters = null;
    private Map getters = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$BeanWrapper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;

    public BeanWrapper(Object obj) {
        Assert.assertNotNull("target", obj);
        this.initialize(obj);
    }

    public Object getBean() {
        return this.bean;
    }

    private void initialize(Object obj) {
        this.bean = obj;
        this.klass = obj.getClass();
        this.setters = new HashMap();
        this.getters = new HashMap();
        Method[] methods = this.klass.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE) {
                this.getters.put(method.getName().substring(3).toUpperCase(), method);
            }
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) continue;
            this.setters.put(method.getName().substring(3).toUpperCase(), method);
        }
    }

    public void setProperty(String key, String value) throws ConfigurationException {
        Method method = null;
        Class<?> targetType = null;
        Object valueObject = null;
        LOG.debug("setProperty(" + key + "," + value + ")");
        method = (Method)this.setters.get(key.toUpperCase());
        if (method != null) {
            targetType = method.getParameterTypes()[0];
            valueObject = this.convert(value, targetType);
            try {
                method.invoke(this.bean, valueObject);
            }
            catch (Exception e) {
                throw new ConfigurationException("error setting property : " + key, e);
            }
        } else {
            throw new ConfigurationException("no set method for '" + key + "' in class '" + this.klass.getName() + "'");
        }
    }

    private Object convert(String val, Class type) throws ConfigurationException {
        Assert.assertNotNull("value", val);
        String v = val.trim();
        if (val == null) {
            return null;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = BeanWrapper.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(type)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type) || (class$java$lang$Integer == null ? (class$java$lang$Integer = BeanWrapper.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(type)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type) || (class$java$lang$Long == null ? (class$java$lang$Long = BeanWrapper.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(type)) {
            return new Long(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type) || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanWrapper.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        }
        throw new ConfigurationException("unable to convert '" + v + "' to '" + type.getClass().getName() + "'");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getProperty(String key) throws ConfigurationException {
        Method method = null;
        Object valueObject = null;
        String stringValue = null;
        LOG.debug("getProperty(" + key + ")");
        method = (Method)this.getters.get(key.toUpperCase());
        if (method == null) throw new ConfigurationException("no get method for '" + key + "' in class '" + this.klass.getName() + "'");
        try {
            valueObject = method.invoke(this.bean, new Object[0]);
            if (valueObject == null) return stringValue;
            return String.valueOf(valueObject);
        }
        catch (Exception e) {
            throw new ConfigurationException("error getting property : " + key, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

