/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import org.shiftone.jrat.core.ParseException;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class Accumulator {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$Accumulator == null ? (class$org$shiftone$jrat$core$Accumulator = Accumulator.class$("org.shiftone.jrat.core.Accumulator")) : class$org$shiftone$jrat$core$Accumulator);
    private long totalEnters = 0L;
    private long totalExits = 0L;
    private long totalErrors = 0L;
    private long totalDuration = 0L;
    private long totalOfSquares = 0L;
    private long maxDuration = 0L;
    private long minDuration = Long.MAX_VALUE;
    private int concurThreads = 0;
    private int maxConcurThreads = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$core$Accumulator;

    public Accumulator() {
    }

    public Accumulator(long totalEnters, long totalExits, long totalErrors, long totalDuration, long totalOfSquares, long maxDuration, long minDuration, int maxConcurThreads) {
        this.setStatistics(totalEnters, totalExits, totalErrors, totalDuration, totalOfSquares, maxDuration, minDuration, maxConcurThreads);
    }

    public void setStatistics(long totalEnters, long totalExits, long totalErrors, long totalDuration, long totalOfSquares, long maxDuration, long minDuration, int maxConcurThreads) {
        this.totalEnters = totalEnters;
        this.totalExits = totalExits;
        this.totalErrors = totalErrors;
        this.totalDuration = totalDuration;
        this.totalOfSquares = totalOfSquares;
        this.maxDuration = maxDuration;
        this.minDuration = minDuration;
        this.maxConcurThreads = maxConcurThreads;
    }

    public final synchronized void onMethodStart() {
        ++this.totalEnters;
        ++this.concurThreads;
        if (this.concurThreads > this.maxConcurThreads) {
            this.maxConcurThreads = this.concurThreads;
        }
    }

    public final synchronized void onMethodFinish(long duration, boolean success) {
        ++this.totalExits;
        this.totalDuration += duration;
        this.totalOfSquares += duration * duration;
        if (!success) {
            ++this.totalErrors;
        }
        if (duration < this.minDuration) {
            this.minDuration = duration;
        }
        if (duration > this.maxDuration) {
            this.maxDuration = duration;
        }
        --this.concurThreads;
    }

    public final Float getAverageDuration() {
        Float average = null;
        if (this.totalExits > 0L) {
            average = new Float((double)this.totalDuration / (double)this.totalExits);
        }
        return average;
    }

    public final Double getStdDeviation() {
        Double stdDeviation = null;
        if (this.totalExits > 1L) {
            double numerator = (double)this.totalOfSquares - (double)(this.totalDuration * this.totalDuration) / (double)this.totalExits;
            double denominator = (double)this.totalExits - 1.0;
            stdDeviation = new Double(Math.sqrt(numerator / denominator));
        }
        return stdDeviation;
    }

    public final long getTotalEnters() {
        return this.totalEnters;
    }

    public final long getTotalExits() {
        return this.totalExits;
    }

    public final Long getMinDuration() {
        return this.totalExits == 0L ? null : new Long(this.minDuration);
    }

    public final Long getMaxDuration() {
        return this.totalExits == 0L ? null : new Long(this.maxDuration);
    }

    public final long getTotalDuration() {
        return this.totalDuration;
    }

    public final long getSumOfSquares() {
        return this.totalOfSquares;
    }

    public final long getTotalErrors() {
        return this.totalErrors;
    }

    public int getMaxConcurrentThreads() {
        return this.maxConcurThreads;
    }

    public static String toCSV(Accumulator acc) {
        StringBuffer sb = new StringBuffer(100);
        sb.append(acc.totalEnters);
        sb.append(',');
        sb.append(acc.totalExits);
        sb.append(',');
        sb.append(acc.totalErrors);
        sb.append(',');
        sb.append(acc.totalDuration);
        sb.append(',');
        sb.append(acc.totalOfSquares);
        sb.append(',');
        sb.append(acc.maxConcurThreads);
        if (acc.totalExits != 0L) {
            sb.append(',');
            sb.append(acc.maxDuration);
            sb.append(',');
            sb.append(acc.minDuration);
        }
        return sb.toString();
    }

    public static Accumulator fromCSV(String csv, Accumulator acc) throws ParseException {
        String[] tokens = StringUtil.tokenize(csv, ",", false);
        if (tokens.length != 6 && tokens.length != 8) {
            throw new ParseException("accumulator CSV must contain 6 or 8 tokens : " + tokens.length + " in " + csv);
        }
        if (tokens.length >= 6) {
            acc.totalEnters = Long.parseLong(tokens[0]);
            acc.totalExits = Long.parseLong(tokens[1]);
            acc.totalErrors = Long.parseLong(tokens[2]);
            acc.totalDuration = Long.parseLong(tokens[3]);
            acc.totalOfSquares = Long.parseLong(tokens[4]);
            acc.maxConcurThreads = Integer.parseInt(tokens[5]);
        }
        if (tokens.length == 8) {
            acc.maxDuration = Long.parseLong(tokens[6]);
            acc.minDuration = Long.parseLong(tokens[7]);
        }
        return acc;
    }

    public static Accumulator fromCSV(String csv) throws ParseException {
        return Accumulator.fromCSV(csv, new Accumulator());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

