/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import org.shiftone.jrat.core.FlushHook;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.RootFactory;
import org.shiftone.jrat.core.RuntimeContextImpl;
import org.shiftone.jrat.core.ShutdownHook;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.core.spi.MethodHandlerFactory;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.provider.silent.SilentMethodHandler;
import org.shiftone.jrat.util.MethodWrapper;
import org.shiftone.jrat.util.SignatureUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class InternalHandler {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$core$InternalHandler == null ? (class$org$shiftone$jrat$core$InternalHandler = InternalHandler.class$("org.shiftone.jrat.core.InternalHandler")) : class$org$shiftone$jrat$core$InternalHandler);
    public static final MethodHandlerFactory DEFAULT_HANDLER_FACTORY = SilentMethodHandler.HANDLER_FACTORY;
    public static final MethodHandler DEFAULT_METHOD_HANDLER = SilentMethodHandler.METHOD_HANDLER;
    private MethodHandlerFactory rootHandlerFactory;
    private final RuntimeContext runtimeContext;
    private final ShutdownHook shutdownHook = new ShutdownHook();
    private final FlushHook flushHook = new FlushHook();
    private final RootFactory rootFactory;
    private final Map handlerCache;
    private final Map methodCache;
    static /* synthetic */ Class class$org$shiftone$jrat$core$InternalHandler;

    public InternalHandler() {
        this.runtimeContext = new RuntimeContextImpl(this.shutdownHook, this.flushHook);
        this.rootFactory = new RootFactory();
        this.handlerCache = new Hashtable();
        this.methodCache = new Hashtable();
        this.rootHandlerFactory = this.rootFactory.getHandlerFactory();
        try {
            this.rootHandlerFactory.startup(this.runtimeContext);
        }
        catch (Exception e) {
            this.rootHandlerFactory = DEFAULT_HANDLER_FACTORY;
            LOG.error("There was an error starting up a handler factory", e);
            LOG.info("JRat will ignore all configuration and use the slient handler");
        }
    }

    public final synchronized MethodHandler getMethodHandler(MethodKey methodKey) {
        MethodHandler methodHandler = null;
        methodHandler = (MethodHandler)this.handlerCache.get(methodKey);
        if (methodHandler == null) {
            methodHandler = this.rootHandlerFactory.createMethodHandler(methodKey);
            if (methodHandler == null) {
                methodHandler = DEFAULT_METHOD_HANDLER;
            }
            this.handlerCache.put(methodKey, methodHandler);
        }
        return methodHandler;
    }

    public final synchronized MethodHandler getMethodHandler(Method method) {
        MethodHandler methodHandler = null;
        MethodWrapper key = new MethodWrapper(method);
        methodHandler = (MethodHandler)this.methodCache.get(key);
        if (methodHandler == null) {
            String className = method.getDeclaringClass().getName();
            String methodName = method.getName();
            String signature = SignatureUtil.getSignature(method);
            methodHandler = this.getMethodHandler(new MethodKey(className, methodName, signature));
            this.methodCache.put(key, methodHandler);
        }
        return methodHandler;
    }

    public final synchronized MethodHandler getMethodHandler(Constructor constructor) {
        MethodHandler methodHandler = null;
        methodHandler = (MethodHandler)this.methodCache.get(constructor);
        if (methodHandler == null) {
            String className = constructor.getDeclaringClass().getName();
            String methodName = constructor.getName();
            String signature = SignatureUtil.getSignature(constructor);
            methodHandler = this.getMethodHandler(new MethodKey(className, methodName, signature));
            this.methodCache.put(constructor, methodHandler);
        }
        return methodHandler;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

