/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.shiftone.jrat.inject.Injector;
import org.shiftone.jrat.inject.ant.AbstractFileTask;
import org.shiftone.jrat.inject.criteria.InjectionCriteria;

public class InjectTask
extends AbstractFileTask {
    private Injector injector = null;
    private InjectionCriteria criteria = new InjectionCriteria();

    private Injector getInjector() {
        if (this.injector == null) {
            this.injector = new Injector();
            this.injector.setForceOverwrite(true);
            this.injector.setInjectionCriteria(this.criteria);
        }
        return this.injector;
    }

    protected void processFile(File file) throws BuildException {
        this.log("processFile(" + file.getAbsolutePath() + ")", 3);
        try {
            this.getInjector().inject(file);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void validateFile(File file) throws BuildException {
        if (!file.exists()) {
            throw new BuildException("File does not exist : " + file.getAbsolutePath());
        }
    }

    public InjectionCriteria createCriteria() {
        return this.criteria;
    }
}

