/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.jda;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.shiftone.jrat.jda.ThreadTracer;
import org.shiftone.jrat.jda.TraceException;
import org.shiftone.jrat.jda.config.VMTraceConfig;
import org.shiftone.jrat.jda.config.connect.ConnectorConfig;
import org.shiftone.jrat.jda.config.filter.FilterConfig;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class VMTracer {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$jda$VMTracer == null ? (class$org$shiftone$jrat$jda$VMTracer = VMTracer.class$("org.shiftone.jrat.jda.VMTracer")) : class$org$shiftone$jrat$jda$VMTracer);
    private VMTraceConfig vmc = null;
    private VirtualMachine vm = null;
    private EventRequestManager erm = null;
    private EventQueue eventQueue = null;
    private Map threadTracers = new HashMap();
    static /* synthetic */ Class class$org$shiftone$jrat$jda$VMTracer;

    public VMTracer(VMTraceConfig vmc) {
        this.vmc = vmc;
    }

    private void initThreads() {
        HashMap<ThreadReference, ThreadTracer> newThreadTracers = new HashMap<ThreadReference, ThreadTracer>();
        List<ThreadReference> list = this.vm.allThreads();
        ThreadReference threadReference = null;
        for (int i = 0; i < list.size(); ++i) {
            threadReference = list.get(i);
            newThreadTracers.put(threadReference, new ThreadTracer(threadReference));
        }
        this.threadTracers = newThreadTracers;
    }

    private void subscribeToMethodEvents(EventRequestManager erm) {
        FilterConfig[] fc = this.vmc.getFilterConfigs();
        MethodEntryRequest enterRequest = null;
        for (int i = 0; i < fc.length; ++i) {
            String inc = fc[i].getInclude();
            String exc = fc[i].getExclude();
            if (inc == null) continue;
            enterRequest = erm.createMethodEntryRequest();
            enterRequest.addClassFilter(inc);
            if (exc != null) {
                enterRequest.addClassExclusionFilter(exc);
            }
            enterRequest.setSuspendPolicy(0);
            enterRequest.enable();
        }
    }

    private void init() throws TraceException {
        ConnectorConfig cc = null;
        cc = this.vmc.getConnectorConfig();
        this.vm = cc.connect(Bootstrap.virtualMachineManager());
        this.initThreads();
        this.subscribeToMethodEvents(this.vm.eventRequestManager());
        this.eventQueue = this.vm.eventQueue();
        this.vm.resume();
    }

    private ThreadTracer getThreadTracer(ThreadReference threadReference) {
        ThreadTracer threadTracer = (ThreadTracer)this.threadTracers.get(threadReference);
        if (threadTracer == null) {
            threadTracer = new ThreadTracer(threadReference);
            this.threadTracers.put(threadReference, threadTracer);
        }
        return threadTracer;
    }

    public void trace() throws TraceException {
        this.init();
        Event event = null;
        EventSet eventSet = null;
        EventIterator iterator = null;
        try {
            block3: while (true) {
                eventSet = this.eventQueue.remove();
                iterator = eventSet.eventIterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    event = iterator.nextEvent();
                    if (!(event instanceof LocatableEvent)) continue;
                    LocatableEvent locEvent = (LocatableEvent)event;
                    ThreadTracer threadTracer = this.getThreadTracer(locEvent.thread());
                    if (threadTracer != null) {
                        threadTracer.processEvent(locEvent);
                        continue;
                    }
                    LOG.debug(event);
                }
                break;
            }
        }
        catch (VMDisconnectedException e) {
            LOG.info("target VM exited");
        }
        catch (Exception e) {
            LOG.error("error reading event queue", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

