/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.shiftone.jrat.core.Accumulator;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class StackNode
extends Accumulator {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$tree$StackNode == null ? (class$org$shiftone$jrat$provider$tree$StackNode = StackNode.class$("org.shiftone.jrat.provider.tree.StackNode")) : class$org$shiftone$jrat$provider$tree$StackNode);
    public static final String VERSION = StringUtil.revision("$Revision: 1.10 $");
    protected MethodKey methodKey = null;
    protected StackNode parent = null;
    protected Map children = new HashMap();
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$StackNode;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$TreeOutputXmlViewerFactory;

    public StackNode() {
    }

    public StackNode(MethodKey methodKey, StackNode treeNode) {
        this.methodKey = methodKey;
        this.parent = treeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackNode getChild(MethodKey methodKey) {
        StackNode treeNode = null;
        Map map = this.children;
        synchronized (map) {
            treeNode = (StackNode)this.children.get(methodKey);
            if (treeNode == null) {
                treeNode = new StackNode(methodKey, this);
                this.children.put(methodKey, treeNode);
            }
        }
        return treeNode;
    }

    public final StackNode getParentNode() {
        return this.parent;
    }

    public final boolean isRootNode() {
        return this.methodKey == null;
    }

    public MethodKey getMethodKey() {
        return this.methodKey;
    }

    public void printXML(PrintWriter out) {
        LOG.info("printXML...");
        if (this.isRootNode()) {
            this.printRoot(out);
        } else {
            this.printNonRoot(out, 0);
        }
        LOG.info("checkError = " + out.checkError());
    }

    private void printRoot(PrintWriter out) {
        LOG.info("printRoot...");
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<!-- generated by JRat 'call tree' " + VERSION + " provider on " + new Date() + "-->");
        out.println("<jrat-tree viewer=\"" + (class$org$shiftone$jrat$provider$tree$ui$TreeOutputXmlViewerFactory == null ? (class$org$shiftone$jrat$provider$tree$ui$TreeOutputXmlViewerFactory = StackNode.class$("org.shiftone.jrat.provider.tree.ui.TreeOutputXmlViewerFactory")) : class$org$shiftone$jrat$provider$tree$ui$TreeOutputXmlViewerFactory).getName() + "\">");
        out.println("<view>");
        this.printChildren(out, 0);
        out.println("</view>");
        out.println("</jrat-tree>");
    }

    private void printNonRoot(PrintWriter out, int depth) {
        out.print(StringUtil.bufferString(depth, ' '));
        out.print("<call");
        out.print(" c=\"" + this.methodKey.getClassName() + "\"");
        out.print(" m=\"" + this.methodKey.getMethodName() + "\"");
        out.print(" s=\"" + this.methodKey.getSignature() + "\"");
        out.print(" ent=\"" + this.getTotalEnters() + "\"");
        out.print(" xit=\"" + this.getTotalExits() + "\"");
        out.print(" err=\"" + this.getTotalErrors() + "\"");
        out.print(" dur=\"" + this.getTotalDuration() + "\"");
        out.print(" sos=\"" + this.getSumOfSquares() + "\"");
        if (this.getTotalDuration() != 0L) {
            out.print(" min=\"" + this.getMinDuration() + "\"");
            out.print(" max=\"" + this.getMaxDuration() + "\"");
        }
        if (this.children.size() > 0) {
            out.println(">");
            this.printChildren(out, depth);
            out.print(StringUtil.bufferString(depth, ' '));
            out.println("</call>");
        } else {
            out.println("/>");
        }
    }

    private void printChildren(PrintWriter out, int depth) {
        this.children = Collections.unmodifiableMap(this.children);
        Collection collection = this.children.values();
        Iterator iterator = collection.iterator();
        StackNode treeNode = null;
        while (iterator.hasNext()) {
            treeNode = (StackNode)iterator.next();
            treeNode.printNonRoot(out, depth + 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

