/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.shiftone.jrat.provider.tree.ui.StackTreeNode;
import org.shiftone.jrat.ui.util.DotIcon;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class StackTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$tree$ui$StackTreeCellRenderer == null ? (class$org$shiftone$jrat$provider$tree$ui$StackTreeCellRenderer = StackTreeCellRenderer.class$("org.shiftone.jrat.provider.tree.ui.StackTreeCellRenderer")) : class$org$shiftone$jrat$provider$tree$ui$StackTreeCellRenderer);
    private static Icon ICON_ROOT = new DotIcon(8, Color.lightGray);
    private static Icon ICON_COLD = new DotIcon(10, new Color(65280));
    private static Icon ICON_COOL = new DotIcon(10, new Color(0x88FF00));
    private static Icon ICON_WARM = new DotIcon(10, new Color(0xFFFF00));
    private static Icon ICON_WARMER = new DotIcon(10, new Color(0xFF8800));
    private static Icon ICON_HOT = new DotIcon(10, new Color(0xFF0000));
    private StackTreeNode treeNode = null;
    private DecimalFormat pctDecimalFormat = new DecimalFormat("#,###.#'%'");
    private DecimalFormat msDecimalFormat = new DecimalFormat("#,###,###.##'ms'");
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$StackTreeCellRenderer;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.treeNode = (StackTreeNode)value;
        this.hasFocus = hasFocus;
        this.selected = sel;
        double w = this.treeNode.getPctOfAvgParentDuration();
        Icon icon = null;
        icon = this.treeNode.isRootNode() || this.treeNode.isChildOfRootNode() ? ICON_ROOT : (w >= 70.0 ? ICON_HOT : (w >= 50.0 ? ICON_WARMER : (w >= 30.0 ? ICON_WARM : (w >= 10.0 ? ICON_COOL : ICON_COLD))));
        this.setText(this.nodeText());
        if (this.selected) {
            this.setForeground(Color.white);
        } else {
            this.setForeground(Color.black);
        }
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            this.setDisabledIcon(icon);
        } else {
            this.setEnabled(true);
            this.setIcon(icon);
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        return this;
    }

    public String nodeText() {
        if (this.treeNode.isRootNode()) {
            return "Root";
        }
        String methodName = this.treeNode.getMethodKey().getMethodName();
        if (this.treeNode.isChildOfRootNode()) {
            Float avg = this.treeNode.getAverageDuration();
            return methodName + (avg == null ? " - never exited" : " - " + this.msDecimalFormat.format(this.treeNode.getAverageDuration()));
        }
        double pct = this.treeNode.getPctOfAvgRootDuration();
        if (pct > 0.09) {
            return methodName + " - " + this.pctDecimalFormat.format(pct);
        }
        return methodName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

