/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.proxy.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.shiftone.jrat.proxy.jdbc.ProxyCallableStatement;
import org.shiftone.jrat.proxy.jdbc.ProxyPreparedStatement;
import org.shiftone.jrat.proxy.jdbc.ProxyStatement;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ProxyConnection
implements Connection {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$proxy$jdbc$ProxyConnection == null ? (class$org$shiftone$jrat$proxy$jdbc$ProxyConnection = ProxyConnection.class$("org.shiftone.jrat.proxy.jdbc.ProxyConnection")) : class$org$shiftone$jrat$proxy$jdbc$ProxyConnection);
    private static int instanceCounter = 0;
    private final int instanceNumber = instanceCounter++;
    Connection targetConnection = null;
    static /* synthetic */ Class class$org$shiftone$jrat$proxy$jdbc$ProxyConnection;

    public ProxyConnection(Connection targetConnection) {
        this.log("new ProxyConnection");
        this.targetConnection = targetConnection;
    }

    void log(String message) {
        LOG.info("C" + this.instanceNumber + " " + message);
    }

    public void clearWarnings() throws SQLException {
        this.log("clearWarnings()");
        this.targetConnection.clearWarnings();
    }

    public void close() throws SQLException {
        this.log("close()");
        this.targetConnection.close();
    }

    public void commit() throws SQLException {
        this.log("commit()");
        this.targetConnection.commit();
    }

    public Statement createStatement() throws SQLException {
        this.log("createStatement()");
        return new ProxyStatement(this.targetConnection.createStatement(), this);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.log("createStatement(" + resultSetType + ", " + resultSetConcurrency + ")");
        return new ProxyStatement(this.targetConnection.createStatement(resultSetType, resultSetConcurrency), this);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log("createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")");
        return new ProxyStatement(this.targetConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this);
    }

    public boolean getAutoCommit() throws SQLException {
        boolean b = this.targetConnection.getAutoCommit();
        this.log("getAutoCommit() -> " + b);
        return b;
    }

    public String getCatalog() throws SQLException {
        return this.targetConnection.getCatalog();
    }

    public int getHoldability() throws SQLException {
        return this.targetConnection.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.targetConnection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.targetConnection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.targetConnection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.targetConnection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.targetConnection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.targetConnection.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        return this.targetConnection.nativeSQL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareCall(sql);
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareCall(" + sql + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareCall(" + sql + ") took " + (finish - start) + "ms");
        return new ProxyCallableStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ") took " + (finish - start) + "ms");
        return new ProxyCallableStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ") took " + (finish - start) + "ms");
        return new ProxyCallableStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareStatement(sql);
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareStatement(" + sql + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareStatement(" + sql + ") took " + (finish - start) + "ms");
        return new ProxyPreparedStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareStatement(sql, autoGeneratedKeys);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareStatement(" + sql + ", " + autoGeneratedKeys + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareStatement(" + sql + ", " + autoGeneratedKeys + ") took " + (finish - start) + "ms");
        return new ProxyPreparedStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareStatement(sql, columnIndexes);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareStatement(" + sql + ", int[]) took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareStatement(" + sql + ", int[]) took " + (finish - start) + "ms");
        return new ProxyPreparedStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareStatement(sql, columnNames);
            Object var9_5 = null;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareStatement(" + sql + ", String[]) took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareStatement(" + sql + ", String[]) took " + (finish - start) + "ms");
        return new ProxyPreparedStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ") took " + (finish - start) + "ms");
        return new ProxyPreparedStatement(stmt, this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement stmt;
        long start = 0L;
        try {
            start = System.currentTimeMillis();
            stmt = this.targetConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            Object var11_7 = null;
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            long finish = System.currentTimeMillis();
            this.log("prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ") took " + (finish - start) + "ms");
            throw throwable;
        }
        long finish = System.currentTimeMillis();
        this.log("prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ") took " + (finish - start) + "ms");
        return new ProxyPreparedStatement(stmt, this, sql);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.log("releaseSavepoint(Savepoint)");
        this.targetConnection.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.log("rollback()");
        this.targetConnection.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.log("rollback(Savepoint)");
        this.targetConnection.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.log("setAutoCommit(" + autoCommit + ")");
        this.targetConnection.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.targetConnection.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.targetConnection.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.targetConnection.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.log("setSavepoint()");
        return this.targetConnection.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.log("setSavepoint(" + name + ")");
        return this.targetConnection.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.targetConnection.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.targetConnection.setTypeMap(map);
    }

    public boolean equals(Object obj) {
        return this.targetConnection.equals(obj);
    }

    public int hashCode() {
        return this.targetConnection.hashCode();
    }

    public String toString() {
        return this.targetConnection.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

