/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.simulate;

import java.util.Stack;
import org.shiftone.jrat.core.ConfigurationException;
import org.shiftone.jrat.simulate.stmt.ListStatement;
import org.shiftone.jrat.simulate.stmt.LoopStatement;
import org.shiftone.jrat.simulate.stmt.MethodCallStatement;
import org.shiftone.jrat.simulate.stmt.PeriodicFailureStatement;
import org.shiftone.jrat.simulate.stmt.Statement;
import org.shiftone.jrat.util.BeanWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimXmlHandler
extends DefaultHandler {
    private Statement rootStatement = null;
    private Statement stmtInProgress = null;
    private Stack stack = null;
    private int threads = 1;

    public Statement getRootStatement() {
        return this.rootStatement;
    }

    public int getThreads() {
        return this.threads;
    }

    public void startDocument() throws SAXException {
        this.stmtInProgress = new ListStatement();
        this.stack = new Stack();
        this.stack.push(this.stmtInProgress);
    }

    public void endDocument() throws SAXException {
        this.rootStatement = this.stmtInProgress;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stack.pop();
    }

    /*
     * WARNING - void declaration
     */
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        void var7_7;
        ListStatement listStatement;
        Statement stmt = (Statement)this.stack.peek();
        if (stmt instanceof ListStatement) {
            Statement newStmt;
            listStatement = (ListStatement)stmt;
            if ("loop".equals(qName)) {
                newStmt = new LoopStatement();
            } else if ("method".equals(qName)) {
                newStmt = new MethodCallStatement();
            } else if ("failure".equals(qName)) {
                newStmt = new PeriodicFailureStatement();
            } else {
                if ("simulation".equals(qName)) {
                    String threadString = attributes.getValue("threads");
                    if (threadString != null) {
                        this.threads = Integer.parseInt(threadString);
                    }
                    return;
                }
                throw new SAXException("unknown tag : " + qName);
            }
            BeanWrapper beanWrapper = new BeanWrapper(var7_7);
            try {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    beanWrapper.setProperty(attributes.getQName(i), attributes.getValue(i));
                }
            }
            catch (ConfigurationException e) {
                throw new SAXException("error setting attribute on statement object", e);
            }
        } else {
            throw new SAXException("statements " + stmt.getClass().getName() + " can not contain other statements");
        }
        listStatement.addChild((Statement)var7_7);
        this.stack.push(var7_7);
    }
}

