/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.simulate;

import java.io.File;
import java.io.FileInputStream;
import org.shiftone.jrat.core.InternalHandler;
import org.shiftone.jrat.simulate.SimXmlHandler;
import org.shiftone.jrat.simulate.SimulatorRunnable;
import org.shiftone.jrat.simulate.stmt.Statement;
import org.shiftone.jrat.util.XMLUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Simulator {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$simulate$Simulator == null ? (class$org$shiftone$jrat$simulate$Simulator = Simulator.class$("org.shiftone.jrat.simulate.Simulator")) : class$org$shiftone$jrat$simulate$Simulator);
    static /* synthetic */ Class class$org$shiftone$jrat$simulate$Simulator;

    public static void simulate(File file) throws Exception {
        int i;
        FileInputStream inputStream = new FileInputStream(file);
        InputSource inputSource = new InputSource(inputStream);
        XMLReader reader = XMLUtil.getXMLReader();
        SimXmlHandler xmlHandler = new SimXmlHandler();
        InternalHandler internalHandler = new InternalHandler();
        Statement statement = null;
        Thread[] threads = null;
        LOG.info("configuring simulator...");
        reader.setContentHandler(xmlHandler);
        reader.parse(inputSource);
        LOG.info("configuration complete.");
        statement = xmlHandler.getRootStatement();
        threads = new Thread[xmlHandler.getThreads()];
        LOG.info("running simulation...");
        long start = System.currentTimeMillis();
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new SimulatorRunnable(internalHandler, statement));
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        LOG.info("simulation complated in " + (System.currentTimeMillis() - start) + " ms");
    }

    public static void main(String[] args) {
        System.out.println(new File("").getAbsolutePath());
        if (args.length == 0) {
            LOG.info("usage: Simulator [filename]");
        }
        String fileName = args[0];
        File file = new File(fileName);
        try {
            Simulator.simulate(file);
        }
        catch (Exception e) {
            LOG.info("error running simulation", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

