/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.viewer;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import org.shiftone.jrat.core.OutputViewerException;
import org.shiftone.jrat.core.spi.OutputViewerFactory;
import org.shiftone.jrat.core.spi.RuntimeOutput;
import org.shiftone.jrat.ui.UIConstants;
import org.shiftone.jrat.ui.util.Background;
import org.shiftone.jrat.ui.util.BackgroundActionListener;
import org.shiftone.jrat.ui.util.ExceptionDialog;
import org.shiftone.jrat.ui.viewer.OpenOutputFileRunnable;
import org.shiftone.jrat.ui.viewer.RuntimeOutputImpl;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.ResourceUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class OpenOutputFileAction
extends BackgroundActionListener
implements UIConstants {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$viewer$OpenOutputFileAction == null ? (class$org$shiftone$jrat$ui$viewer$OpenOutputFileAction = OpenOutputFileAction.class$("org.shiftone.jrat.ui.viewer.OpenOutputFileAction")) : class$org$shiftone$jrat$ui$viewer$OpenOutputFileAction);
    public static final String VIEWER_STRING = "viewer=\"";
    private Frame parent = null;
    private JTabbedPane tabbedPane = null;
    private JProgressBar progressBar = null;
    private ActionEvent actionEvent = null;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$viewer$OpenOutputFileAction;

    public OpenOutputFileAction(Frame parent, JTabbedPane tabbedPane, JProgressBar progressBar) {
        this.parent = parent;
        this.tabbedPane = tabbedPane;
        this.progressBar = progressBar;
    }

    public void actionPerformedInBackground(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        File lastFile = UIConstants.SETTINGS.getLastOpenedOutputFile();
        try {
            chooser.addChoosableFileFilter(UIConstants.OUTPUT_FILE_FILTER);
            if (lastFile != null) {
                chooser.setCurrentDirectory(IOUtil.getNearestExistingParent(lastFile));
                chooser.setSelectedFile(lastFile);
            }
            if (0 == chooser.showOpenDialog(this.parent)) {
                this.openFile(chooser.getSelectedFile());
            }
        }
        catch (Exception ex) {
            new ExceptionDialog(this.parent, (Throwable)ex).setVisible(true);
        }
    }

    private void openFile(File inputFile) throws IOException, OutputViewerException {
        LOG.info("openFile(" + inputFile + ")");
        UIConstants.SETTINGS.setLastOpenedOutputFile(inputFile);
        RuntimeOutputImpl runtimeOutput = null;
        String title = inputFile.getName();
        OutputViewerFactory viewerFactory = null;
        OpenOutputFileRunnable runnable = null;
        runtimeOutput = new RuntimeOutputImpl(inputFile, this.progressBar);
        viewerFactory = this.getOutputViewerFactory(runtimeOutput);
        runnable = new OpenOutputFileRunnable(runtimeOutput, viewerFactory, title, this.tabbedPane);
        Background.start(this.parent, runnable);
    }

    private OutputViewerFactory getOutputViewerFactory(RuntimeOutput runtimeOutput) throws OutputViewerException {
        OutputViewerFactory factory = null;
        String klassName = null;
        try {
            klassName = this.getOutputViewerFactoryClassName(runtimeOutput);
            factory = (OutputViewerFactory)ResourceUtil.newInstance(klassName);
        }
        catch (Exception e) {
            throw new OutputViewerException("error creating output viewer", e);
        }
        return factory;
    }

    private String getOutputViewerFactoryClassName(RuntimeOutput runtimeOutput) throws IOException {
        Reader reader = null;
        LineNumberReader lineReader = null;
        String line = null;
        String klass = null;
        try {
            reader = runtimeOutput.openReader();
            lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                int a = line.indexOf(VIEWER_STRING);
                if (a < 0) continue;
                int b = a + VIEWER_STRING.length();
                int c = line.indexOf("\"", b);
                klass = line.substring(b, c);
                LOG.info("getOutputViewerFactory = " + klass);
                break;
            }
            if (klass == null) {
                throw new IOException("unable to find viewer definition in file");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOUtil.close(reader);
        }
        return klass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

