/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.StringUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class SavedProperties
extends Properties {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$SavedProperties == null ? (class$org$shiftone$jrat$util$SavedProperties = SavedProperties.class$("org.shiftone.jrat.util.SavedProperties")) : class$org$shiftone$jrat$util$SavedProperties);
    private static final String VERSION = StringUtil.revision("$Revision: 1.9 $");
    private static final String DEFAULT_HEADER = "ShiftOne JRat SavedProperties " + VERSION;
    private static final String USER_HOME_DIR = System.getProperty("user.home");
    private static final String PROPERTIES_FILE_NAME = ".jrat.properties";
    private static final String PROPERTIES_FILE_PATH = USER_HOME_DIR + File.separator + ".jrat.properties";
    public static final Properties USER_PROPERTIES = new SavedProperties(PROPERTIES_FILE_PATH);
    private String header = DEFAULT_HEADER;
    private File storeFile = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$SavedProperties;

    public SavedProperties(String storeFileName) {
        this(new File(storeFileName));
    }

    public SavedProperties(File storeFile) {
        Assert.assertNotNull("storeFile", storeFile);
        this.storeFile = storeFile;
        this.load();
    }

    private synchronized void store() {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.storeFile);
            super.store(outputStream, this.header);
        }
        catch (Exception e) {
            LOG.warn("unable to store properties to file : " + this.storeFile);
            IOUtil.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.storeFile);
            super.load(inputStream);
        }
        catch (Exception e) {
            try {
                super.clear();
                LOG.warn("unable to load properties from file : " + this.storeFile);
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
            IOUtil.close(inputStream);
        }
        IOUtil.close(inputStream);
    }

    public synchronized Object put(Object key, Object value) {
        Assert.assertNotNull("key", key);
        Assert.assertNotNull("value", value);
        Object o = super.put(key, value);
        this.store();
        return o;
    }

    public synchronized void putAll(Map t) {
        Assert.assertNotNull("map", t);
        super.putAll((Map<?, ?>)t);
        this.store();
    }

    public synchronized Object setProperty(String key, String value) {
        Assert.assertNotNull("key", key);
        Assert.assertNotNull("value", value);
        Object o = super.setProperty(key, value);
        this.store();
        return o;
    }

    public synchronized Object remove(Object key) {
        Assert.assertNotNull("key", key);
        Object o = super.remove(key);
        this.store();
        return o;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

