/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class SignatureUtil {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$SignatureUtil == null ? (class$org$shiftone$jrat$util$SignatureUtil = SignatureUtil.class$("org.shiftone.jrat.util.SignatureUtil")) : class$org$shiftone$jrat$util$SignatureUtil);
    private static Map PRIMITIVE_TYPES = new HashMap();
    static /* synthetic */ Class class$org$shiftone$jrat$util$SignatureUtil;

    public static String getSignature(Class klass) {
        Assert.assertNotNull("class", klass);
        if (klass.isPrimitive()) {
            return (String)PRIMITIVE_TYPES.get(klass);
        }
        String sig = klass.getName();
        sig = sig.replace('.', '/');
        if (!klass.isArray()) {
            sig = 'L' + sig + ';';
        }
        return sig;
    }

    public static String getSignature(Method method) {
        Assert.assertNotNull("method", method);
        StringBuffer sb = new StringBuffer();
        Class<?>[] args = method.getParameterTypes();
        Class<?> ret = method.getReturnType();
        sb.append("(");
        for (int i = 0; i < args.length; ++i) {
            sb.append(SignatureUtil.getSignature(args[i]));
        }
        sb.append(")");
        sb.append(SignatureUtil.getSignature(ret));
        return sb.toString();
    }

    public static String getSignature(Constructor constructor) {
        Assert.assertNotNull("constructor", constructor);
        StringBuffer sb = new StringBuffer();
        Class<?>[] args = constructor.getParameterTypes();
        sb.append("(");
        for (int i = 0; i < args.length; ++i) {
            sb.append(SignatureUtil.getSignature(args[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIMITIVE_TYPES.put(Boolean.TYPE, "Z");
        PRIMITIVE_TYPES.put(Byte.TYPE, "B");
        PRIMITIVE_TYPES.put(Character.TYPE, "C");
        PRIMITIVE_TYPES.put(Short.TYPE, "S");
        PRIMITIVE_TYPES.put(Integer.TYPE, "I");
        PRIMITIVE_TYPES.put(Long.TYPE, "J");
        PRIMITIVE_TYPES.put(Float.TYPE, "F");
        PRIMITIVE_TYPES.put(Double.TYPE, "D");
        PRIMITIVE_TYPES.put(Void.TYPE, "V");
        PRIMITIVE_TYPES.put(Float.TYPE, "F");
    }
}

