/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.spi;

import java.awt.Component;
import java.io.InputStream;
import java.util.Properties;
import org.shiftone.jrat.core.OutputViewerException;
import org.shiftone.jrat.core.spi.OutputViewerFactory;
import org.shiftone.jrat.core.spi.RuntimeOutput;
import org.shiftone.jrat.core.spi.ViewerXmlHandler;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.XMLUtil;
import org.shiftone.jrat.util.log.LoggingSAXErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public abstract class AbstractOutputXmlViewerFactory
implements OutputViewerFactory {
    public Component createViewerComponent(RuntimeOutput runtimeOutput) throws OutputViewerException {
        Component component = null;
        InputStream inputStream = null;
        XMLReader xmlReader = null;
        ViewerXmlHandler viewerXmlHandler = null;
        try {
            inputStream = runtimeOutput.openInputStream();
            viewerXmlHandler = new ViewerXmlHandler(this);
            xmlReader = XMLUtil.getXMLReader();
            xmlReader.setContentHandler(viewerXmlHandler);
            xmlReader.setErrorHandler(new LoggingSAXErrorHandler());
            xmlReader.parse(new InputSource(inputStream));
            component = viewerXmlHandler.getComponent();
            Assert.assertNotNull("component", component);
        }
        catch (Throwable e) {
            throw new OutputViewerException("error processing XML JRat output file", e);
        }
        return component;
    }

    protected abstract Component endDocumentCreateViewer() throws OutputViewerException;

    protected abstract void startDocument() throws OutputViewerException;

    protected abstract void endElement(String var1) throws OutputViewerException;

    protected abstract void startElement(String var1, Properties var2) throws OutputViewerException;

    protected abstract void textElement(String var1) throws OutputViewerException;
}

