/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject;

import java.util.Date;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.JSR;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;
import org.shiftone.jrat.inject.BcelUtil;
import org.shiftone.jrat.inject.InjectConstants;
import org.shiftone.jrat.inject.criteria.InjectionCriteria;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ClassInjector
implements InjectConstants {
    private static Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$inject$ClassInjector == null ? (class$org$shiftone$jrat$inject$ClassInjector = ClassInjector.class$("org.shiftone.jrat.inject.ClassInjector")) : class$org$shiftone$jrat$inject$ClassInjector);
    private static final InjectionCriteria DEFAULT_INJECTION_CRITERIA = new InjectionCriteria();
    private String className = null;
    private ClassGen classGen = null;
    private JavaClass javaClass = null;
    private long classSerialVersion = 0L;
    private ConstantPoolGen constantPool = null;
    private InstructionList addedStaticInit = null;
    private InstructionFactory factory = null;
    private InvokeInstruction onBegin = null;
    private InvokeInstruction onDone = null;
    private InvokeInstruction getTime = null;
    private InvokeInstruction onCatch = null;
    private int handlerCount = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$ClassInjector;

    private ClassInjector(JavaClass javaClass) {
        this.javaClass = javaClass;
        this.className = javaClass.getClassName();
        this.classGen = new ClassGen(javaClass);
        this.classSerialVersion = BcelUtil.computeSerialVersionUID(javaClass);
        this.constantPool = this.classGen.getConstantPool();
        this.addedStaticInit = new InstructionList();
        this.factory = new InstructionFactory(this.constantPool);
        this.onBegin = this.factory.createInvoke("org.shiftone.jrat.core.spi.MethodHandler", "onMethodStart", (Type)Type.VOID, InjectConstants.ARGS_METHOD_BEGIN, (short)185);
        this.onCatch = this.factory.createInvoke("org.shiftone.jrat.core.spi.MethodHandler", "onMethodError", (Type)Type.VOID, InjectConstants.ARGS_METHOD_ERROR, (short)185);
        this.onDone = this.factory.createInvoke("org.shiftone.jrat.core.spi.MethodHandler", "onMethodFinish", (Type)Type.VOID, InjectConstants.ARGS_METHOD_DONE, (short)185);
        this.getTime = this.factory.createInvoke("java.lang.System", "currentTimeMillis", (Type)Type.LONG, InjectConstants.NO_ARGS, (short)184);
    }

    private boolean wasAlreadyInjected() {
        return this.classGen.containsField("JRat") != null;
    }

    private void addClassComment() {
        FieldGen fieldGen = null;
        fieldGen = new FieldGen(26, (Type)Type.STRING, "JRat", this.constantPool);
        fieldGen.setInitValue("Class enhanced on " + new Date() + " w/ version JRat v" + VersionUtil.getBuiltOn() + " built on " + VersionUtil.getBuiltOn());
        this.classGen.addField(fieldGen.getField());
    }

    private void addSerialVersionUID() {
        Field field = null;
        FieldGen fieldGen = null;
        field = this.classGen.containsField("serialVersionUID");
        if (field == null) {
            fieldGen = new FieldGen(26, (Type)Type.LONG, "serialVersionUID", this.constantPool);
            fieldGen.setInitValue(this.classSerialVersion);
            this.classGen.addField(fieldGen.getField());
        }
    }

    private void addStaticInitCode() {
        Method method = null;
        MethodGen methodGen = null;
        method = this.classGen.containsMethod("<clinit>", "()V");
        if (method == null) {
            this.addedStaticInit.append((Instruction)new RETURN());
            methodGen = new MethodGen(24, (Type)Type.VOID, InjectConstants.NO_ARGS, null, "<clinit>", this.className, this.addedStaticInit, this.constantPool);
            methodGen.setMaxStack();
            methodGen.setMaxLocals();
            this.classGen.addMethod(methodGen.getMethod());
        } else {
            InstructionList ops = null;
            methodGen = new MethodGen(method, this.className, this.constantPool);
            ops = methodGen.getInstructionList();
            ops.insert(this.addedStaticInit);
            methodGen.setMaxStack();
            methodGen.setMaxLocals();
            this.classGen.replaceMethod(method, methodGen.getMethod());
        }
    }

    private String renameTargetMethod(Method method) {
        Method newMethod = null;
        MethodGen methodGen = null;
        String oldMethodName = method.getName();
        String newMethodName = null;
        newMethodName = oldMethodName.equals("<init>") ? "CONSTRUCTOR__shiftone_JRat" : oldMethodName + "__shiftone_JRat";
        methodGen = new MethodGen(method, this.className, this.constantPool);
        methodGen.setName(newMethodName);
        methodGen.isFinal(true);
        methodGen.isPrivate(true);
        methodGen.isPublic(false);
        methodGen.isProtected(false);
        newMethod = methodGen.getMethod();
        this.classGen.replaceMethod(method, newMethod);
        return newMethodName;
    }

    private InstructionList pushThisOnStack(Method method) {
        InstructionList ops = null;
        ops = new InstructionList();
        if (method.isStatic()) {
            ops.append((Instruction)new ACONST_NULL());
        } else {
            ops.append((Instruction)new ALOAD(0));
        }
        return ops;
    }

    private String getStaticHandlerFieldName(Method method) {
        String fieldName = null;
        Field field = null;
        FieldGen fieldGen = null;
        fieldName = "HANDLER_FOR__" + this.handlerCount++;
        field = this.classGen.containsField(fieldName);
        if (field == null) {
            fieldGen = new FieldGen(26, (Type)InjectConstants.REF_TYPE_METHOD_HANDLER, fieldName, this.constantPool);
            this.addedStaticInit.append((CompoundInstruction)new PUSH(this.constantPool, this.className));
            this.addedStaticInit.append((CompoundInstruction)new PUSH(this.constantPool, method.getName()));
            this.addedStaticInit.append((CompoundInstruction)new PUSH(this.constantPool, method.getSignature()));
            this.addedStaticInit.append((Instruction)this.factory.createInvoke("org.shiftone.jrat.core.HandlerFactory", "getMethodHandler", (Type)InjectConstants.REF_TYPE_METHOD_HANDLER, InjectConstants.ARGS_GET_HANDLER, (short)184));
            this.addedStaticInit.append((Instruction)this.factory.createPutStatic(this.className, fieldName, (Type)InjectConstants.REF_TYPE_METHOD_HANDLER));
            this.classGen.addField(fieldGen.getField());
        }
        return fieldGen.getName();
    }

    private void addProxyMethod(Method method, String targetMethodName, String staticHandlerFieldName) {
        Method newMethod = null;
        MethodGen methodGen = null;
        String methodName = null;
        Type[] params = null;
        Type returnType = null;
        InstructionList ops = null;
        InstructionHandle temp = null;
        int paramNum = 0;
        methodGen = new MethodGen(method, this.className, this.constantPool);
        ops = new InstructionList();
        methodName = methodGen.getName();
        params = methodGen.getArgumentTypes();
        returnType = methodGen.getReturnType();
        methodGen.removeLocalVariables();
        int startIndex = methodGen.addLocalVariable("start", (Type)Type.LONG, null, null).getIndex();
        int successIndex = methodGen.addLocalVariable("success", (Type)Type.BOOLEAN, null, null).getIndex();
        int argsIndex = methodGen.addLocalVariable("args", (Type)InjectConstants.REF_TYPE_OBJ_ARRAY, null, null).getIndex();
        int exceptionIndex = methodGen.addLocalVariable("exception", (Type)Type.OBJECT, null, null).getIndex();
        int retIndex = methodGen.addLocalVariable("ret", (Type)Type.INT, null, null).getIndex();
        methodGen.removeLineNumbers();
        temp = ops.append((Instruction)new NOP());
        InstructionHandle xxx = ops.append((CompoundInstruction)new PUSH(this.constantPool, 0L));
        xxx = ops.append((Instruction)InstructionFactory.createStore((Type)Type.LONG, (int)startIndex));
        xxx = ops.append((Instruction)new ACONST_NULL());
        xxx = ops.append((Instruction)InstructionFactory.createStore((Type)InjectConstants.REF_TYPE_OBJ_ARRAY, (int)argsIndex));
        xxx = ops.append((CompoundInstruction)new PUSH(this.constantPool, false));
        xxx = ops.append((Instruction)InstructionFactory.createStore((Type)Type.BOOLEAN, (int)successIndex));
        InstructionHandle tri = ops.append((Instruction)this.factory.createGetStatic(this.className, staticHandlerFieldName, (Type)InjectConstants.REF_TYPE_METHOD_HANDLER));
        xxx = ops.append(this.pushThisOnStack(method));
        xxx = ops.append((Instruction)InstructionFactory.createLoad((Type)InjectConstants.REF_TYPE_OBJ_ARRAY, (int)argsIndex));
        xxx = ops.append((Instruction)this.onBegin);
        xxx = ops.append((Instruction)this.getTime);
        xxx = ops.append((Instruction)InstructionFactory.createStore((Type)Type.LONG, (int)startIndex));
        if (!method.isStatic()) {
            xxx = ops.append((Instruction)new ALOAD(0));
            ++paramNum;
        }
        for (int p = 0; p < params.length; ++p) {
            ops.append((Instruction)InstructionFactory.createLoad((Type)params[p], (int)paramNum));
            paramNum += params[p].getSize();
        }
        ops.append((Instruction)this.factory.createInvoke(this.className, targetMethodName, returnType, params, method.isStatic() ? (short)184 : 182));
        if (returnType != Type.VOID) {
            int resultIndex = methodGen.addLocalVariable("result", returnType, null, null).getIndex();
            xxx = ops.append((Instruction)InstructionFactory.createStore((Type)returnType, (int)resultIndex));
            xxx = ops.append((CompoundInstruction)new PUSH(this.constantPool, true));
            xxx = ops.append((Instruction)InstructionFactory.createStore((Type)Type.BOOLEAN, (int)successIndex));
            xxx = ops.append((BranchInstruction)new JSR(temp));
            xxx = ops.append((Instruction)InstructionFactory.createLoad((Type)returnType, (int)resultIndex));
            xxx = ops.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        } else {
            xxx = ops.append((CompoundInstruction)new PUSH(this.constantPool, true));
            xxx = ops.append((Instruction)InstructionFactory.createStore((Type)Type.BOOLEAN, (int)successIndex));
            xxx = ops.append((BranchInstruction)new JSR(temp));
            xxx = ops.append((Instruction)InstructionFactory.createReturn((Type)returnType));
        }
        InstructionHandle eA = ops.append((Instruction)new ASTORE(exceptionIndex));
        xxx = ops.append((Instruction)this.factory.createGetStatic(this.className, staticHandlerFieldName, (Type)InjectConstants.REF_TYPE_METHOD_HANDLER));
        xxx = ops.append(this.pushThisOnStack(method));
        xxx = ops.append((Instruction)InstructionFactory.createLoad((Type)InjectConstants.REF_TYPE_OBJ_ARRAY, (int)argsIndex));
        xxx = ops.append((Instruction)new ALOAD(exceptionIndex));
        xxx = ops.append((Instruction)this.onCatch);
        xxx = ops.append((Instruction)new ALOAD(exceptionIndex));
        xxx = ops.append((Instruction)new ATHROW());
        InstructionHandle eB = ops.append((Instruction)new ASTORE(exceptionIndex));
        xxx = ops.append((BranchInstruction)new JSR(temp));
        xxx = ops.append((Instruction)new ALOAD(exceptionIndex));
        xxx = ops.append((Instruction)new ATHROW());
        InstructionHandle fin = ops.append((Instruction)new ASTORE(retIndex));
        xxx = ops.append((Instruction)this.factory.createGetStatic(this.className, staticHandlerFieldName, (Type)InjectConstants.REF_TYPE_METHOD_HANDLER));
        xxx = ops.append(this.pushThisOnStack(method));
        xxx = ops.append((Instruction)InstructionFactory.createLoad((Type)InjectConstants.REF_TYPE_OBJ_ARRAY, (int)argsIndex));
        xxx = ops.append((Instruction)new ACONST_NULL());
        xxx = ops.append((Instruction)this.getTime);
        xxx = ops.append((Instruction)InstructionFactory.createLoad((Type)Type.LONG, (int)startIndex));
        xxx = ops.append((Instruction)new LSUB());
        xxx = ops.append((Instruction)InstructionFactory.createLoad((Type)Type.BOOLEAN, (int)successIndex));
        xxx = ops.append((Instruction)this.onDone);
        xxx = ops.append((Instruction)new RET(retIndex));
        ops.redirectBranches(temp, fin);
        try {
            ops.delete(temp);
        }
        catch (Exception e) {
            // empty catch block
        }
        methodGen.setInstructionList(ops);
        methodGen.isSynchronized(false);
        methodGen.removeExceptionHandlers();
        methodGen.addExceptionHandler(tri, eA.getPrev(), eA, InjectConstants.OBJ_TYPE_THROWABLE);
        methodGen.addExceptionHandler(tri, eB.getPrev(), eB, null);
        methodGen.setMaxStack();
        methodGen.setMaxLocals();
        newMethod = methodGen.getMethod();
        this.classGen.addMethod(newMethod);
    }

    private boolean injectMethod(Method method, InjectionCriteria criteria) {
        if (method.isAbstract() || method.isNative() || BcelUtil.isSynthetic((FieldOrMethod)method) || method.getName().startsWith("<")) {
            return false;
        }
        if (!criteria.isMatch(this.javaClass, method)) {
            LOG.debug("method does not match criteria : " + method);
            return false;
        }
        String newMethodName = this.renameTargetMethod(method);
        this.addProxyMethod(method, newMethodName, this.getStaticHandlerFieldName(method));
        return true;
    }

    private int injectMethods(InjectionCriteria criteria) {
        int count = 0;
        Method[] methods = this.classGen.getMethods();
        for (int m = 0; m < methods.length; ++m) {
            if (!this.injectMethod(methods[m], criteria)) continue;
            ++count;
        }
        return count;
    }

    public static JavaClass injectClass(JavaClass javaClass, InjectionCriteria criteria) {
        JavaClass outputClass = javaClass;
        ClassInjector injector = null;
        if (javaClass.isInterface() || javaClass.getClassName().indexOf(36) != -1) {
            return javaClass;
        }
        if (criteria == null) {
            criteria = DEFAULT_INJECTION_CRITERIA;
        }
        if (!criteria.isMatch(javaClass)) {
            LOG.debug("class " + javaClass.getClassName() + " does not match criteria");
            return javaClass;
        }
        injector = new ClassInjector(javaClass);
        if (injector.wasAlreadyInjected()) {
            LOG.warn("class was already injected : " + javaClass.getClassName());
        } else if (injector.injectMethods(criteria) > 0) {
            injector.addSerialVersionUID();
            injector.addClassComment();
            injector.addStaticInitCode();
            outputClass = injector.classGen.getJavaClass();
        }
        return outputClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

