/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.inject.ant;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.shiftone.jrat.inject.Injector;
import org.shiftone.jrat.inject.criteria.InjectionCriteria;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class InjectCopyTask
extends Copy {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$inject$ant$InjectCopyTask == null ? (class$org$shiftone$jrat$inject$ant$InjectCopyTask = InjectCopyTask.class$("org.shiftone.jrat.inject.ant.InjectCopyTask")) : class$org$shiftone$jrat$inject$ant$InjectCopyTask);
    private InjectionCriteria criteria = new InjectionCriteria();
    private Injector injector = null;
    static /* synthetic */ Class class$org$shiftone$jrat$inject$ant$InjectCopyTask;

    private void copyOrInjectFile(String fromFile, String toFile, FilterSetCollection executionFilters) throws Exception {
        if (fromFile.endsWith(".class") || fromFile.endsWith(".jar")) {
            this.injector.inject(fromFile, toFile);
        } else if (fromFile.equals(toFile)) {
            this.log("Skipping self-copy of " + fromFile, this.verbosity);
        } else {
            this.log("Copying " + fromFile, 3);
            this.getFileUtils().copyFile(fromFile, toFile, executionFilters, this.getFilterChains(), this.forceOverwrite, this.preserveLastModified, this.getEncoding(), this.getProject());
        }
    }

    protected void doFileOperations() {
        Iterator sourceFiles = null;
        TreeMap orderedCopyMap = new TreeMap(this.fileCopyMap);
        if (orderedCopyMap.size() > 0) {
            this.log("Copying " + orderedCopyMap.size() + " file" + (orderedCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath(), this.verbosity);
            sourceFiles = orderedCopyMap.keySet().iterator();
            this.injector = new Injector();
            this.injector.setInjectionCriteria(this.criteria);
            this.injector.setForceOverwrite(this.forceOverwrite);
            this.injector.setPreserveLastModified(this.preserveLastModified);
            while (sourceFiles.hasNext()) {
                String fromFile = (String)sourceFiles.next();
                String toFile = (String)orderedCopyMap.get(fromFile);
                this.log(fromFile);
                try {
                    FilterSetCollection executionFilters = new FilterSetCollection();
                    if (this.filtering) {
                        executionFilters.addFilterSet(this.getProject().getGlobalFilterSet());
                    }
                    Enumeration filterEnum = this.getFilterSets().elements();
                    while (filterEnum.hasMoreElements()) {
                        executionFilters.addFilterSet((FilterSet)filterEnum.nextElement());
                    }
                    this.copyOrInjectFile(fromFile, toFile, executionFilters);
                }
                catch (Exception e) {
                    LOG.error("InjectCopyTask error", e);
                    throw new BuildException("Error instramenting " + fromFile, (Throwable)e, this.getLocation());
                }
            }
        }
        if (this.includeEmpty) {
            this.copyEmptyDirectories();
        }
    }

    private void copyEmptyDirectories() {
        Enumeration e = this.dirCopyMap.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            File d = new File((String)e.nextElement());
            if (d.exists()) continue;
            if (!d.mkdirs()) {
                this.log("Unable to create directory " + d.getAbsolutePath(), 0);
                continue;
            }
            ++count;
        }
        if (count > 0) {
            this.log("Copied " + count + " empty director" + (count == 1 ? "y" : "ies") + " to " + this.destDir.getAbsolutePath(), this.verbosity);
        }
    }

    public InjectionCriteria createCriteria() {
        return this.criteria;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

