/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.provider.tree.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.provider.tree.StackNode;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class StackTreeNode
extends StackNode
implements TreeNode {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$provider$tree$ui$StackTreeNode == null ? (class$org$shiftone$jrat$provider$tree$ui$StackTreeNode = StackTreeNode.class$("org.shiftone.jrat.provider.tree.ui.StackTreeNode")) : class$org$shiftone$jrat$provider$tree$ui$StackTreeNode);
    private static final Double ZERO = new Double(0.0);
    private boolean isChildOfRoot = false;
    private List childList = new ArrayList();
    protected double averageDuration;
    protected double pctOfAvgParentDuration;
    protected double rootAverageDuration;
    protected double rootTotalDuration;
    protected double pctOfAvgRootDuration;
    protected double pctOfRootTotalDuration;
    static /* synthetic */ Class class$org$shiftone$jrat$provider$tree$ui$StackTreeNode;

    public StackTreeNode() {
    }

    public StackTreeNode(MethodKey methodKey, StackTreeNode parentStackTreeNode) {
        super(methodKey, parentStackTreeNode);
    }

    public void setStatistics(long totalEnters, long totalExits, long totalErrors, long totalDuration, long totalOfSquares, long maxDuration, long minDuration, int maxConcurThreads) {
        super.setStatistics(totalEnters, totalExits, totalErrors, totalDuration, totalOfSquares, maxDuration, minDuration, maxConcurThreads);
        StackTreeNode p = (StackTreeNode)this.parent;
        this.isChildOfRoot = p.isRootNode();
        if (totalExits > 0L) {
            long parentTotalDuration;
            this.averageDuration = (double)this.getTotalDuration() / (double)this.getTotalExits();
            if (this.parent != null && (parentTotalDuration = p.getTotalDuration()) > 0L) {
                this.pctOfAvgParentDuration = 100.0 * (double)this.getTotalDuration() / (double)parentTotalDuration;
            }
        }
        this.rootAverageDuration = this.isChildOfRoot ? this.averageDuration : p.rootAverageDuration;
        double d = this.rootTotalDuration = this.isChildOfRoot ? (double)this.getTotalDuration() : p.rootTotalDuration;
        if (this.rootAverageDuration > 0.0) {
            this.pctOfAvgRootDuration = 100.0 * this.averageDuration / this.rootAverageDuration;
        }
        if (this.rootTotalDuration > 0.0) {
            this.pctOfRootTotalDuration = 100.0 * (double)this.getTotalDuration() / this.rootTotalDuration;
        }
    }

    public void completeStats() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackNode getChild(MethodKey methodKey) {
        StackNode treeNode = null;
        Map map = this.children;
        synchronized (map) {
            treeNode = (StackNode)this.children.get(methodKey);
            if (treeNode == null) {
                treeNode = new StackTreeNode(methodKey, this);
                this.childList.add(treeNode);
                this.children.put(methodKey, treeNode);
            }
        }
        return treeNode;
    }

    public double getPctOfAvgParentDuration() {
        return this.pctOfAvgParentDuration;
    }

    public double getPctOfAvgRootDuration() {
        return this.pctOfRootTotalDuration;
    }

    public double getRootAverageDuration() {
        return this.rootAverageDuration;
    }

    public double getPctOfRootTotalDuration() {
        return this.pctOfRootTotalDuration;
    }

    public double getRootTotalDuration() {
        return this.rootTotalDuration;
    }

    public boolean isChildOfRootNode() {
        return this.isChildOfRoot;
    }

    public String toString() {
        return this.isRootNode() ? "Root" : this.methodKey.getMethodName();
    }

    public Enumeration children() {
        return Collections.enumeration(this.childList);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childList.get(childIndex);
    }

    public int getChildCount() {
        return this.childList.size();
    }

    public TreeNode getParent() {
        return (TreeNode)((Object)this.getParentNode());
    }

    public int getIndex(TreeNode node) {
        return this.childList.indexOf(node);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

