/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.test;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.shiftone.jrat.inject.ClassInjector;
import org.shiftone.jrat.test.TestClassLoader;
import org.shiftone.jrat.test.dummy.CrashTestDummy;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class InjectorTestCase
extends TestCase {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$test$InjectorTestCase == null ? (class$org$shiftone$jrat$test$InjectorTestCase = InjectorTestCase.class$("org.shiftone.jrat.test.InjectorTestCase")) : class$org$shiftone$jrat$test$InjectorTestCase);
    public static final String CLASS_NAME = (class$org$shiftone$jrat$test$dummy$CrashTestDummy == null ? (class$org$shiftone$jrat$test$dummy$CrashTestDummy = InjectorTestCase.class$("org.shiftone.jrat.test.dummy.CrashTestDummy")) : class$org$shiftone$jrat$test$dummy$CrashTestDummy).getName();
    protected Class clazz = null;
    static /* synthetic */ Class class$org$shiftone$jrat$test$InjectorTestCase;
    static /* synthetic */ Class class$org$shiftone$jrat$test$dummy$CrashTestDummy;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$String;

    protected void setUp() throws Exception {
        JavaClass oldClass = null;
        JavaClass newClass = null;
        TestClassLoader loader = null;
        byte[] classData = null;
        if (this.clazz == null) {
            oldClass = Repository.lookupClass((String)CLASS_NAME);
            newClass = ClassInjector.injectClass(oldClass, null);
            loader = new TestClassLoader();
            classData = newClass.getBytes();
            loader.addOverrider(CLASS_NAME, classData);
            this.clazz = loader.loadClass(CLASS_NAME);
        }
    }

    private synchronized void save(String className, byte[] bytes) throws Exception {
        String shortName = className.substring(className.lastIndexOf(46) + 1);
        LOG.info("shortName = " + shortName);
        FileOutputStream out = new FileOutputStream(shortName + ".class");
        ((OutputStream)out).write(bytes);
        ((OutputStream)out).close();
    }

    public Object testMethodCall(String methodName, Class[] argTypes, Object[] argValues) throws Exception {
        Method method = this.clazz.getMethod(methodName, argTypes);
        Object o = method.invoke(this.clazz.newInstance(), argValues);
        return o;
    }

    public void testNoArgs() throws Exception {
        this.testMethodCall("noArgs", new Class[0], new Object[0]);
        this.testMethodCall("noArgsSynchronized", new Class[0], new Object[0]);
        this.testMethodCall("noArgsStatic", new Class[0], new Object[0]);
        this.testMethodCall("callAdd", new Class[0], new Object[0]);
        this.testMethodCall("callRecurse", new Class[0], new Object[0]);
        this.testMethodCall("callRecurse", new Class[0], new Object[0]);
        this.testMethodCall("callInLoop_1000", new Class[0], new Object[0]);
        this.testMethodCall("callInLoop_10000", new Class[0], new Object[0]);
        this.testMethodCall("callInLoop_50000", new Class[0], new Object[0]);
        this.testMethodCall("callInLoop_100000", new Class[0], new Object[0]);
        this.testMethodCall("callInLoop_1000000", new Class[0], new Object[0]);
        try {
            this.testMethodCall("throwIOException", new Class[0], new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.testMethodCall("throwRuntimeException", new Class[0], new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNoJRat() throws Exception {
        CrashTestDummy dummy = new CrashTestDummy();
        long start = System.currentTimeMillis();
        dummy.callInLoop_1000();
        LOG.info("callInLoop_1000 took " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        dummy.callInLoop_10000();
        LOG.info("callInLoop_10000 took " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        dummy.callInLoop_50000();
        LOG.info("callInLoop_50000 took " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        dummy.callInLoop_100000();
        LOG.info("callInLoop_100000 took " + (System.currentTimeMillis() - start));
        dummy.callInLoop_1000000();
    }

    public void testOneArg() throws Exception {
        this.testMethodCall("oneBooleanArg", new Class[]{Boolean.TYPE}, new Object[]{Boolean.TRUE});
        this.testMethodCall("oneIntegerArg", new Class[]{Integer.TYPE}, new Object[]{new Integer(101)});
        this.testMethodCall("oneLongArg", new Class[]{Long.TYPE}, new Object[]{new Long(202L)});
        this.testMethodCall("oneObjectArg", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = InjectorTestCase.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{this});
        this.testMethodCall("oneStringArrayArg", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = InjectorTestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}, new Object[]{new String[]{"test", "123"}});
    }

    public void testReturnArg() throws Exception {
        this.testMethodCall("returnBooleanArg", new Class[]{Boolean.TYPE}, new Object[]{Boolean.TRUE});
        this.testMethodCall("returnIntegerArg", new Class[]{Integer.TYPE}, new Object[]{new Integer(101)});
        this.testMethodCall("returnLongArg", new Class[]{Long.TYPE}, new Object[]{new Long(202L)});
        this.testMethodCall("returnObjectArg", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = InjectorTestCase.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{this});
        this.testMethodCall("returnStringArrayArg", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = InjectorTestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}, new Object[]{new String[]{"one", "two", "three"}});
        this.testMethodCall("localVariableLength", new Class[]{class$java$lang$String == null ? (class$java$lang$String = InjectorTestCase.class$("java.lang.String")) : class$java$lang$String}, new Object[]{"test dummy string"});
    }

    public void testTwos() throws Exception {
        this.testMethodCall("twoIntegerArg", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(1), new Integer(2)});
        this.testMethodCall("twoLongArg", new Class[]{Long.TYPE, Long.TYPE}, new Object[]{new Long(1L), new Long(2L)});
        this.testMethodCall("twoObjectArg", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = InjectorTestCase.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = InjectorTestCase.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{this, "that"});
        this.testMethodCall("twoStringArrayArg", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = InjectorTestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = InjectorTestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String}, new Object[]{new String[]{"one", "two", "three"}, new String[]{"test"}});
    }

    public void testMoreArgs() throws Exception {
        boolean[] ba = new boolean[5];
        Class<?> bac = ba.getClass();
        this.testMethodCall("argsByteBooleanArrayObject", new Class[]{Byte.TYPE, bac, class$java$lang$Object == null ? (class$java$lang$Object = InjectorTestCase.class$("java.lang.Object")) : class$java$lang$Object}, new Object[]{new Byte(10), new boolean[]{true, false}, this});
        this.testMethodCall("argsLongObjectLongLongArg", new Class[]{Long.TYPE, class$java$lang$Object == null ? (class$java$lang$Object = InjectorTestCase.class$("java.lang.Object")) : class$java$lang$Object, Long.TYPE, Long.TYPE}, new Object[]{new Long(1L), this, new Long(2L), new Long(123L)});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

