/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.ui.util.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.shiftone.jrat.ui.util.graph.GraphModel;
import org.shiftone.jrat.ui.util.graph.GraphModelSet;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class GraphComponent
extends JComponent
implements Scrollable,
ChangeListener {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$ui$util$graph$GraphComponent == null ? (class$org$shiftone$jrat$ui$util$graph$GraphComponent = GraphComponent.class$("org.shiftone.jrat.ui.util.graph.GraphComponent")) : class$org$shiftone$jrat$ui$util$graph$GraphComponent);
    private static DecimalFormat LONG_FORMAT = new DecimalFormat("###,###,###,###,###");
    private static final Color GRID_LIGHT_COLOR = new Color(220, 220, 220);
    private static final Color GRID_DARK_COLOR = new Color(180, 180, 180);
    private static final Font KEY_FONT = new Font("Monospaced", 0, 11);
    private static final Font TITLE_FONT = new Font("SansSerif", 1, 15);
    private static final int HEADER_PIX = 20;
    private static final int FOOTER_PIX = 5;
    private static final int ABOVE_LINE_PIX = 1;
    private static final int KEY_INDENT_PIX = 3;
    private static final int TITLE_INDENT_PIX = 100;
    private static final int TITLE_HEADER_PIX = 12;
    private static final int DOT_RADIUS_PIX = 2;
    private static final int GAP_THRESH_DOTS = 7;
    private static final int GAP_THRESH_MINOR_LINES = 10;
    private static final int GAP_THRESH_MAJOR_LINES = 4;
    private JViewport viewport = null;
    private int pointGap = 20;
    private GraphModelSet graphModelSet = null;
    static /* synthetic */ Class class$org$shiftone$jrat$ui$util$graph$GraphComponent;

    public GraphComponent() {
        this(new GraphModelSet());
    }

    public GraphComponent(GraphModelSet graphModelSet) {
        this.graphModelSet = graphModelSet;
        graphModelSet.addChangeListener(this);
    }

    public int getPointGap() {
        return this.pointGap;
    }

    public void setPointGap(int pointGap) {
        if (this.pointGap != pointGap) {
            this.pointGap = pointGap;
            this.setSize(this.getPreferredSize());
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }

    public GraphModelSet getGraphModelSet() {
        return this.graphModelSet;
    }

    public void setGraphModelSet(GraphModelSet graphModelSet) {
        this.graphModelSet = graphModelSet;
    }

    public void paintGraph(Graphics g, GraphModel graph, double ratio, long minValue, int firstPoint, int lastPoint) {
        Color lineColor = graph.getColor();
        Color dotColor = lineColor.darker();
        for (int i = firstPoint + 1; i < lastPoint; ++i) {
            int px = (i - 1) * this.pointGap;
            int tx = (i + 0) * this.pointGap;
            long pValue = graph.getValue(i - 1) - minValue;
            long tValue = graph.getValue(i - 0) - minValue;
            int py = (int)((double)pValue * ratio);
            int ty = (int)((double)tValue * ratio);
            g.setColor(lineColor);
            g.drawLine(px, this.getHeight() - 5 - py, tx, this.getHeight() - 5 - ty);
            if (this.pointGap <= 7) continue;
            g.setColor(dotColor);
            g.fillRect(tx - 2, this.getHeight() - 5 - ty - 2, 4, 4);
        }
    }

    private void paintGraphSet(Graphics g, GraphModelSet graphSet, Rectangle viewRect, int firstPoint, int lastPoint) {
        int fontHeight = g.getFontMetrics(KEY_FONT).getHeight();
        int height = this.getHeight();
        int viewRectWidth = (int)viewRect.getWidth();
        int x = (int)viewRect.getX();
        int minY = this.getHeight() - 5;
        int keys = height / fontHeight;
        long maxValue = graphSet.getMaxValue();
        long minValue = graphSet.getMinValue();
        long valueDelta = maxValue - minValue;
        long[] keyValues = null;
        g.setFont(KEY_FONT);
        this.paintVerticleLines(firstPoint, lastPoint, g);
        keys = Math.max(keys, 1);
        keyValues = this.calcKeyValues(minValue, keys, maxValue, valueDelta);
        if (maxValue > 0L && valueDelta > 0L) {
            int y;
            long value;
            int i;
            double ratio = (double)(this.getHeight() - 20 - 5) / (double)valueDelta;
            for (i = 0; i < keyValues.length; ++i) {
                value = keyValues[i];
                y = minY - (int)(ratio * (double)(value - minValue));
                g.setColor(GRID_LIGHT_COLOR);
                g.drawLine(x, y, x + viewRectWidth, y);
            }
            for (i = 0; i < graphSet.getGraphModelCount(); ++i) {
                this.paintGraph(g, graphSet.getGraphModel(i), ratio, minValue, firstPoint, lastPoint);
            }
            for (i = 0; i < keyValues.length; ++i) {
                value = keyValues[i];
                y = minY - (int)(ratio * (double)(value - minValue));
                g.setColor(Color.black);
                g.setXORMode(Color.white);
                g.drawString(GraphComponent.toString(value), x + 3, y - 1);
            }
        }
        if (graphSet.getTitle() != null) {
            g.setColor(Color.black);
            g.setFont(TITLE_FONT);
            g.drawString(graphSet.getTitle(), x + 100, 12);
        }
    }

    private long[] calcKeyValues(long minValue, int keys, long maxValue, long valueDelta) {
        long[] keyValues = new long[keys];
        try {
            keyValues[0] = minValue;
            keyValues[keyValues.length - 1] = maxValue;
            for (int i = 1; i < keyValues.length - 1; ++i) {
                keyValues[i] = minValue + (long)((int)((double)(valueDelta * (long)i) / (double)(keyValues.length - 1)));
            }
        }
        catch (Exception e) {
            LOG.info("calcKeyValues " + keys, e);
        }
        return keyValues;
    }

    private void paintVerticleLines(int firstPoint, int lastPoint, Graphics g) {
        g.setColor(GRID_LIGHT_COLOR);
        for (int i = firstPoint + 1; i < lastPoint; ++i) {
            if (i % 10 == 0) {
                if (this.pointGap <= 4 && i % 100 != 0) continue;
                g.setColor(GRID_DARK_COLOR);
                g.drawLine(this.pointGap * i, 0, this.pointGap * i, this.getHeight());
                g.drawString(GraphComponent.toString(i), this.pointGap * i + 2, 12);
                g.setColor(GRID_LIGHT_COLOR);
                continue;
            }
            if (this.pointGap <= 10) continue;
            g.drawLine(this.pointGap * i, 0, this.pointGap * i, this.getHeight());
        }
    }

    private static synchronized String toString(long l) {
        return LONG_FORMAT.format(l);
    }

    public void paintComponent(Graphics g) {
        Rectangle viewRect = this.viewport == null ? this.getBounds() : this.viewport.getViewRect();
        int dataPoints = this.getDataPointCount();
        int firstPoint = (int)(viewRect.getX() / (double)this.pointGap);
        int lastPoint = (int)(viewRect.getWidth() / (double)this.pointGap) + firstPoint;
        lastPoint = Math.min(lastPoint + 2, dataPoints);
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintGraphSet(g, this.graphModelSet, viewRect, firstPoint, lastPoint);
    }

    private int getDataPointCount() {
        return this.graphModelSet.getMaxPointCount();
    }

    public void addNotify() {
        super.addNotify();
        LOG.info("addNotify");
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            LOG.info("getParent() = " + container);
            if (!(container instanceof JViewport)) continue;
            LOG.info("container instanceof JViewport");
            this.viewport = (JViewport)container;
            break;
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.pointGap;
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.pointGap;
    }

    public Dimension getPreferredSize() {
        return new Dimension((this.getDataPointCount() - 1) * this.pointGap, this.getHeight());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

