/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.shiftone.jrat.util.NestedRuntimeException;
import org.shiftone.jrat.util.WeakScheduler;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class AsyncOutputStream
extends OutputStream
implements Runnable {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$AsyncOutputStream == null ? (class$org$shiftone$jrat$util$AsyncOutputStream = AsyncOutputStream.class$("org.shiftone.jrat.util.AsyncOutputStream")) : class$org$shiftone$jrat$util$AsyncOutputStream);
    private static final int INITIAL_BUFFER_SIZE = 524288;
    private static final int DEFAULT_SYNC_THRESHOLD = 0x100000;
    private static final int FLUSH_FREQUENCY = 500;
    private static final WeakScheduler SCHEDULER = new WeakScheduler();
    private int syncThreshold = 0x100000;
    private Object bufferLock = new Object();
    private Object targetLock = new Object();
    private ByteArrayOutputStream buffer;
    private OutputStream target;
    static /* synthetic */ Class class$org$shiftone$jrat$util$AsyncOutputStream;

    public AsyncOutputStream(OutputStream outputStream) {
        this.target = outputStream;
        this.buffer = AsyncOutputStream.newBuffer();
        SCHEDULER.schedule(this, 500L);
    }

    private static ByteArrayOutputStream newBuffer() {
        return new ByteArrayOutputStream(524288);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] swapBuffer() {
        ByteArrayOutputStream oldOutputStream = null;
        Object object = this.bufferLock;
        synchronized (object) {
            oldOutputStream = this.buffer;
            this.buffer = AsyncOutputStream.newBuffer();
        }
        return oldOutputStream.toByteArray();
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        byte[] oldBuffer = this.swapBuffer();
        if (oldBuffer.length > 0) {
            Object object = this.targetLock;
            synchronized (object) {
                LOG.info("flush " + oldBuffer.length);
                this.target.write(oldBuffer);
                this.target.flush();
            }
        }
    }

    private void performSyncIfNeeded() throws IOException {
        if (this.buffer.size() >= this.syncThreshold) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.write(arg0, arg1, arg2);
            this.performSyncIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] arg0) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.write(arg0);
            this.performSyncIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int arg0) throws IOException {
        Object object = this.bufferLock;
        synchronized (object) {
            this.buffer.write(arg0);
            this.performSyncIfNeeded();
        }
    }

    public void run() {
        try {
            this.flush();
        }
        catch (Exception e) {
            throw new NestedRuntimeException("error flushing async output stream", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

