/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.shiftone.jrat.util.GlobMatcher;
import org.shiftone.jrat.util.IOUtil;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class GlobClassLoader
extends URLClassLoader {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$GlobClassLoader == null ? (class$org$shiftone$jrat$util$GlobClassLoader = GlobClassLoader.class$("org.shiftone.jrat.util.GlobClassLoader")) : class$org$shiftone$jrat$util$GlobClassLoader);
    private ClassLoader parent = null;
    private GlobMatcher globMatcher = null;
    static /* synthetic */ Class class$org$shiftone$jrat$util$GlobClassLoader;

    public GlobClassLoader(URL[] urls, String globPattern, ClassLoader parent) {
        super(urls, parent);
        this.parent = parent;
        this.globMatcher = new GlobMatcher(globPattern);
    }

    public GlobClassLoader(File file, String globPattern, ClassLoader parent) throws MalformedURLException {
        this(new URL[]{file.toURL()}, globPattern, parent);
    }

    public GlobClassLoader(URL[] urls, String globPattern) {
        super(urls);
        this.globMatcher = new GlobMatcher(globPattern);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> klass = null;
        klass = this.globMatcher.isMatch(name) ? this.loadClassHere(name) : super.loadClass(name, resolve);
        return klass;
    }

    private Class loadClassHere(String name) throws ClassNotFoundException {
        Class<?> klass = null;
        String resourceName = null;
        byte[] bytes = null;
        LOG.debug("loadClassHere(" + name + ")");
        try {
            resourceName = name.replace('.', '/').concat(".class");
            bytes = this.loadClassData(resourceName);
            klass = this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("not found :" + name, e);
        }
        return klass;
    }

    private byte[] loadClassData(String resourceName) throws IOException {
        Object loader = null;
        ByteArrayOutputStream out = null;
        InputStream in = null;
        in = this.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IOException("class resource not found : " + resourceName);
        }
        out = new ByteArrayOutputStream();
        IOUtil.copy(in, out);
        return out.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

