/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class IOUtil {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$IOUtil == null ? (class$org$shiftone$jrat$util$IOUtil = IOUtil.class$("org.shiftone.jrat.util.IOUtil")) : class$org$shiftone$jrat$util$IOUtil);
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    static /* synthetic */ Class class$org$shiftone$jrat$util$IOUtil;

    public static void delete(File file) throws IOException {
        Assert.assertNotNull("file", file);
        LOG.debug("delete(" + file + ")");
        if (!file.delete()) {
            if (file.exists()) {
                throw new IOException("unable to delete file : " + file.getAbsolutePath());
            }
            throw new IOException("unable to delete non-existant file : " + file.getAbsolutePath());
        }
    }

    public static void mkdir(File dir) throws IOException {
        Assert.assertNotNull("dir", dir);
        LOG.info("mkdir(" + dir.getAbsolutePath() + ")");
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new IOException("unable to create directory because file with same name exists " + dir);
        }
        if (!dir.mkdirs()) {
            throw new IOException("unable to create directory : " + dir);
        }
    }

    public static void rename(File source, File target, boolean replace) throws IOException {
        Assert.assertNotNull("source", source);
        Assert.assertNotNull("target", target);
        if (!source.exists()) {
            throw new IOException("source file does not exist : " + source);
        }
        if (target.exists() && replace) {
            LOG.debug("rename.delete(" + target + ")");
            if (!target.delete()) {
                throw new IOException("unable to delete file : " + target.getAbsolutePath());
            }
        }
        LOG.debug("rename(" + source + " , " + target + ")");
        if (!source.renameTo(target)) {
            throw new IOException("unable to rename " + source.getAbsolutePath() + " to " + target.getAbsolutePath());
        }
    }

    public static void copy(InputStream sourceStream, OutputStream targetStream, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int b = 0;
        Assert.assertNotNull("sourceStream", sourceStream);
        Assert.assertNotNull("targetStream", targetStream);
        b = 0;
        while (b >= 0) {
            if (b != 0) {
                targetStream.write(buffer, 0, b);
            }
            b = sourceStream.read(buffer);
        }
    }

    public static void copy(InputStream sourceStream, OutputStream targetStream) throws IOException {
        IOUtil.copy(sourceStream, targetStream, 4096);
    }

    public static boolean copy(File source, File target) throws IOException {
        Assert.assertNotNull("source", source);
        Assert.assertNotNull("target", target);
        LOG.debug("copy(" + source.getAbsolutePath() + " , " + target.getAbsolutePath() + ")");
        if (source.equals(target)) {
            LOG.debug("copy doing nothing, source and target are same");
            return false;
        }
        BufferedInputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        int bufferSize = (int)Math.min(4096L, source.length());
        inputStream = new BufferedInputStream(new FileInputStream(source), bufferSize);
        outputStream = new BufferedOutputStream(new FileOutputStream(target), bufferSize);
        IOUtil.copy(inputStream, outputStream);
        IOUtil.close(outputStream);
        IOUtil.close(inputStream);
        return true;
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            LOG.warn("close Reader failes", e);
        }
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception e) {
            LOG.warn("close Writer failes", e);
        }
    }

    public static void close(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception e) {
            LOG.warn("close Socket failes", e);
        }
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            LOG.warn("close InputStream failes", e);
        }
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception e) {
            LOG.warn("close OutputStream failes", e);
        }
    }

    public static void flush(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.flush();
            }
        }
        catch (Exception e) {
            LOG.warn("flush OutputStream failes", e);
        }
    }

    public static String getExtention(File file) {
        Assert.assertNotNull("file", file);
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        return lastDot == -1 ? "" : name.substring(lastDot + 1);
    }

    public static File getNearestExistingParent(File file) {
        File p;
        Assert.assertNotNull("file", file);
        for (p = file.getParentFile(); p != null && !p.exists(); p = p.getParentFile()) {
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

