/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.shiftone.jrat.core.ConfigurationException;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Log;
import org.shiftone.jrat.util.log.LogFactory;

public class ResourceUtil {
    private static final Log LOG = LogFactory.getLogger(class$org$shiftone$jrat$util$ResourceUtil == null ? (class$org$shiftone$jrat$util$ResourceUtil = ResourceUtil.class$("org.shiftone.jrat.util.ResourceUtil")) : class$org$shiftone$jrat$util$ResourceUtil);
    private static ClassLoader CLASS_LOADER = (class$org$shiftone$jrat$util$ResourceUtil == null ? (class$org$shiftone$jrat$util$ResourceUtil = ResourceUtil.class$("org.shiftone.jrat.util.ResourceUtil")) : class$org$shiftone$jrat$util$ResourceUtil).getClassLoader();
    private static Map resourceCache = new Hashtable();
    static /* synthetic */ Class class$org$shiftone$jrat$util$ResourceUtil;

    public static Object newInstance(String className) throws ConfigurationException {
        Class<?> klass = null;
        Object instance = null;
        Assert.assertNotNull("className", className);
        LOG.debug("newInstance(" + className + ")");
        try {
            klass = CLASS_LOADER.loadClass(className);
        }
        catch (Exception e) {
            throw new ConfigurationException("unable to load class '" + className + "'", e);
        }
        try {
            instance = klass.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("unable to instantiate '" + className + "'", e);
        }
        return instance;
    }

    public static InputStream loadResourceAsStream(String resourceName) throws ConfigurationException {
        InputStream inputStream = null;
        LOG.info("load resource : " + resourceName);
        Assert.assertNotNull("resourceName", resourceName);
        inputStream = CLASS_LOADER.getResourceAsStream(resourceName);
        if (inputStream == null) {
            LOG.info("resource not found on classpath, trying to open as file");
            try {
                inputStream = new FileInputStream(resourceName);
                LOG.debug("resource opened as file");
            }
            catch (Exception e) {
                throw new ConfigurationException("unable to locate resource : " + resourceName);
            }
        } else {
            LOG.debug("resource opened from classpath");
        }
        return inputStream;
    }

    private static String fetchResource(String name) throws ConfigurationException {
        InputStreamReader reader = null;
        StringBuffer sb = null;
        InputStream inputStream = null;
        int c = 0;
        char[] buffer = new char[1025];
        Assert.assertNotNull("name", name);
        LOG.debug("fetchResource : " + name);
        inputStream = ResourceUtil.loadResourceAsStream(name);
        reader = new InputStreamReader(inputStream);
        sb = new StringBuffer();
        try {
            c = 0;
            while (c >= 0) {
                sb.append(buffer, 0, c);
                c = reader.read(buffer);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("unable to read resource data : " + name, e);
        }
        return sb.toString();
    }

    public static String loadResource(String name) throws ConfigurationException {
        String resource = null;
        Assert.assertNotNull("name", name);
        resource = (String)resourceCache.get(name);
        if (resource == null) {
            LOG.info("loading and caching resource : " + name);
            resource = ResourceUtil.fetchResource(name);
            resourceCache.put(name, resource);
        }
        return resource;
    }

    public static Properties getResourceAsProperties(String name) throws ConfigurationException {
        InputStream inputStream = null;
        Properties props = null;
        Assert.assertNotNull("name", name);
        LOG.debug("getResourceAsProperties : " + name);
        inputStream = ResourceUtil.loadResourceAsStream(name);
        props = new Properties();
        try {
            props.load(inputStream);
        }
        catch (Exception e) {
            throw new ConfigurationException("unable to load properties from resource : " + name, e);
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

