//import java.util.*;
import gnu.trove.*;
import java.io.*;

class c4test
{
    public static void main(String[] args)
    {
        runit();
        runit();
    }
    
    static void runit()
    {
        final int connect=4; //4
        final int cols=4; //7
        final int rows=4; //6
        
        qcsp prob = new c4(rows, cols);
        gac_schema_predicate big_constraint=null;
        hash_var[] a_moves=new hash_var[rows*cols]; // universal move variables, to be shadowed by the existential ones below.
        
        hash_var[] moves=new hash_var[rows*cols];
        
        hash_var zero=new existential(1, prob, "zero"); // useful constant.
        
        hash_var[][][] board=new hash_var[rows*cols][][];   // board[move][column][row] *after* move.
        
        hash_var[][] height=new hash_var[rows*cols][];      // height after the move.
        
        hash_var[] gamestate=new hash_var[rows*cols];  // 0 = first player has won, 1 = second player has won. 2 = neither.
        
        hash_var[] line=new hash_var[rows*cols];  // whether a line exists at move n.
        
        line[0]=zero;
        //hash_var[] xline=new hash_var[9];
        //hash_var[] oline=new hash_var[9];
        
        //boolean big_end_cons=true; // do we have all 9 moves, or 6 moves and a big end constraint?
        
        boolean sqgac=true;  // use sqgac or wqgac. 
        
        assert rows>=4 && cols>=4; // must be allowed vertical and horizontal lines or the logic goes wrong.
        
        for(int move=0; move< rows*cols; move++)
        {
            if((move%2)==1)  // odd numbers
            {
                a_moves[move]=new universal(cols, prob, "a_move"+move);
            }
            moves[move]=new existential(cols, prob, "move"+move);
            
            // board state hash_vars
            board[move]=new hash_var[cols][];
            for(int column=0; column<cols; column++)
            {
                board[move][column]=new hash_var[rows];
                for(int row=0; row<rows; row++)
                {
                    board[move][column][row]=new existential(3, prob, "board["+move+"]["+column+"]["+row+"]");
                }
            }
            
            // column heights
            height[move]=new hash_var[cols];
            for(int column=0; column<cols; column++)
            {
                height[move][column]=new existential(rows+1, prob, "height["+move+"]["+column+"]");
            }
            
            // winstate per move *after* move.
            
            gamestate[move]=new existential(3, prob, "winstate"+move);
            
            //xline[move]=new existential(2, prob, "xline"+move);
            //oline[move]=new existential(2, prob, "oline"+move);
            
            // connect move variables to board variables.
            if(move==0)
            {
                for(int col=0; col<cols; col++)
                {
                    {predicate_wrapper p1=new c4redmove_pred(col, rows);
                    hash_var[] gsvars = new hash_var[rows+3];
                    gsvars[0]=zero;
                    gsvars[1]=zero;
                    gsvars[2]=moves[move];
                    for(int i=0; i<rows; i++) gsvars[i+3]=board[move][col][i];

                    if(sqgac)
                    {
                        sqgac cons= new sqgac(gsvars, prob, p1);
                    }
                    else
                    {
                        gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    }
                    }
                }
            }
            else
            {
                for(int col=0; col<cols; col++)
                {
                    {predicate_wrapper p1;
                    if(move%2==0)
                        p1=new c4redmove_pred(col, rows);
                    else
                        p1=new c4blackmove_pred(col, rows);
                    hash_var[] gsvars = new hash_var[rows+3];
                    gsvars[0]=line[move-1];
                    gsvars[1]=height[move-1][col];
                    gsvars[2]=moves[move];
                    for(int i=0; i<rows; i++) gsvars[i+3]=board[move][col][i];

                    if(sqgac)
                    {
                        sqgac cons= new sqgac(gsvars, prob, p1);
                    }
                    else
                    {
                        gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    }
                    }
                }
            }
            
            if(move%2==1)
            {   // black move.
                //connect a_moves[move] to moves[move]
                
                for(int col=0; col<cols; col++)
                {
                    {predicate_wrapper p1=new c4purecons_pred(col, rows);
                    mid_domain[] gsvars = new mid_domain[4];
                    
                    gsvars[0]=gamestate[move-1];
                    gsvars[1]=height[move-1][col];
                    gsvars[2]=a_moves[move];
                    gsvars[3]=moves[move];
                    if(sqgac)
                    {
                        sqgac cons= new sqgac(gsvars, prob, p1);
                    }
                    else
                    {
                        gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    }
                    }
                }
            }
            
            // board state -- map existing pieces forward.
            if(move>0)
            {
            for(int col=0; col<cols; col++)
            {
                for(int row=0; row<rows; row++)
                {
                    {predicate_wrapper p1=new c4boardstate_pred();
                    hash_var[] gsvars = new hash_var[2];
                    gsvars[0]=board[move-1][col][row];
                    gsvars[1]=board[move][col][row];
                    
                    if(sqgac)
                    {
                        sqgac cons= new sqgac(gsvars, prob, p1);
                    }
                    else
                    {
                        gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    }
                    }
                }
            }}
            
            // Map forward the height variables.
            
            if(move>0)
            {
            for(int col=0; col<cols; col++)
            {
                {predicate_wrapper p1=new c4reviseheight_pred(col, rows);
                hash_var[] gsvars = new hash_var[4];
                gsvars[0]=line[move-1];
                gsvars[1]=height[move-1][col];
                gsvars[2]=moves[move];
                gsvars[3]=height[move][col];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                }
            }}
            else
            {
            for(int col=0; col<cols; col++)
            {
                // first move--use zero for the previous height
                {predicate_wrapper p1=new c4reviseheight_pred(col, rows);
                hash_var[] gsvars = new hash_var[4];
                gsvars[0]=zero;
                gsvars[1]=zero;
                gsvars[2]=moves[move];
                gsvars[3]=height[move][col];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                }
            }}
            
            // map forward the gamestate variable -- now done along with the line detection.
            /*
            if(move>0)
            {
                {predicate_wrapper p1=new c4boardstate_pred();
                hash_var[] gsvars = new hash_var[2];
                gsvars[0]=gamestate[move-1];
                gsvars[1]=gamestate[move];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                }
            }*/
            if(move>0)
            {
            // detect lines and map onto gamestate var.
            
            int diags=(rows-3+cols-3-1)*2;  // each dimension, minus 3, then minus the one shared one. In both directions.
            diags=(diags<0)?0:diags;
            assert diags>0;
            
            int numcons=0;  // counter
            hash_var[] temps= new hash_var[rows+cols+diags]; // boolean vars which indicate 
            for(int i=0; i<(rows+cols+diags); i++)
                temps[i]=new existential(2, prob, "linei"+move+","+i);  // new boolean.
            
            // horizontal lines
            for(int row=0; row<rows; row++)
            {
                {predicate_wrapper p1=new c4findline_pred(connect);
                hash_var[] gsvars = new hash_var[cols+2];
                gsvars[0]=line[move-1];
                for(int i=0; i<cols; i++) gsvars[i+1]=board[move][i][row];
                gsvars[cols+1]=temps[numcons];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                numcons++;
                }
            }
            
            // vertical lines
            for(int col=0; col<cols; col++)
            {
                {predicate_wrapper p1=new c4findline_pred(connect);
                hash_var[] gsvars = new hash_var[rows+2];
                gsvars[0]=line[move-1];
                for(int i=0; i<rows; i++) gsvars[i+1]=board[move][col][i];
                gsvars[rows+1]=temps[numcons];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                numcons++;
                }
            }
            
            // diagonal lines --downward from left diagonal.\\\\
            for(int col=cols-4; col>0; col--)  // do not include 0.
            {
                {predicate_wrapper p1=new c4findline_pred(connect);
                int length=0;
                for(int i=0; (i<rows && col+i<cols); i++) length++;
                hash_var[] gsvars = new hash_var[length+2];
                gsvars[0]=line[move-1];
                for(int i=0; (i<rows && col+i<cols); i++) gsvars[i+1]=board[move][col+i][rows-i-1];
                gsvars[length+1]=temps[numcons];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                numcons++;
                }
            }
            for(int row=rows-1; row>2; row--)
            {
                {predicate_wrapper p1=new c4findline_pred(connect);
                int length=0;
                for(int i=0; (i<cols && row-i>=0); i++) length++;
                hash_var[] gsvars = new hash_var[length+2];
                gsvars[0]=line[move-1];
                for(int i=0; (i<cols && row-i>=0); i++) gsvars[i+1]=board[move][i][row-i];
                gsvars[length+1]=temps[numcons];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                numcons++;
                }
            }
            
            // other diagonal, i.e. //
            for(int row=3; row<rows; row++)  // includes the shared one.
            {
                {predicate_wrapper p1=new c4findline_pred(connect);
                int length=0;
                for(int i=0; (row-i>=0 && cols-i-1>=0); i++) length++;
                hash_var[] gsvars = new hash_var[length+2];
                gsvars[0]=line[move-1];
                for(int i=0; (row-i>=0 && cols-i-1>=0); i++) gsvars[i+1]=board[move][cols-i-1][row-i];
                gsvars[length+1]=temps[numcons];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                numcons++;
                }
            }
            for(int col=cols-2; col>=3; col--)
            {
                {predicate_wrapper p1=new c4findline_pred(connect);
                int length=0;
                for(int i=0; (rows-i-1>=0 && col-i>=0); i++) length++;
                hash_var[] gsvars = new hash_var[length+2];
                gsvars[0]=line[move-1];
                for(int i=0; (rows-i-1>=0 && col-i>=0); i++) gsvars[i+1]=board[move][col-i][rows-i-1];
                gsvars[length+1]=temps[numcons];
                
                if(sqgac)
                {
                    sqgac cons= new sqgac(gsvars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                }
                numcons++;
                }
            }
            assert numcons==rows+cols+diags && temps.length==rows+cols+diags;
            
            // now conjunct the temps
            // set gamestate to x if it is not already set and there is a line.
            {mid_domain [] disjunction=new mid_domain[rows+cols+diags+2];
            disjunction[0]=line[move-1];
            for(int i=0; i<temps.length; i++) disjunction[i+1]=temps[i];
            line[move]=new existential(2, prob, "line"+move);
            
            disjunction[rows+cols+diags+1]=line[move];
            boolean[] neg=new boolean[rows+cols+diags+2];
            for(int i=0; i<rows+cols+diags+2; i++) neg[i]=false;
            
            constraint c1=new or_constraint(disjunction, neg, rows+cols+diags+1, prob);
            
            if(move%2==0) // red move. Connect t1 to gamestate[move-1] and gamestate[move]
            {
                mid_domain[] vars={gamestate[move-1], line[move], gamestate[move]};
                predicate_wrapper p1=new c4gamestate_pred(0);
                if(sqgac)
                {
                    sqgac cons= new sqgac(vars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(vars, prob, p1);
                }
            }
            else
            {
                // set gamestate to 1 if it is not already set and there is a new line.
                mid_domain[] vars={gamestate[move-1], line[move], gamestate[move]};
                predicate_wrapper p1=new c4gamestate_pred(1);
                if(sqgac)
                {
                    sqgac cons= new sqgac(vars, prob, p1);
                }
                else
                {
                    gac_schema_predicate cons= new gac_schema_predicate(vars, prob, p1);
                }
            }
            }
            }// end move>0
            
            /////////////////////////////////////////////////////////////////////////////////
            // Intelligent play constraints
            
            // 
            /*
            if(move>=(connect-1)*2 && move%2==0) // for red moves when a line can be formed by red.
            {
                // Can't be bothered with diagonals just now.
                // horizontal lines -- forming line by placing piece to the right.
                for(int row=0; row<rows; row++)
                {
                    for(int col=0; col<cols-connect+1; col++)
                    {
                        // starting at row, col extending right.
                        predicate_wrapper p1=new c4trivialwin_pred(row);
                        hash_var[] gsvars = new hash_var[];
                        gsvars[0]=line[move-1];
                        for(int i=0; i<cols; i++) gsvars[i+1]=board[move][i][row];
                        gsvars[cols+1]=temps[numcons];

                        if(sqgac)
                        {
                            sqgac cons= new sqgac(gsvars, prob, p1);
                        }
                        else
                        {
                            gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                        }
                        numcons++;
                    }
                }
                // horizontal lines -- forming line by placing piece to the left.
                for(int row=0; row<rows; row++)
                {
                    {predicate_wrapper p1=new c4trivialwin_pred(connect);
                    hash_var[] gsvars = new hash_var[cols+2];
                    gsvars[0]=line[move-1];
                    for(int i=0; i<cols; i++) gsvars[i+1]=board[move][i][row];
                    gsvars[cols+1]=temps[numcons];

                    if(sqgac)
                    {
                        sqgac cons= new sqgac(gsvars, prob, p1);
                    }
                    else
                    {
                        gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    }
                    numcons++;
                    }
                }
                // vertical lines
                for(int col=0; col<cols; col++)
                {
                    {predicate_wrapper p1=new c4findline_pred(connect);
                    hash_var[] gsvars = new hash_var[rows+2];
                    gsvars[0]=line[move-1];
                    for(int i=0; i<rows; i++) gsvars[i+1]=board[move][col][i];
                    gsvars[rows+1]=temps[numcons];

                    if(sqgac)
                    {
                        sqgac cons= new sqgac(gsvars, prob, p1);
                    }
                    else
                    {
                        gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    }
                    numcons++;
                    }
                }
            }*/
            
            // choose a move at random to begin with.
            if(move==11)
            {
                // four-move lookahead, looks at 4 move variables.
                assert (move-3)%2==0;  // first var is existential.
                c4lookahead_pred p1=new c4lookahead_pred(rows, cols);
                hash_var[] gsvars = new hash_var[rows*cols+4];
                p1.prob=prob;
                
                for(int col=0; col<cols; col++)
                {
                    for(int row=0; row<rows; row++)
                    {
                        gsvars[row+(col*rows)]=board[move-4][col][row];
                    }
                }
                gsvars[rows*cols]=moves[move-3];
                gsvars[rows*cols+1]=a_moves[move-2];
                gsvars[rows*cols+2]=moves[move-1];
                gsvars[rows*cols+3]=a_moves[move];
                
                //if(false)
                //{
                //    sqgac cons= new sqgac(gsvars, prob, p1);
                //}
                //else
                //{
                    //gac_schema_predicate cons= new gac_schema_predicate(gsvars, prob, p1);
                    big_constraint= new gac_schema_predicate(gsvars, prob, p1);
                    
                    int [] t1={0,1,0,1,0,1,0,1,2,2,2,2,2,2,2,2, 2,3,3,3};
                    tuple tau=new tuple(t1);
                    System.out.println(p1.predicate(tau));
                    
                    System.exit(0);
                    
                //}
            }
        }
        
        /*if(big_end_cons)
        {
            moves[6]=new existential(3, prob, "move6");

            moves[7]=new universal(2, prob, "move7");

            // make the big end constraint
            // last three moves -- last move is unit.
            {hash_var [] tempvar=new hash_var[12];
            System.arraycopy(board[5], 0, tempvar, 0, 9);
            tempvar[9]=winstate[5];

            tempvar[10]=moves[6];
            tempvar[11]=moves[7];

            for(int i=0; i<tempvar.length; i++)
                System.out.println(tempvar[i]+" ");

            System.out.println();

            lastmoves_predicate p1=new lastmoves_predicate();
            if(sqgac)
            {
                sqgac cons2= new sqgac(tempvar, prob, p1);
            }
            else
            {
                gac_schema_predicate cons2= new gac_schema_predicate(tempvar, prob, p1);
            }
            }
        }*/
        
        prob.pure_setup_universals();  // enables the pure value rule, could take some time to execute since it constructs the whole problem again!
        
        System.out.println(prob.constraints.toString());
        
        // root node processing here.
        //System.out.println("Establish GAC list:");
        //System.out.println(prob.queue.toestablish);
        
        StopWatch sw= new StopWatch("GMT");
        sw.start();
        prob.establish();
        
        // set some variables
        
        if(gamestate[0].is_present(0)) gamestate[0].exclude(0, null);
        if(gamestate[0].is_present(1)) gamestate[0].exclude(1, null);
        
        gamestate[rows*cols-1].exclude(1, null); // make sure red wins.
        gamestate[rows*cols-1].exclude(2, null);
        
        // symmetry breaking
        if(cols%2==0)
        {   // even width
            // first move on left hand side of board.
            for(int i=(cols/2); i<cols; i++)
                if(moves[0].is_present(i)) moves[0].exclude(i, null);
        }
        else
        {
            // the first player who does not play in the centre, plays on the left. Is what it should be.
            
            System.out.println("WARNING: this does not entirely break the symmetry for problems where the number of cols is odd.");
            for(int i=(cols/2)+1; i<cols; i++)
                if(moves[0].is_present(i)) moves[0].exclude(i, null);
        }
        
        prob.backtrack.add_backtrack_level();
        
        prob.propagate();
        
        sw.end();
        System.out.println("Setup time: "+sw.elapsedMillis());
        
        prob.printdomains();
        
        System.out.println(prob.blocks);
        
        //System.out.println(
        sw= new StopWatch("GMT");
        
        sw.start();
        System.out.println(prob.search());
        
        //moves[0].instantiate(0);
        
        //prob.propagate();
        
        //prob.printdomains();
        
        sw.end();
        System.out.println("Search time: "+sw.elapsedMillis()+" , Nodes:"+prob.numnodes);
        
        if(prob.root!=null)
        {
        try
        {
        File output = new File("connectfourfull.dot");
        
        FileWriter out = new FileWriter(output);
        
        out.write(prob.printtree());
        
        out.close();
        }
        catch(java.io.IOException e)
        {
            System.out.println("Problem writing connectfourfull.dot");
        }}
        //System.out.println(cons);
    }
}
