// A constraint which implements a comparison x <==> y iff b

// Started on Firday 3rd March

// Attempts SQGAC
// warning: there may be a problem if one of x or y is mid_domain but the other is not.

package queso.constraints;

import queso.core.*;

//import gnu.trove.*;
import java.util.Random;
import gnu.math.*;
//import java.io.*;   // for test

public final class comparison_constraint extends constraint implements make_ac
{
    // breaks the usual assumption of having all variables in one array.
    final intnum_bounds[] compare;
    final mid_domain boolvar;
    final variable_iface[] variables;
    
    final int comparison;  // -2 for <, -1 for <=, 0 for ==, 1 for >=, 2 for >, 3 for !=
    final int revcom;  // the negated comparison of the above.
    
    public comparison_constraint(mid_domain [] compare, mid_domain boolvar, int comparison, qcsp problem)
    {
        super(problem);
        
        intnum_bounds [] cmpr={(intnum_bounds)compare[0], (intnum_bounds)compare[1]};
        
        this.compare=cmpr;
        this.boolvar=boolvar;
        this.comparison=comparison;
        
        check_variables(compare);
        variables=new variable_iface[3];
        if(boolvar.id()>compare[1].id())
        {
            variables[2]=(variable_iface)boolvar;
            variables[0]=(variable_iface)compare[0];
            variables[1]=(variable_iface)compare[1];
        }
        else if(boolvar.id()>compare[0].id())
        {
            variables[1]=(variable_iface)boolvar;
            variables[0]=(variable_iface)compare[0];
            variables[2]=(variable_iface)compare[1];
        }
        else
        {
            variables[0]=(variable_iface)boolvar;
            variables[1]=(variable_iface)compare[0];
            variables[2]=(variable_iface)compare[1];
        }
        
        check_variables(variables);
        
        assert compare.length==2;
        assert comparison>=-2 && comparison<=3;
        
        // a few useful constants.
        zero = new IntNum(0);
        one = new IntNum(1);
        minusone=new IntNum(-1);
        
        if(comparison==-2) revcom=1;
        else if(comparison==-1) revcom=2;
        else if(comparison==0) revcom=3;
        else if(comparison==1) revcom=-2;
        else if(comparison==2) revcom=-1;
        else revcom=0;
    }
    
    public comparison_constraint(intnum_bounds [] compare, mid_domain boolvar, int comparison, qcsp problem)
    {
        super(problem);
        this.compare=compare;
        this.boolvar=boolvar;
        this.comparison=comparison;
        
        check_variables(compare);
        variables=new variable_iface[3];
        if(boolvar.id()>compare[1].id())
        {
            variables[2]=(variable_iface)boolvar;
            variables[0]=(variable_iface)compare[0];
            variables[1]=(variable_iface)compare[1];
        }
        else if(boolvar.id()>compare[0].id())
        {
            variables[1]=(variable_iface)boolvar;
            variables[0]=(variable_iface)compare[0];
            variables[2]=(variable_iface)compare[1];
        }
        else
        {
            variables[0]=(variable_iface)boolvar;
            variables[1]=(variable_iface)compare[0];
            variables[2]=(variable_iface)compare[1];
        }
        
        check_variables(variables);
        
        assert compare.length==2;
        assert comparison>=-2 && comparison<=3;
        
        // a few useful constants.
        zero = new IntNum(0);
        one = new IntNum(1);
        minusone=new IntNum(-1);
        
        if(comparison==-2) revcom=1;
        else if(comparison==-1) revcom=2;
        else if(comparison==0) revcom=3;
        else if(comparison==1) revcom=-2;
        else if(comparison==2) revcom=-1;
        else revcom=0;
    }
    
    // useful constants
    final IntNum zero;
    final IntNum one;
    final IntNum minusone;
    
    public variable_iface [] variables()
    {
        return (variable_iface []) variables;
    }
    
    public String toString()
    {
        String st="";
        
        for(int i=0; i<variables.length; i++)
        {
            st+=(variables[i].quant()?"A":"E")+variables[i]+"["+((intnum_bounds)variables[i]).lowerbound_big();
            st+=","+((intnum_bounds)variables[i]).upperbound_big()+"] ";
        }
        
        st+=" : "+compare[0]+" ";
        
        if(comparison==-2)
            st+="<";
        else if(comparison==-1)
            st+="<=";
        else if(comparison==0)
            st+="==";
        else if(comparison==1)
            st+=">=";
        else if(comparison==2)
            st+=">";
        else if(comparison==3)
            st+="!=";
        
        st+=" "+compare[1]+" iff "+boolvar;
        
        return st;
    }
    
    public boolean establish()
    {
        for(variable_iface temp : variables)
        {
            temp.add_wakeup(this);
        }
        
        return make_ac();
    }
    
    public boolean make_ac()
    {
        // variables are in quantification order
        //System.out.println("comparison make_ac called.");
        //System.out.println(this);
        
        // check state of the boolean.
        if(!boolvar.is_present(1))
        {
            if(boolvar.is_present(0))
            {
                // boolean set false.
                return comparisonTrue(revcom);   // assert that the reversed comparison is true.
            }
            else
            {   // empty domain (or at least does not contain 0 or 1).
                return false;
            }
        }
        else
        {
            if(!boolvar.is_present(0))
            {   // boolean set true.
                return comparisonTrue(comparison);   // assert that the comparison is true.
            }
            
            // boolvar not set.
            // Case split into boolvar: outer, mid, inner
            if(variables[0]==boolvar)
            {   // boolvar outer
                // boolvar's quantification does not matter in this case.
                int ret=checkComparisonBoolOuter(comparison);
                
                if(ret==3)
                    return false;
                else if(ret==2)
                    return true;
                else if(ret==1)
                {
                    if(!boolvar.exclude(0, this))
                        return false;
                    return comparisonTrue(comparison);
                }
                else
                {
                    assert ret==0;
                    if(!boolvar.exclude(1, this))
                        return false;
                    return comparisonTrue(revcom);
                }
            }
            else if(variables[1]==boolvar)
            {
                if(boolvar.quant())
                {
                    int res=checkComparison(comparison, compare[0], compare[1]);
                    if(res!=2)
                        return false;
                    
                    if(compare[1].quant())
                        return false;  // whatever the value of compare[0], boolvar and compare[1] will conflict.
                    
                    // now we know that the comparison is not determined.
                    // Prune compare[0] values which do not support 
                    // both values of boolvar.
                    return universalMiddleBoolean(comparison);
                }
                
                int ret=checkComparisonBoolMid(comparison);
                if(ret==3)
                    return false;
                else if(ret==2)
                    return true;
                else if(ret==1)
                {
                    if(!boolvar.exclude(0, this))
                        return false;
                    return comparisonTrue(comparison);
                }
                else
                {
                    assert ret==0;
                    if(!boolvar.exclude(1, this))
                        return false;
                    return comparisonTrue(revcom);
                }
            }
            else
            {
                assert variables[2]==boolvar;
                if(boolvar.quant())
                    return false;
                
                int ret=checkComparison(comparison, compare[0], compare[1]);  // the plain version.
                if(ret==2)
                    return true;
                else if(ret==1)
                {
                    return boolvar.exclude(0, this);
                    
                    //return comparisonTrue(comparison);  // may be able to remove this.
                }
                else
                {
                    assert ret==0;
                    return boolvar.exclude(1, this);
                    
                    //return comparisonTrue(revcom);  // may be able to remove this.
                }
            }
        }
    }
    
    // test against sqgac. Should be possible to enforce SQGAC here.
    
    // This function asserts that a comparison is true, by
    // removing the appropriate values from variable domains.
    private boolean comparisonTrue(int comp)
    {
        // the boolean variable is instantiated, so it is ignored.
        if(comp==-2)
        {   // compare[0] lessthan compare[1]
            if(compare[1].quant())
            {
                // prune the upper bound of compare[0] using the lower bound of compare[1]
                IntNum lb1=compare[1].lowerbound_big();
                if(lb1.compare(compare[0].upperbound_big())<=0)
                {
                    if(!compare[0].exclude_upper(IntNum.sub(lb1,one), this))
                        return false;
                }
            }
            else
            {
                // prune the upper bound of compare[0] using the upper bound of compare[1]
                IntNum ub1=compare[1].upperbound_big();
                if(ub1.compare(compare[0].upperbound_big())<=0)
                {
                    if(!compare[0].exclude_upper(IntNum.sub(ub1,one), this))
                        return false;
                }
            }
            
            // prune the lower bound of compare[1] using the lower bound of compare[0]
            IntNum lb0=compare[0].lowerbound_big();
            if(lb0.compare(compare[1].lowerbound_big())>=0)
            {
                if(!compare[1].exclude_lower(IntNum.add(lb0, one), this))
                    return false;
            }
            
            return true;
        }
        else if(comp==-1)
        {   // compare[0] <= compare[1]   Same as above, but no need to subtract one from the
            // new bound when pruning.
            if(compare[1].quant())
            {
                // prune the upper bound of compare[0] using the lower bound of compare[1]
                IntNum lb1=compare[1].lowerbound_big();
                if(lb1.compare(compare[0].upperbound_big())<0)
                {
                    if(!compare[0].exclude_upper(lb1, this))
                        return false;
                }
            }
            else
            {
                // prune the upper bound of compare[0] using the upper bound of compare[1]
                IntNum ub1=compare[1].upperbound_big();
                if(ub1.compare(compare[0].upperbound_big())<0)
                {
                    if(!compare[0].exclude_upper(ub1, this))
                        return false;
                }
            }
            
            // prune the lower bound of compare[1] using the lower bound of compare[0]
            IntNum lb0=compare[0].lowerbound_big();
            if(lb0.compare(compare[1].lowerbound_big())>0)
            {
                if(!compare[1].exclude_lower(lb0, this))
                    return false;
            }
            
            return true;
        }
        else if(comp==0)
        {
            // compare[0] == compare[1]
            if(compare[1].quant())
            {
                // if compare[1] is not instantiated, fail
                if(!compare[1].unit())
                {
                    return false;
                }
                else
                {
                    // set compare[0] to the same as compare[1]
                    IntNum value=compare[1].upperbound_big();
                    if(compare[0].upperbound_big().compare(value)>0)
                    {
                        if(!compare[0].exclude_upper(value, this))
                            return false;
                    }
                    
                    if(compare[0].lowerbound_big().compare(value)<0)
                    {
                        if(!compare[0].exclude_lower(value, this))
                            return false;
                    }
                    return true;
                }
            }
            else
            {
                // set the upper and lower bounds to be the same
                IntNum ub0=compare[0].upperbound_big();
                IntNum ub1=compare[1].upperbound_big();
                if(ub0.compare(ub1)>0)
                {
                    if(!compare[0].exclude_upper(ub1, this))
                        return false;
                }
                else if(ub1.compare(ub0)>0)
                {
                    if(!compare[1].exclude_upper(ub0, this))
                        return false;
                }
                
                IntNum lb0=compare[0].lowerbound_big();
                IntNum lb1=compare[1].lowerbound_big();
                if(lb0.compare(lb1)>0)
                {
                    if(!compare[1].exclude_lower(lb0, this))
                        return false;
                }
                else if(lb1.compare(lb0)>0)
                {
                    if(!compare[0].exclude_lower(lb1, this))
                        return false;
                }
                return true;
            }
        }
        else if(comp==1)
        {
            // compare[0] >= compare[1]
            if(compare[1].quant())
            {
                // prune the lower bound of compare[0] using the upper bound of compare[1]
                IntNum ub1=compare[1].upperbound_big();
                if(ub1.compare(compare[0].lowerbound_big())>0)
                {
                    if(!compare[0].exclude_lower(ub1, this))
                        return false;
                }
            }
            else
            {
                // prune the lower bound of compare[0] using the lower bound of compare[1]
                IntNum lb1=compare[1].lowerbound_big();
                if(lb1.compare(compare[0].lowerbound_big())>0)
                {
                    if(!compare[0].exclude_lower(lb1, this))
                        return false;
                }
            }
            
            // prune the upper bound of compare[1] using the upper bound of compare[0]
            IntNum ub0=compare[0].upperbound_big();
            if(ub0.compare(compare[1].upperbound_big())<0)
            {
                if(!compare[1].exclude_upper(ub0, this))
                    return false;
            }
            
            return true;
        }
        else if(comp==2)
        {
            // compare[0] > compare[1]
            if(compare[1].quant())
            {
                // prune the lower bound of compare[0] using the upper bound of compare[1]
                IntNum ub1=compare[1].upperbound_big();
                if(ub1.compare(compare[0].lowerbound_big())>=0)
                {
                    if(!compare[0].exclude_lower(IntNum.add(ub1,one), this))
                        return false;
                }
            }
            else
            {
                // prune the lower bound of compare[0] using the lower bound of compare[1]
                IntNum lb1=compare[1].lowerbound_big();
                if(lb1.compare(compare[0].lowerbound_big())>=0)
                {
                    if(!compare[0].exclude_lower(IntNum.add(lb1,one), this))
                        return false;
                }
            }
            
            // prune the upper bound of compare[1] using the upper bound of compare[0]
            IntNum ub0=compare[0].upperbound_big();
            if(ub0.compare(compare[1].upperbound_big())<=0)
            {
                if(!compare[1].exclude_upper(IntNum.sub(ub0, one), this))
                    return false;
            }
            
            return true;
        }
        else
        {
            assert comp==3;
            // compare[0] != compare[1]
            if(compare[1].quant())
            {
                // all values in compare[1] need to be removed from compare[0].
                // Assumes compare[0] and compare[1] are of the same type.
                if(compare[0] instanceof mid_domain && compare[1] instanceof mid_domain)
                {
                    mid_domain c0=(mid_domain)compare[0];
                    mid_domain c1=(mid_domain)compare[1];
                    
                    for(int i=c1.lowerbound(); i<=c1.upperbound(); i++)
                    {
                        if(c1.is_present(i) && c0.is_present(i) && !c0.exclude(i, this))
                            return false;
                    }
                }
                else
                {
                    // assume both of intnum_bounds type
                    // the only values we know for sure are in compare[1] are the bounds.
                    IntNum remove0=compare[1].upperbound_big();
                    IntNum remove1=compare[1].lowerbound_big();
                    if(compare[0].upperbound_big().compare(remove1)==0)
                    {
                        if(!compare[0].exclude_upper(IntNum.sub(remove1, one), this))
                            return false;
                    }
                    
                    if(compare[0].upperbound_big().compare(remove0)==0)
                    {
                        if(!compare[0].exclude_upper(IntNum.sub(remove0, one), this))
                            return false;
                    }
                    
                    if(compare[0].lowerbound_big().compare(remove1)==0)
                    {
                        if(!compare[0].exclude_lower(IntNum.add(remove1, one), this))
                            return false;
                    }
                    
                    if(compare[0].lowerbound_big().compare(remove0)==0)
                    {
                        if(!compare[0].exclude_lower(IntNum.add(remove0, one), this))
                            return false;
                    }
                }
                return true;
            }
            else
            {
                // standard not-equal: if either is instantiated, remove that value from the
                // other's domain.
                if(compare[0].unit())
                {
                    if(compare[1] instanceof mid_domain)
                    {
                        if(compare[1].is_present(compare[0].upperbound_big()) && 
                            !((mid_domain)compare[1]).exclude(compare[0].upperbound_big().intValue(), this))
                            return false;
                    }
                    else
                    {
                        // else do something really complicated and ugly
                        IntNum remove=compare[0].upperbound_big();
                        if(compare[1].upperbound_big().compare(remove)==0)
                        {
                            if(!compare[1].exclude_upper(IntNum.sub(remove, one), this))
                                return false;
                        }
                        
                        if(compare[1].lowerbound_big().compare(remove)==0)
                        {
                            if(!compare[1].exclude_lower(IntNum.add(remove, one), this))
                                return false;
                        }
                    }
                    return true;
                }
                
                // same as above but reversed.
                if(compare[1].unit())
                {
                    if(compare[0] instanceof mid_domain)
                    {
                        if(compare[0].is_present(compare[1].upperbound_big()) && 
                            !((mid_domain)compare[0]).exclude(compare[1].upperbound_big().intValue(), this))
                            return false;
                    }
                    else
                    {
                        // else do something really complicated and ugly
                        IntNum remove=compare[1].upperbound_big();
                        if(compare[0].upperbound_big().compare(remove)==0)
                        {
                            if(!compare[0].exclude_upper(IntNum.sub(remove, one), this))
                                return false;
                        }
                        
                        if(compare[0].lowerbound_big().compare(remove)==0)
                        {
                            if(!compare[0].exclude_lower(IntNum.add(remove, one), this))
                                return false;
                        }
                    }
                    return true;
                }
                return true;
            }
        }
    }
    
    // checks if the comparison is false/true/unknown   0/1/2
    // without reference to quantification.
    private int checkComparison(int comp, intnum_bounds c0, intnum_bounds c1)
    {
        if(comp==-2)
        {
            // c0<c1
            if(c0.upperbound_big().compare(c1.lowerbound_big())<0)  // ub(x0)<lb(x1)
                return 1;
            else if(c0.lowerbound_big().compare(c1.upperbound_big())>=0)  // lb(x0)>=ub(x1)
                return 0;
            else
                return 2;
        }
        else if(comp==-1)
        {
            // c0 <= c1
            if(c0.upperbound_big().compare(c1.lowerbound_big())<=0)  // ub(x0)<=lb(x1)
                return 1;
            else if(c0.lowerbound_big().compare(c1.upperbound_big())>0)  // lb(x0)>ub(x1)
                return 0;
            else
                return 2;
        }
        else if(comp==0)
        {
            // c0 == c1
            // if they're both unit and equal, then return 1. If they are disjoint, return 0.
            // otherwise return 2.
            if(c0.unit() && c1.unit() && c0.upperbound_big().compare(c1.upperbound_big())==0)
            {   // unit and equal
                return 1;
            }
            // now split by type.
            else if(c0 instanceof mid_domain)
            {   // not disjoint for mid_domain vars
                mid_domain md0= (mid_domain) c0;
                for(int i=md0.lowerbound(); i<=md0.upperbound(); i++)
                {
                    if(md0.is_present(i) && c1.is_present(new IntNum(i)))   // bug: creates an object unnecessarily
                        return 2;
                }
                
                // disjoint
                return 0;
            }
            else if(c1 instanceof mid_domain)
            {
                mid_domain md1= (mid_domain) c1;
                for(int i=md1.lowerbound(); i<=md1.upperbound(); i++)
                {
                    if(md1.is_present(i) && c0.is_present(new IntNum(i)))   // bug: creates an object unnecessarily
                        return 2;
                }
                
                // disjoint
                return 0;
            }
            else
            {   // both intnum_bounds, so compare bounds.
                if(c0.upperbound_big().compare(c1.lowerbound_big())<0 || c0.lowerbound_big().compare(c1.upperbound_big())>0)
                    return 0;
                else
                    return 2;
            }
        }
        else if(comp==1)
        {
            return checkComparison(-1, c1, c0);  // flip it around.
        }
        else if(comp==2)
        {
            return checkComparison(-2, c1, c0);
        }
        else
        {
            assert comp==3;
            // check notequal
            // by checking equal and flipping the result.
            int res= checkComparison(0, c0, c1);
            if(res==0)
                return 1;
            else if(res==1)
                return 0;
            else
                return 2;
        }
    }
    
    // checks if the comparison is false/true/free/both   0/1/2/3   i.e. 3=must fail.
    // with reference to quantification.
    private int checkComparisonBoolOuter(int comp)
    {
        intnum_bounds c0=compare[0];
        intnum_bounds c1=compare[1];
        
        {int ret=checkComparison(comp, c0, c1);
        if(ret==0 || ret==1)
        {
            return ret;
        }}
        // from now on,
        // assumes that the comparison is not trivially decidable (i.e. without quantification)
        
        if(!c0.quant() && !c1.quant())
            return 2;
        
        // if both c0 and c1 are universal, then fail
        
        if(c0.quant() && c1.quant())
            return 3; // fail.
        
        // if c0 is universal,
        if(c0.quant())
        {
            // c0 may contain values which force false; 
            // or force true; or neither (Return 2).
            if(comp==-2 || comp==-1)
            {   // < or <=
                if(c0.lowerbound_big().compare(c1.lowerbound_big())<(comp+2))  // <0 or <=0
                {
                    // there are values which force true.
                    // it is therefore sufficient to return true, and
                    // let the calling context deal with the consequences. 
                    return 1;
                }
                else if(c0.upperbound_big().compare(c1.upperbound_big())>(comp+1)) // >=0 or >0
                {
                    return 0;
                }
                else
                {
                    return 2; // bounds match
                }
            }
            else if(comp==1 || comp==2)
            {   // >= or >
                if(c0.lowerbound_big().compare(c1.lowerbound_big())<(comp-1))  // <0 or <=0
                {
                    // there are values which force true.
                    // it is therefore sufficient to return true, and
                    // let the calling context deal with the consequences. 
                    return 0;
                }
                else if(c0.upperbound_big().compare(c1.upperbound_big())>(comp-2)) // >=0 or >0
                {
                    return 1;
                }
                else
                {
                    return 2; // bounds match
                }
            }
            else
            {
                assert comp==0 || comp==3;
                // Look for values in c0 which are not in c1
                // Such values would force not-equal.
                if(c0.upperbound_big().compare(c1.upperbound_big())>0 ||
                    c0.lowerbound_big().compare(c1.lowerbound_big())<0)
                {
                    return (comp==0)?0:1;
                }
                // The bounds match, so now try the individual domain elements.
                if(c0 instanceof mid_domain)
                {
                    mid_domain md0=(mid_domain)c0;
                    for(int i=md0.lowerbound(); i<=md0.upperbound(); i++)
                    {
                        if(c0.is_present(i) && !c1.is_present(i))
                            return (comp==0)?0:1;
                    }
                }
                return 2;  // domains exactly match.
            }
        }
        else
        {   // c1 is universal, c0 existential.
            // c1 may contain values which force false, true or neither.
            if(comp==-2 || comp==-1)
            {   // < or <=
                if(c1.lowerbound_big().compare(c0.lowerbound_big())<(comp==-1?0:1))  // <0 or <=0
                {   // c1's lowerbound is less than/le all values in c0.
                    return 0;
                }
                else if(c1.upperbound_big().compare(c0.upperbound_big())>(comp==-2?0:-1)) // >=0 or >0
                {   // c1's upperbound is greater than/ge all values in c0
                    return 1;
                }
                else
                {
                    return 2; // bounds match
                }
            }
            else if(comp==1 || comp==2)
            {   // >= or >
                if(c1.lowerbound_big().compare(c0.lowerbound_big())<(comp==2?0:1))  // <0 or <=0
                {
                    // there are values which force true.
                    // it is therefore sufficient to return true, and
                    // let the calling context deal with the consequences. 
                    return 1;
                }
                else if(c1.upperbound_big().compare(c0.upperbound_big())>(comp==1?0:-1)) // >=0 or >0
                {
                    return 0;
                }
                else
                {
                    return 2; // bounds match
                }
            }
            else
            {
                assert comp==0 || comp==3;
                // Look for values in c1 which are not in c0
                // Such values would force not-equal.
                if(c1.upperbound_big().compare(c0.upperbound_big())>0 ||
                    c1.lowerbound_big().compare(c0.lowerbound_big())<0)
                {
                    return (comp==0)?0:1;
                }
                // The bounds match, so now try the induhvidual domain elements.
                if(c1 instanceof mid_domain)
                {
                    mid_domain md1=(mid_domain)c1;
                    for(int i=md1.lowerbound(); i<=md1.upperbound(); i++)
                    {
                        if(c1.is_present(i) && !c0.is_present(i))
                            return (comp==0)?0:1;
                    }
                }
                return 2;  // domains exactly match.
            }
        }
    }
    
    private int checkComparisonBoolMid(int comp)
    {
        // similar to above, but the quantification of c0 is not relevant unless both c0 and c1 are universal.
        intnum_bounds c0=compare[0];
        intnum_bounds c1=compare[1];
        
        {int ret=checkComparison(comp, c0, c1);
        if(ret==0 || ret==1)
        {
            return ret;
        }}
        // from now on,
        // assumes that the comparison is not trivially decidable (i.e. without quantification)
        
        if(!c0.quant() && !c1.quant())
            return 2;
        
        // if both c0 and c1 are universal, then fail
        
        if(c0.quant() && c1.quant())
            return 3; // fail.
        
        // if c0 is universal, this is equivalent to the existential-existential case.
        if(c0.quant())
        {
            return 2;
        }
        else
        {   // c1 is universal, c0 existential.
            // c1 may contain values which force false, true or neither.
            if(comp==-2 || comp==-1)
            {   // < or <=
                if(c1.lowerbound_big().compare(c0.lowerbound_big())<(comp==-1?0:1))  // <0 or <=0
                {   // c1's lowerbound is less than/le all values in c0.
                    return 0;
                }
                else if(c1.upperbound_big().compare(c0.upperbound_big())>(comp==-2?0:-1)) // >=0 or >0
                {   // c1's upperbound is greater than/ge all values in c0
                    return 1;
                }
                else
                {
                    return 2; // bounds match
                }
            }
            else if(comp==1 || comp==2)
            {   // >= or >
                if(c1.lowerbound_big().compare(c0.lowerbound_big())<(comp==2?0:1))  // <0 or <=0
                {
                    // there are values which force true.
                    // it is therefore sufficient to return true, and
                    // let the calling context deal with the consequences. 
                    return 1;
                }
                else if(c1.upperbound_big().compare(c0.upperbound_big())>(comp==1?0:-1)) // >=0 or >0
                {
                    return 0;
                }
                else
                {
                    return 2; // bounds match
                }
            }
            else
            {
                assert comp==0 || comp==3;
                // Look for values in c1 which are not in c0
                // Such values would force not-equal.
                if(c1.upperbound_big().compare(c0.upperbound_big())>0 ||
                    c1.lowerbound_big().compare(c0.lowerbound_big())<0)
                {
                    return (comp==0)?0:1;
                }
                // The bounds match, so now try the induhvidual domain elements.
                if(c1 instanceof mid_domain)
                {
                    mid_domain md1=(mid_domain)c1;
                    for(int i=md1.lowerbound(); i<=md1.upperbound(); i++)
                    {
                        if(c1.is_present(i) && !c0.is_present(i))
                            return (comp==0)?0:1;
                    }
                }
                return 2;  // domains exactly match.
            }
        }
    }
    
    private boolean universalMiddleBoolean(int comp)
    {
        // for the case where the boolean is in the middle and is universal,
        // the outer variable sometimes needs to be pruned. 
        // Q_1 x A b E y : x comp y iff b
        // prune x such that each value of x has values in y which can produce both
        // satisfied and unsatisfied comparison, to match the two values of b.
        
        intnum_bounds c0=compare[0];
        intnum_bounds c1=compare[1];
        
        if(comp==-2 || comp==1)  // inverse operations can be processed with the same rule
        {   // ub(x)=ub(y)  and  lb(x)=lb(y)+1
            if(c0.upperbound_big().compare(c1.upperbound_big())>=0)
            {
                if(!c0.exclude_upper(IntNum.sub(c1.upperbound_big(), one), this))
                    return false;
            }
            
            if(c0.lowerbound_big().compare(c1.lowerbound_big())<0)
            {
                if(!c0.exclude_lower(c1.lowerbound_big(), this))
                    return false;
            }
            return true;
        }
        else if(comp==-1 || comp==2)
        {   // ub(x)=ub(y)-1  and  lb(x)=lb(y)
            if(c0.upperbound_big().compare(c1.upperbound_big())>0)
            {
                if(!c0.exclude_upper(c1.upperbound_big(), this))
                    return false;
            }
            
            if(c0.lowerbound_big().compare(c1.lowerbound_big())<=0)
            {
                if(!c0.exclude_lower(IntNum.add(c1.lowerbound_big(), one), this))
                    return false;
            }
            return true;
        }
        else
        {   // Dx = Dx intersection Dy
            // Chop the bounds, then punch holes if appropriate
            assert comp==0 || comp==3;
            if(c0.upperbound_big().compare(c1.upperbound_big())>0)
            {
                if(!c0.exclude_upper(c1.upperbound_big(), this))
                    return false;
            }
            
            if(c0.lowerbound_big().compare(c1.lowerbound_big())<0)
            {
                if(!c0.exclude_lower(c1.lowerbound_big(), this))
                    return false;
            }
            
            // Can only punch holes if both variables are mid_domains.
            if(c0 instanceof mid_domain && c1 instanceof mid_domain)
            {
                mid_domain md0=(mid_domain) c0;
                mid_domain md1=(mid_domain) c1;
                for(int i=md1.lowerbound(); i<=md1.upperbound(); i++)
                {
                    if(!md1.is_present(i) && md0.is_present(i) && !md0.exclude(i, this))
                        return false;
                }
            }
            return true;
        }
    }
    
    public boolean entailed()
    {
        // if all vars unit
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].unit())
            {
                return false;
            }
        }
        return true;
    }
}


// this is the most general of the testing routines.
class comparison_constraint_test
{
    public static void main(String[] args)
    {
        comparison_constraint_test o1=new comparison_constraint_test();
        o1.do_tests();
    }
    
    void do_tests()
    {
        r=new Random(12345);
        sw=new stopwatch("GMT");
        
        for(int i=0; i<100000; i++)
        {
            test_random_prob();
            System.out.println("Done test "+(i+1));
        }
    }
    
    Random r; // random number generator.
    stopwatch sw;
    
    void test_random_prob()
    {
        // comparison
        int comp=(int) (r.nextFloat()*6);
        // 0..5
        comp=comp-2;
        
        // twice as likely to test 0 as any other because of rounding
        final int numvars=3;
        int indexforbool=(int) (r.nextFloat()*numvars);  // 0,1,2
        
        mid_domain [] vars_sqgac= new mid_domain[numvars];
        mid_domain [] vars_other= new mid_domain[numvars];
        
        qcsp prob_sqgac = new qcsp();
        qcsp prob_other = new qcsp();
        
        for(int i=0; i<numvars; i++)
        {
            if(indexforbool==i)
            {
                if(r.nextFloat()>2.0)
                {
                    vars_other[i]=new universal(2, prob_other, "bx"+(i+1));
                    vars_sqgac[i]=new universal(2, prob_sqgac, "bx"+(i+1));
                }
                else
                {
                    vars_other[i]=new existential(2, prob_other, "bx"+(i+1));
                    vars_sqgac[i]=new existential(2, prob_sqgac, "bx"+(i+1));
                }
            }
            else
            {
                if(r.nextFloat()>2.0)
                {
                    // universal
                    double temp=r.nextFloat();
                    int ub, lb;
                    if(temp<0.2)
                    {   // positive
                        ub=12; lb=3;
                    }
                    else if(temp<0.4)
                    {   // includes 0.
                        ub=9; lb=0;
                    }
                    else if(temp<0.6)
                    {   // spans 0
                        ub=6; lb=-3;
                    }
                    else if(temp<0.8)
                    {   // includes 0 negative
                        ub=0; lb=-9;
                    }
                    else
                    {
                        ub=-3; lb=-12;
                    }
                    vars_other[i]=new universal(lb, ub, prob_other, "x"+(i+1));
                    vars_sqgac[i]=new universal(lb, ub, prob_sqgac, "x"+(i+1));
                }
                else
                {
                    // existential
                    double temp=r.nextFloat();
                    int ub, lb;
                    if(temp<0.2)
                    {   // positive
                        ub=12; lb=3;
                    }
                    else if(temp<0.4)
                    {   // includes 0.
                        ub=9; lb=0;
                    }
                    else if(temp<0.6)
                    {   // spans 0
                        ub=6; lb=-3;
                    }
                    else if(temp<0.8)
                    {   // includes 0 negative
                        ub=0; lb=-9;
                    }
                    else
                    {
                        ub=-3; lb=-12;
                    }
                    vars_other[i]=new existential(lb, ub, prob_other, "x"+(i+1));
                    vars_sqgac[i]=new existential(lb, ub, prob_sqgac, "x"+(i+1));
                }
            }
        }
        
        mid_domain[] compare=new mid_domain[2];
        compare[0]=(indexforbool==0?vars_other[1]:vars_other[0]);
        compare[1]=(indexforbool==2?vars_other[1]:vars_other[2]);
        
        constraint c1= new e_comparison(compare, (mid_domain) vars_other[indexforbool], 
            comp, prob_other);
        
        predicate_wrapper pred=new comparison_predicate(comp, indexforbool);
        constraint c2= new sqgac(vars_sqgac, prob_sqgac, pred);
        
        // start the testing
        
        // first check equivalence of the first pass
        
        assert same_domains(prob_other, prob_sqgac) : "something wrong in constructing the problems";
        
        boolean flag1=prob_other.establish();
        boolean flag2=prob_sqgac.establish();
        
        assert flag2==flag1 : "Found "+flag2+" for sqgac and "+flag1+" for other";
        
        if(!flag2)
        {
            return;
        }
        
        flag1=prob_other.propagate();
        flag2=prob_sqgac.propagate();
        
        assert flag2==flag1 : "Found "+flag2+" for sqgac and "+flag1+" for other";
        
        if(flag2 && !same_domains(prob_other, prob_sqgac))   // if not false, compare doms.
        {
            System.out.println("different domains");
            System.out.println("other:");
            prob_other.printdomains();
            System.out.println("SQGAC:");
            prob_sqgac.printdomains();
            assert false;
        }
        
        if(!flag2)
        {
            return;
        }
        
        prob_other.printdomains();
        for(int descents=0; descents<5; descents++)
        {
            System.out.println("New descent.");
            // now make some random removals until each variable is unit.
            int numassigned=0;
            while(numassigned<vars_other.length)
            {
                // first check that an assignment is possible
                boolean assignmentposs=false;
                for(int i=0; i<vars_other.length; i++)
                {
                    if(!vars_other[i].unit())
                    {
                        assignmentposs=true;
                        break;
                    }
                }
                
                if(!assignmentposs)
                    break;
                
                System.out.println("Assignment possible.");
                
                // pick an assignment to make
                int var=(int)(3*r.nextFloat());
                
                boolean outer=true;
                for(int i=var-1; i>=0; i--) 
                    if((vars_other[var].quant() && !vars_other[i].quant() && !vars_other[i].unit()) ||
                       (!vars_other[var].quant() && vars_other[i].quant() && !vars_other[i].unit())) outer=false;
                
                while(vars_other[var].unit() || !outer)
                {
                    var=(int)(numvars*r.nextFloat());
                    outer=true;
                    for(int i=var-1; i>=0; i--) 
                        if((vars_sqgac[var].quant() && !vars_other[i].quant() && !vars_other[i].unit()) ||
                            (!vars_sqgac[var].quant() && vars_other[i].quant() && !vars_other[i].unit())) outer=false;
                }
                
                int val=(int) (r.nextFloat()*40-20);
                while(!vars_other[var].is_present(val) || !vars_sqgac[var].is_present(val))
                {
                    val=(int) (r.nextFloat()*40-20);
                }
                
                System.out.println("Test harness: Assigning variable "+prob_sqgac.variables.get(var)+" value "+val);
                
                numassigned++;
                prob_other.add_backtrack_level();
                prob_sqgac.add_backtrack_level();
                
                ((mid_domain)prob_other.variables.get(var)).instantiate(val);
                ((mid_domain)prob_sqgac.variables.get(var)).instantiate(val);
                
                for(int i=0; i<numvars; i++)
                {
                    assert !vars_other[i].empty();
                    assert !vars_sqgac[i].empty();
                }
                
                flag1=prob_other.propagate();
                flag2=prob_sqgac.propagate();
                
                if(flag2 && !flag1)
                {
                    System.out.println("other:");
                    prob_other.printdomains();
                    System.out.println("sqgac:");
                    prob_sqgac.printdomains();
                    
                    assert false : "found "+flag1+" for other_constraint and "+flag2+" for sqgac";
                }
                
                if(flag2 && !same_domains(prob_other, prob_sqgac))   // if not false, compare doms.
                {
                    System.out.println(c1);
                    System.out.println("different domains");
                    System.out.println("other:");
                    prob_other.printdomains();
                    System.out.println("sqgac:");
                    prob_sqgac.printdomains();
                    
                    assert false;
                }
                
                if(!flag1 || !flag2)
                    break;  // no point making more assignments.
            }
            
            // backtrack before starting the next descent.
            for(int i=0; i<numassigned; i++)
            {
                prob_other.backtrack();
                prob_sqgac.backtrack();
            }
        }
    }
    
    boolean same_domains(qcsp prob1, qcsp prob2)
    {
        if(prob1.variables.size()!=prob2.variables.size())
            return false;
        
        for(int i=0; i<prob1.variables.size(); i++)
        {
            mid_domain var1 = (mid_domain)prob1.variables.get(i);
            mid_domain var2 = (mid_domain)prob2.variables.get(i);
            
            if(var1.domsize()!=var2.domsize())
                return false;
            
            if(var1.lowerbound()!=var2.lowerbound())
                return false;
            
            if(var1.upperbound()!=var2.upperbound())
                return false;
            
            for(int j=var1.lowerbound(); j<=var1.upperbound(); j++)
            {
                if(var1.is_present(j)!=var2.is_present(j))
                    return false;
            }
        }
        return true;
    }
}

class comparison_predicate implements predicate_wrapper
{
    comparison_predicate(int comparison, int boolvar)
    {
        this.comparison=comparison;
        this.boolvar=boolvar;
    }
    
    final int comparison, boolvar;
    
    public boolean predicate(tuple tau)
    {
        int val0=(boolvar==0?tau.vals[1]:tau.vals[0]);
        int val1=(boolvar!=2?tau.vals[2]:tau.vals[1]);
        if(tau.vals[boolvar]==0)
        {
            if(comparison==-2)
                return val0>=val1;
            else if(comparison==-1)
                return val0>val1;
            else if(comparison==0)
                return val0!=val1;
            else if(comparison==1)
                return val0<val1;
            else if(comparison==2)
                return val0<=val1;
            else
                return val0==val1;
        }
        else
        {
            assert tau.vals[boolvar]==1;
            if(comparison==-2)
                return val0<val1;
            else if(comparison==-1)
                return val0<=val1;
            else if(comparison==0)
                return val0==val1;
            else if(comparison==1)
                return val0>=val1;
            else if(comparison==2)
                return val0>val1;
            else
                return val0!=val1;
        }
    }
}

