package queso.constraints;

import queso.core.*;

public final class e_comparison extends constraint implements make_ac
{
    // breaks the usual assumption of having all variables in one array.
    final mid_domain[] compare;
    final mid_domain boolvar;
    final mid_domain[] variables;
    
    final int comparison;  // -2 for <, -1 for <=, 0 for ==, 1 for >=, 2 for >, 3 for !=
    final int revcom;  // the negated comparison of the above.
    
    public e_comparison(mid_domain [] compare, mid_domain boolvar, int comparison, qcsp problem)
    {
        super(problem);
        this.compare=compare;
        this.boolvar=boolvar;
        this.comparison=comparison;
        
        check_variables(compare);
        variables=new mid_domain[3];
        if(boolvar.id()>compare[1].id())
        {
            variables[2]=(mid_domain)boolvar;
            variables[0]=(mid_domain)compare[0];
            variables[1]=(mid_domain)compare[1];
        }
        else if(boolvar.id()>compare[0].id())
        {
            variables[1]=(mid_domain)boolvar;
            variables[0]=(mid_domain)compare[0];
            variables[2]=(mid_domain)compare[1];
        }
        else
        {
            variables[0]=(mid_domain)boolvar;
            variables[1]=(mid_domain)compare[0];
            variables[2]=(mid_domain)compare[1];
        }
        
        check_variables(variables);
        
        assert compare.length==2;
        assert comparison>=-2 && comparison<=3;
        assert !variables[0].quant() && !variables[1].quant() && !variables[2].quant();
        
        if(comparison==-2) revcom=1;
        else if(comparison==-1) revcom=2;
        else if(comparison==0) revcom=3;
        else if(comparison==1) revcom=-2;
        else if(comparison==2) revcom=-1;
        else revcom=0;
    }
    
    public variable_iface [] variables()
    {
        return (variable_iface []) variables;
    }
    
    public String toString()
    {
        String st="";
        
        for(int i=0; i<variables.length; i++)
        {
            st+=(variables[i].quant()?"A":"E")+variables[i]+"["+((mid_domain)variables[i]).lowerbound();
            st+=","+((mid_domain)variables[i]).upperbound()+"] ";
        }
        
        st+=" : "+compare[0]+" ";
        
        if(comparison==-2)
            st+="<";
        else if(comparison==-1)
            st+="<=";
        else if(comparison==0)
            st+="==";
        else if(comparison==1)
            st+=">=";
        else if(comparison==2)
            st+=">";
        else if(comparison==3)
            st+="!=";
        
        st+=" "+compare[1]+" iff "+boolvar;
        
        return st;
    }
    
    public boolean establish()
    {
        for(variable_iface temp : variables)
        {
            temp.add_wakeup(this);
        }
        
        return make_ac();
    }
    
    public boolean make_ac()
    {
        // variables are in quantification order
        //System.out.println("comparison make_ac called.");
        //System.out.println(this);
        
        // check state of the boolean.
        if(!boolvar.is_present(1))
        {
            if(boolvar.is_present(0))
            {
                // boolean set false.
                return comparisonTrue(revcom);   // assert that the reversed comparison is true.
            }
            else
            {   // empty domain (or at least does not contain 0 or 1).
                return false;
            }
        }
        else
        {
            if(!boolvar.is_present(0))
            {   // boolean set true.
                return comparisonTrue(comparison);   // assert that the comparison is true.
            }
            else
            {
                // boolean contains both true and false.
                int i=checkComparison(comparison, compare[0], compare[1]);
                if(i==0)
                {
                    return boolvar.exclude(1, this);
                }
                else if(i==1)
                {
                    return boolvar.exclude(0, this);
                }
                return true;
            }
        }
    }
    
    // test against sqgac. Should be possible to enforce SQGAC here.
    
    // This function asserts that a comparison is true, by
    // removing the appropriate values from variable domains.
    private boolean comparisonTrue(int comp)
    {
        // the boolean variable is instantiated, so it is ignored.
        if(comp==-2)
        {   // compare[0] lessthan compare[1]
            
            // prune the upper bound of compare[0] using the upper bound of compare[1]
            int ub1=compare[1].upperbound();
            if(ub1<=compare[0].upperbound())
            {
                if(!compare[0].exclude_upper(ub1-1, this))
                    return false;
            }
            
            // prune the lower bound of compare[1] using the lower bound of compare[0]
            int lb0=compare[0].lowerbound();
            if(lb0>=compare[1].lowerbound())
            {
                if(!compare[1].exclude_lower(lb0+1, this))
                    return false;
            }
            
            return true;
        }
        else if(comp==-1)
        {   // compare[0] <= compare[1]   Same as above, but no need to subtract one from the
            // new bound when pruning.
            
            int ub1=compare[1].upperbound();
            if(ub1<compare[0].upperbound())
            {
                if(!compare[0].exclude_upper(ub1, this))
                    return false;
            }
            
            // prune the lower bound of compare[1] using the lower bound of compare[0]
            int lb0=compare[0].lowerbound();
            if(lb0>compare[1].lowerbound())
            {
                if(!compare[1].exclude_lower(lb0, this))
                    return false;
            }
            
            return true;
        }
        else if(comp==0)
        {
            // compare[0] == compare[1]
            
            // set the upper and lower bounds to be the same
            int ub0=compare[0].upperbound();
            int ub1=compare[1].upperbound();
            if(ub0>ub1)
            {
                if(!compare[0].exclude_upper(ub1, this))
                    return false;
            }
            else if(ub1>ub0)
            {
                if(!compare[1].exclude_upper(ub0, this))
                    return false;
            }
            
            int lb0=compare[0].lowerbound();
            int lb1=compare[1].lowerbound();
            if(lb0>lb1)
            {
                if(!compare[1].exclude_lower(lb0, this))
                    return false;
            }
            else if(lb1>lb0)
            {
                if(!compare[0].exclude_lower(lb1, this))
                    return false;
            }
            return true;
            
        }
        else if(comp==1)
        {
            // compare[0] >= compare[1]
            
            int lb1=compare[1].lowerbound();
            if(lb1>compare[0].lowerbound())
            {
                if(!compare[0].exclude_lower(lb1, this))
                    return false;
            }
            
            // prune the lower bound of compare[1] using the lower bound of compare[0]
            int ub0=compare[0].upperbound();
            if(ub0<compare[1].upperbound())
            {
                if(!compare[1].exclude_upper(ub0, this))
                    return false;
            }
            
            return true;
        }
        else if(comp==2)
        {
            // compare[0] > compare[1]
            
            int lb1=compare[1].lowerbound();
            if(lb1>=compare[0].lowerbound())
            {
                if(!compare[0].exclude_lower(lb1+1, this))
                    return false;
            }
            
            int ub0=compare[0].upperbound();
            if(ub0<=compare[1].upperbound())
            {
                if(!compare[1].exclude_upper(ub0-1, this))
                    return false;
            }
            
            return true;
        }
        else
        {
            assert comp==3;
            // compare[0] != compare[1]
            
                // standard not-equal: if either is instantiated, remove that value from the
                // other's domain.
            if(compare[0].unit())
            {
                if(compare[1].is_present(compare[0].lowerbound()))
                {
                    return compare[1].exclude(compare[0].lowerbound(), this);
                }
                
                return true;
            }
            
            // same as above but reversed.
            if(compare[1].unit())
            {
                if(compare[0].is_present(compare[1].lowerbound()))
                {
                    return compare[0].exclude(compare[1].lowerbound(), this);
                }
            }
            
            return true;
        }
    }
    
    // checks if the comparison is false/true/unknown   0/1/2
    // without reference to quantification.
    private int checkComparison(int comp, mid_domain c0, mid_domain c1)
    {
        if(comp==-2)
        {
            // c0<c1
            if(c0.upperbound()<c1.lowerbound())  // ub(x0)<lb(x1)
                return 1;
            else if(c0.lowerbound()>=c1.upperbound())  // lb(x0)>=ub(x1)
                return 0;
            else
                return 2;
        }
        else if(comp==-1)
        {
            // c0 <= c1
            if(c0.upperbound()<=c1.lowerbound())  // ub(x0)<=lb(x1)
                return 1;
            else if(c0.lowerbound()>c1.upperbound())  // lb(x0)>ub(x1)
                return 0;
            else
                return 2;
        }
        else if(comp==0)
        {
            // c0 == c1
            // if they're both unit and equal, then return 1. If they are disjoint, return 0.
            // otherwise return 2.
            if(c0.unit() && c1.unit() && c0.upperbound()==c1.upperbound())
            {   // unit and equal
                return 1;
            }
            // now split by type.
            
            // not disjoint for mid_domain vars
            for(int i=c0.lowerbound(); i<=c0.upperbound(); i++)
            {
                if(c0.is_present(i) && c1.is_present(i))
                    return 2;
            }
            
            // disjoint
            return 0;
        }
        else if(comp==1)
        {
            return checkComparison(-1, c1, c0);  // flip it around.
        }
        else if(comp==2)
        {
            return checkComparison(-2, c1, c0);
        }
        else
        {
            assert comp==3;
            // check notequal
            // by checking equal and flipping the result.
            int res= checkComparison(0, c0, c1);
            if(res==0)
                return 1;
            else if(res==1)
                return 0;
            else
                return 2;
        }
    }
    
    public boolean entailed()
    {
        // if all vars unit
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].unit())
            {
                return false;
            }
        }
        return true;
    }
}
