///////////////////////////////////////////////////////////////////////////////
// Predicate instantiation of wqgac_schema

package queso.constraints;

import queso.core.*;
import java.util.*;

public class gac_schema_predicate extends gac_schema implements negatable
{
    // takes a function (wrapped in an object) which is a blackbox. 
    // In go tuples, out come booleans, to represent whether the tuple satisfies the predicate.
    
    // This should not be public; currently used to negate the constraint.
    public final predicate_wrapper pred;
    
    // the returns for the function nextTuple
    // not thread-safe.
    static tuple returnsigma;
    static int returnkprime;
    
    public gac_schema_predicate(mid_domain [] vars, qcsp prob, predicate_wrapper pred) // <pa, goodlistwrapper>
    {
        super(vars, prob);
        this.pred=pred;
    }
    
    public void make_negated_constraint(puremonitor pm1, int v1ind)
    {
        predicate_wrapper p2=new negated_predicate(pred);
        puremonitor [] vars=new puremonitor[variables.length];
        
        for(int j=0; j<variables.length; j++)
        {
            // doesn't matter that the original has holes in the domain, because ????
            if(j==v1ind) vars[j]=pm1;
            else
            {
                vars[j]=new puremonitor(variables[j].lowerbound(), variables[j].upperbound(), problem, "pm-c"+this.id+"-"+variables[j]);
                // make the dummy linkup.
                mid_domain[] dlvars={variables[j], vars[j]};
                constraint dl1=new dummy_linkup(dlvars, problem);
                problem.purecons(dl1);
            }
        }
        gac_schema_predicate c2=new gac_schema_predicate_nofail(vars, problem, p2);
        problem.purecons(c2);
    }
    
    void nextTuple(pa partial, tuple old, int k)
    {
        // intended to return the lex-smallest valid tuple sigma >lo old, and matching partial, and sigma[0..k]!=old[0..k]
        // and should match domains
        // warning: k is the index from 0 here. In the Bessiere and Regin paper it is an index from 1.
        
        //System.out.println("nextTuple called with partial "+partial+" and old tuple "+old+"and k="+k);
        
        int [] tuplearray = new int[variables.length];
        
        // copy
        for(int i=0; i<variables.length; i++)
        {
            tuplearray[i] = old.vals[i];
        }
        
        // make sure the tuple passed in satisfies the pa.
        //assert satisfies(old, partial); not true.
        // all this new stuff does not fix the problem with test 14.
        // impose partial and the current domains until the most significant changed digit less than k.
        
        zerorest(partial, tuplearray, k+1); // this is a bit conservative.
        
        // naive version: impose partial.
        int leastgreaterthan=tuplearray.length;  // leftmost greaterthan symbol.
        int leastlessthan=tuplearray.length;  // leftmost lessthan symbol.
        for(int i=0; i<partial.vars.length; i++)
        {
            if(tuplearray[partial.vars[i]]!=partial.vals[i])
            {
                if(tuplearray[partial.vars[i]]<partial.vals[i])
                {
                    tuplearray[partial.vars[i]]=partial.vals[i];
                    
                    if(partial.vars[i]<leastgreaterthan) leastgreaterthan=partial.vars[i];
                }
                else
                {
                    tuplearray[partial.vars[i]]=partial.vals[i];
                    if(partial.vars[i]<leastlessthan) leastlessthan=partial.vars[i];
                }
            }
        }
        if(leastgreaterthan<leastlessthan)
        {
            zerorest(partial, tuplearray, leastgreaterthan+1);
            leastlessthan=leastgreaterthan+1;  // potentially changed.
        }
        // naive: impose current domains
        // where a value is not in the domain, put in the next greater value and zero the rest.
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].is_present(tuplearray[i]))
            {
                //assert notin(tuplearray[i], partial.vars);  // the value is not part of the pa
                if(i>k)
                {
                    tuplearray[i]=variables[i].lowerbound(); // this should never actually happen.
                    assert false;
                }
                else if(i<leastgreaterthan)
                {
                    boolean found=false;
                    for(int j=tuplearray[i]+1; j<=variables[i].upperbound(); j++)
                    {
                        if(variables[i].is_present(j))
                        {
                            tuplearray[i]=j;
                            leastgreaterthan=i;
                            found=true;
                            break;
                        }
                    }
                    if(!found)
                    {
                        // can't set it higher so set it lowest, and
                        // some symbol to the left will have to be set higher
                        tuplearray[i]=variables[i].lowerbound();
                        if(i<leastlessthan) leastlessthan=i;
                    }
                }
                else
                {
                    assert i!=leastgreaterthan;
                    // there is a greater symbol to the left, so
                    // just set this to its lowest value.
                    if(tuplearray[i]<variables[i].lowerbound())
                    {
                        if(i<leastgreaterthan) leastgreaterthan=i;
                    }
                    else
                    {
                        if(i<leastlessthan) leastlessthan=i;
                    }
                    tuplearray[i]=variables[i].lowerbound();
                }
            }
        }
        
        // now we just know that leastgreaterthan
        // and leastlessthan point to the appropriate places.
        
        if(leastgreaterthan<=k && leastlessthan>leastgreaterthan)
        {   // can just zero the rest and return.
            zerorest(partial, tuplearray, leastgreaterthan+1);
            returnsigma=new tuple(tuplearray);
            returnkprime=leastgreaterthan;
            assert valid(returnsigma);
            return;
        }
        
        
        if(leastlessthan<k)
        {
            k=leastlessthan;
        }
        
        // now we need to start with k and count up.
        boolean flag=countup(partial, tuplearray, k);
        if(!flag)
        {
            returnsigma=null;
            returnkprime=0;
            return;
        }
        if(flag)
        {
            int kprime=0;
            for(; kprime<variables.length; kprime++)
            {
                if(tuplearray[kprime]!=old.vals[kprime])
                {
                    break;
                }
            }
            returnsigma=new tuple(tuplearray);
            returnkprime=kprime;
            assert valid(returnsigma);
            return;
        }
        
        int partialpointer=0;
        
        for(int i=0; i<=k; i++)
        {
            while(partialpointer<partial.vars.length && partial.vars[partialpointer]<i)
                partialpointer++;
            
            // if the partial assignment changes the tuple:
            if(partialpointer<partial.vars.length && partial.vars[partialpointer]==i)
            {
                if(partial.vals[partialpointer]>tuplearray[i])
                {
                    tuplearray[i]=partial.vals[partialpointer];
                    zerorest(partial, tuplearray, i+1);
                    returnsigma=new tuple(tuplearray);
                    returnkprime=i;
                    assert valid(returnsigma);
                    return;
                }
                else if(partial.vals[partialpointer]<tuplearray[i])
                {
                    tuplearray[i]=partial.vals[partialpointer];
                    // slot i is less, so slots 0-- i-1 must be lex greater than the old tuple.
                    if(!countup(partial, tuplearray, i-1))
                    {
                        returnsigma=null;
                        returnkprime=0;
                        return;
                    }
                    else
                    {
                        int kprime=0;
                        for(; kprime<variables.length; kprime++)
                        {
                            if(tuplearray[kprime]!=old.vals[kprime])
                            {
                                break;
                            }
                        }
                        returnsigma=new tuple(tuplearray);
                        returnkprime=kprime;
                        assert valid(returnsigma);
                        return;
                    }
                }
            }
            
            // if the current value is not present in the domain.
            if(!variables[i].is_present(tuplearray[i]))
            {
                // then count up from the current value, 
                // since this prefix must be greater than the old.
                
                if(!countup(partial, tuplearray, i))
                {
                    returnsigma=null;
                    returnkprime=0;
                    return;
                }
                else
                {
                    int kprime=0;
                    for(; kprime<variables.length; kprime++)
                    {
                        if(tuplearray[kprime]!=old.vals[kprime])
                        {
                            break;
                        }
                    }
                    returnsigma=new tuple(tuplearray);
                    returnkprime=kprime;
                    assert valid(returnsigma);
                    return;
                }
            }
        }
        
        // neither the partial assignment nor the current domains caused the prefix 0..k to
        // be changed. Therefore count up to increase 0..k.
        
        // may need to set the partial here (no because zerorest now sets partial as it goes).
        
        if(!countup(partial, tuplearray, k))
        {
            returnsigma=null;
            returnkprime=0;
            return;
        }
        else
        {
            int kprime=0;
            for(; kprime<variables.length; kprime++)
            {
                if(tuplearray[kprime]!=old.vals[kprime])
                {
                    break;
                }
            }
            returnsigma=new tuple(tuplearray);
            returnkprime=kprime;
            assert valid(returnsigma);
            return;
        }
    }
    
    // naive version of countup
    // does not solve the test 14 problem,  but it's much neater than
    // the other version anyway.
    boolean countup(pa partial, int [] tuplearray, int k)
    {
        assert tuples.valid(tuplearray, variables);
        boolean iterate=true;
        
        while(iterate)
        {
            iterate=false;
            // increment k until it is not part of partial.
            for(int i=partial.vars.length-1; i>=0; i--)
            {
                if(partial.vars[i]==k)
                    k--;
            }
            
            while(k>=0 && tuplearray[k]==variables[k].upperbound())
            {   // symbol at position k cannot be increased.
                k--;
                iterate=true;
            }
            
            if(k<0) return false;
        }
        
        // increment the symbol at position k
        for(int val=tuplearray[k]+1; val<=variables[k].upperbound(); val++)
        {
            if(variables[k].is_present(val))
            {
                tuplearray[k]=val;
                break;
            }
        }
        zerorest(partial, tuplearray, k+1);
        return true;
        // should really return the first changed symbol for use in nextTuple.
    }
    
    /*boolean countup(pa partial, int [] tuplearray, int k)
    {
        // start counting up at position k
        // if k is part of partial, then we need to find some other variable to start counting on.
        // can the tuple passed in be invalid against the domains?? if so, don't we have to fix that
        // first? i.e. iterate from 0..tup.length, find first invalid value, set it to next valid
        // value, zero the rest, and compare the change point to k (because if it is the same
        // or higher, can return now).
        
        int index=k;
        int partialpointer=partial.vars.length-1;
        for(; index>=0; index--)
        {
            while(partialpointer>=0 && partial.vars[partialpointer]>index)
            {
                partialpointer--;
            }
            
            if(partialpointer<0 || partial.vars[partialpointer]!=index)
            {
                break;
            }
        }
        
        // if all the variables 0..k are in the partial assignment, we can't meet the requirement that
        // sigma[0..k]!=old[0..k] while honouring partial.
        if(index==-1)
        {
            //System.out.println("countup failed to find another tuple 1");
            return false;
        }
        
        partialpointer=partial.vars.length-1;
        for(; index>=0; index--)
        {
            while(partialpointer>=0 && partial.vars[partialpointer]>index)
            {
                partialpointer--;
            }
            
            if(partialpointer<0 || partial.vars[partialpointer]!=index)
            {
                // set the value to the next higher.
                boolean found=false;
                
                for(int j=tuplearray[index]+1; j<=variables[index].upperbound(); j++)
                {
                    if(variables[index].is_present(j))
                    {
                        tuplearray[index]=j;
                        found=true;
                        break;
                    }
                }
                
                if(found)
                {
                    break;
                }
            }
        }
        
        if(index==-1)
        {
            //System.out.println("countup failed to find another tuple 2");
            return false;
        }
        
        // so now we have adjusted the appropriate value in the prefix, 
        // we need to zero (set to least value) all the values after that, honouring partial
        zerorest(partial, tuplearray, index+1);
        
        return true;
    }*/
    
    //naive version of zerorest. Does not solve test 14 problem.
    void zerorest(pa partial, int [] tuplearray, int index)
    {
        for(; index<variables.length; index++)
        {
            boolean found=false;
            for(int i=0; i<partial.vars.length; i++)
            {
                if(partial.vars[i]==index)
                {
                    found=true;
                    tuplearray[index]=partial.vals[i];
                    break;
                }
            }
            if(!found)
            {
                tuplearray[index]=variables[index].lowerbound();
            }
        }
    }
    
    /*void zerorest(pa partial, int [] tuplearray, int index)
    {
        // from index onwards, set each entry to its lowest value, respecting partial.
        
        // so now we have adjusted the appropriate value in the prefix, 
        // we need to zero (set to least value) all the values after that, honouring partial
        
        int partialpointer=0;
        
        for(; index<variables.length; index++)
        {
            while(partialpointer<partial.vars.length && partial.vars[partialpointer]<index)
            {
                partialpointer++;
            }
            
            if(partialpointer>=partial.vars.length || partial.vars[partialpointer]!=index)
            {
                // set the value to the least.
                tuplearray[index]=variables[index].lowerbound();
            }
            else
            {
                tuplearray[index]=partial.vals[partialpointer];
            }
        }
    }*/
    
    tuple seekCandidateTuple(pa partial, tuple sigma, int k)
    {
        // again k is the index counting from 0 here whereas in the paper it is from 1
        // 0..k-1 is the section of the tuple which is assumed to be a candidate.
        
        while(sigma!=null && k<variables.length)
        {
            // sigma is candidate till index k
            
            /*
            
            // Construct the partial assignment corresponding to the literal var(k)=k
            // and all inner universals from sigma.
            
            int [] tempvars= new int[num_uni_inside[k]+1];
            int [] tempvals= new int[num_uni_inside[k]+1];
            
            tempvars[0]=k;
            tempvals[0]=sigma.vals[k];
            
            // copy inner universals.
            int tempvarspointer=1;
            
            for(int i=k+1; i<sigma.vals.length; i++)
            {
                if(variables[i].quant())
                {
                    tempvars[tempvarspointer]=i;
                    tempvals[tempvarspointer]=sigma.vals[i];
                    tempvarspointer++;
                }
            }
            
            assert tempvarspointer==tempvars.length;
            
            // find the appropriate pa by binary search.
            //pa temppa= new pa(tempvars, tempvals);
            ArrayList<pa> tosearch=pa_store[tempvars[0]][tempvals[0]+variables[tempvars[0]].offset()];
            int top=tosearch.size()-1;
            int bottom=0;
            int index=top>>1;
            pa temppa;
            while(true)
            {
                pa currentpa=tosearch.get(index);
                
                boolean match=true;
                boolean lessthan=false;  // currentpa < tempvals
                // by definition the variables in the pa's are the same.
                for(int j=0; j<tempvals.length; j++)
                {
                    if(currentpa.vals[j]<tempvals[j])
                    {
                        match=false;
                        lessthan=true;
                        break;
                    }
                    else if(currentpa.vals[j]>tempvals[j])
                    {
                        match=false;
                        lessthan=false;
                        break;
                    }
                }
                if(match)
                {
                    temppa=currentpa;
                    break;
                }
                if(lessthan)
                {   // i.e. the currentpa is less than the one we are searching for
                    // increase the index.
                    bottom=index+1;
                }
                else
                {   // i.e. the currentpa is greater than the one we are searching for
                    // decrease the index.
                    top=index-1;
                }
                index=bottom+( (top-bottom)>>1 );
            }
            tuple lambda=last_support.get(temppa.scindex);*/
            //System.out.println("In seekCandidateTuple: temppa = "+temppa);
            
            // use all pa's in pa_store[k][sigma[k]] and find least last_support tuple.
            ArrayList<pa> palist=pa_store[k][sigma.vals[k]];
            tuple lambda=last_support.get(palist.get(0).scindex);
            for(int pastorei=1; pastorei<palist.size(); pastorei++)
            {
                if(lambda==null)
                {   // stop because
                    break;
                }
                tuple temp=last_support.get(palist.get(pastorei).scindex);
                if(temp==null || tuples.comparetuples(temp.vals, lambda.vals)<0)
                {   // n.b. if temp = null then lambda:=temp
                    lambda=temp;
                }
            }
            
            if(lambda!=null)
            {
                int split=0;   // index from 0 unlike paper.
                while(split<sigma.vals.length && sigma.vals[split]==lambda.vals[split])  //split<sigma.vals.length && 
                {
                    split++;
                }
                
                // we should never have sigma==lambda
                //System.out.println("In seekCandidateTuple: split:"+split+" sigma:"+sigma+" lambda:"+lambda);
                
                // lambda is lessthan or equal to sigma so jump forward.
                if(split==sigma.vals.length || sigma.vals[split]<lambda.vals[split]) //split==sigma.vals.length || 
                {
                    if(split<k)
                    {
                        nextTuple(partial, sigma, k);
                        k=returnkprime-1;
                        sigma=returnsigma;
                    }
                    else
                    {
                        nextTuple(partial, lambda, lambda.vals.length-1);
                        
                        // k= min(k, k'-1);
                        if(k>(returnkprime-1))
                        {
                            k=(returnkprime-1);
                        }
                        
                        sigma=returnsigma;
                    }
                }
            }
            
            k++;
        }
        return sigma;
    }
    
    tuple seekNextSupport(pa partial, tuple previous_support)
    {
        tuple new_support;
        for(int i=0; i<variables.length; i++)
        {
            if(variables[i].empty())
            {
                return null;
            }
        }
        
        if(previous_support!=null)
        {
            //System.out.println("Calling 1");
            nextTuple(partial, previous_support, variables.length-1);
            // need to copy returnsigma
            
            new_support=returnsigma;
        }
        else
        {
            int [] tuplearray=new int[variables.length];
            int partialindex=0;
            
            for(int i=0; i<variables.length; i++)
            {
                mid_domain v=variables[i];
                if(partialindex<partial.vars.length && partial.vars[partialindex] == i)
                {
                    tuplearray[i]=partial.vals[partialindex];
                    partialindex++;
                    continue;
                }
                
                // lowest valid value
                
                tuplearray[i]=v.lowerbound();
            }
            new_support=new tuple(tuplearray);
        }
        assert new_support==null || valid(new_support);
        
        new_support = seekCandidateTuple(partial, new_support, 0);   // potential bug, could be 1
        
        while(new_support!=null)
        {
            assert valid(new_support);
            
            if(pred.predicate(new_support))
            {
                //assert pred.predicate(new_support);
                return new_support;
            }
            else
            {
                //System.out.println("Calling 2");
                nextTuple(partial, new_support, variables.length-1);
                
                new_support=seekCandidateTuple(partial, returnsigma, returnkprime);
            }
        }
        //assert pred.predicate(new_support); Probably this is stupid because new_support might be null.
        return new_support;
    }
    
    tuple entail_watch=null;
    
    public boolean entailed()
    {
        // if all vars unit
        boolean flag=true;
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].unit())
            {
                flag=false;
                break;
            }
        }
        if(flag) return true;
        
        // check the watch against current domains
        if(entail_watch!=null && tuples.valid(entail_watch.vals, variables))
        {
            return false;
        }
        
        // throttled at 50 tests.
        // generate the first 50 tuples (lex-order)
        // and test them. If we get to the end (i.e. the lex-last in-domain tuple)
        // without finding a false, then return true.
        // If we reach 50 without finding a false, assume there is one later. and return false.
        
        int [] tuplearray=new int[variables.length];
        int [] pavarsvals=new int[0];
        
        pa partial=new pa(pavarsvals, pavarsvals);  // empty partial assignment.
        tuple tau=new tuple(tuplearray);
        
        // set the tuplearray to lowest val in all domains.
        for(int i=0; i<variables.length; i++)
        {
            tuplearray[i]=variables[i].lowerbound();
        }
        
        for(int i=0; i<50; i++)
        {
            if(!pred.predicate(tau))
            {
                entail_watch=tau;
                return false;
            }
            
            if(!countup(partial, tuplearray, variables.length-1))
            {
                // if no next tuple, then constraint is entailed.
                return true;
            }
        }
        
        return false;  // default is assume not entailed.
    }
    
    public String toString()
    {
        String st="gac_schema_predicate:\n";
        
        for(int i=0; i<variables.length; i++)
            st+=variables[i].toString()+" ";
        st+="\n";
        
        st+= super.toString();
                
        return st;
    }
}


//------------------------------------------------------------------------------------------
// Simplified version which does not handle multidirectionality.

class gac_schema_predicate2 extends gac_schema_predicate
{
    // just override one method.
    
    gac_schema_predicate2(mid_domain [] vars, qcsp prob, predicate_wrapper pred) // <pa, goodlistwrapper>
    {
        super(vars, prob, pred);
    }
    
    tuple seekNextSupport(pa partial, tuple previous_support)
    {
        tuple new_support;
        for(int i=0; i<variables.length; i++)
        {
            if(variables[i].empty())
            {
                return null;
            }
        }
        
        if(previous_support!=null)
        {
            //System.out.println("Calling 1");
            nextTuple(partial, previous_support, variables.length-1);
            // need to copy returnsigma
            
            new_support=returnsigma;
            
            assert new_support==null || valid(new_support);
        }
        else
        {
            int [] tuplearray=new int[variables.length];
            int partialindex=0;
            
            for(int i=0; i<variables.length; i++)
            {
                mid_domain v=variables[i];
                if(partialindex<partial.vars.length && partial.vars[partialindex] == i)
                {
                    tuplearray[i]=partial.vals[partialindex];
                    partialindex++;
                    continue;
                }
                
                // lowest valid value
                
                tuplearray[i]=v.lowerbound();
            }
            new_support=new tuple(tuplearray);
            
            assert valid(new_support);
        }
        
        // Changed from here to eliminate multidirectionality.
        // i.e. does not call seekCandidateTuple
        
        while(new_support!=null)
        {
            if(pred.predicate(new_support)) 
            {
                return new_support;
            }
            else
            {
                //System.out.println("Calling 2");
                nextTuple(partial, new_support, variables.length-1);
                new_support=returnsigma;
            }
        }
        
        return null;
        
    }
}

/////////////////////////////////////////////////////////////////////////////////////
// 
// testing  nexttuple. Multidirectional.

class gac_schema_predicate3 extends gac_schema_predicate
{
    // just override one method.
    
    gac_schema_predicate3(mid_domain [] vars, qcsp prob, predicate_wrapper pred) // <pa, goodlistwrapper>
    {
        super(vars, prob, pred);
    }
    
    void nextTuple(pa partial, tuple old, int k)
    {
        super.nextTuple(partial, old, k);
        
        tuple normaltuple=returnsigma;
        int normalkprime=returnkprime;
        
        nextTuplenaive(partial, old, k);
        
        tuple naivetuple=returnsigma;
        int naivekprime=returnkprime;
        
        assert normalkprime==naivekprime;
        if(normaltuple==null)
        {
            if(naivetuple!=null)
            {
            problem.printdomains();
            System.out.println(this);
            System.out.println("nextTuplesafe: partial: "+partial+" old: "+old+" k: "+k);
            System.out.println("normal: sigma: "+normaltuple+" kprime: "+normalkprime);
            System.out.println("naive: sigma: "+naivetuple+" kprime: "+naivekprime);
            }
            assert naivetuple==null;
        }
        else
        {
            for(int i=0; i<normaltuple.vals.length; i++)
            {
                if(normaltuple.vals[i]!=naivetuple.vals[i])
                {
                problem.printdomains();
                System.out.println(this);
                System.out.println("nextTuplesafe: partial: "+partial+" old: "+old+" k: "+k);
                System.out.println("normal: sigma: "+normaltuple+" kprime: "+normalkprime);
                System.out.println("naive: sigma: "+naivetuple+" kprime: "+naivekprime);
                }
                
                assert normaltuple.vals[i]==naivetuple.vals[i];
            }
        }
        
        return;  // naive results are left.
    }
    
    void nextTuplenaive(pa partial, tuple old, int k)
    {
        // intended to return the lex-smallest tuple sigma >lo old, and matching partial, and sigma[0..k]!=old[0..k]
        // warning: k is the index from 0 here. In the Bessiere and Regin paper it is an index from 1.
        
        // System.out.println("nextTuple called with partial "+partial+" and old tuple "+old+"and k="+k);
        
        int [] tuplearray = new int[variables.length];
        
        // copy
        for(int i=0; i<variables.length; i++)
        {
            tuplearray[i] = old.vals[i];
        }
        
        // If any values are not in the current domains, zero them and subsequent values.
        for(int i=0; i<variables.length; i++)
        {
            
        }
        
        while(true)
        {
            // count up
            boolean found=false;
            
            for(int index=tuplearray.length-1; index>=0; index--)
            {
                // set the value to the next higher.
                for(int j=tuplearray[index]+1; j<=variables[index].upperbound(); j++)
                {
                    if(variables[index].is_present(j))
                    {
                        tuplearray[index]=j;
                        found=true;
                        break;
                    }
                }
                
                if(found)
                {
                    // zero other values after
                    for(int index2=index+1; index2<tuplearray.length; index2++)
                    {
                        tuplearray[index2]=variables[index2].lowerbound();
                    }
                    break;
                }
            }
            
            if(!found)
            {
                returnsigma=null;
                returnkprime=0;
                return;
            }
            
            tuple temptuple=new tuple(tuplearray);
            
            if(satisfies(temptuple, partial) && differsk(temptuple, old, k) && checkdomains(temptuple))
            {
                returnsigma=temptuple;
                
                for(int i=0; i<=k; i++)
                {
                    if(temptuple.vals[i]!=old.vals[i])
                    {
                        returnkprime=i;
                        return;
                    }
                }
                assert false;
                
            }
        }
    }
    
    boolean differsk(tuple t1, tuple t2, int k)
    {
        for(int i=0; i<=k; i++)
        {
            if(t1.vals[i]!=t2.vals[i])
                return true;
        }
        return false;
    }
    
    boolean checkdomains(tuple t)
    {
        for(int i=0; i<t.vals.length; i++)
        {
            if(!variables[i].is_present(t.vals[i]))
            {
                return false;
            }
        }
        return true;
    }
}

/////////////////////////////////////////////////////////////////////////////////////
// 
//  Testing multidirectional against monodirectional

class gac_schema_predicate4 extends gac_schema_predicate
{
    // just override one method.
    
    gac_schema_predicate4(mid_domain [] vars, qcsp prob, predicate_wrapper pred) // <pa, goodlistwrapper>
    {
        super(vars, prob, pred);
    }
    
    tuple seekNextSupport(pa partial, tuple previous_support)
    {
        tuple t1 = seekNextSupport_mono(partial, previous_support);
        tuple t2 = super.seekNextSupport(partial, previous_support);   // multidirectional
        
        if(t1==null)
        {
            assert t2==null;
            return t1;
        }
        
        for(int i=0; i<t1.vals.length; i++)
        {
            if(t1.vals[i]!=t2.vals[i])
            {
                problem.printdomains();
                System.out.println(this);
                System.out.println("partial: "+partial);
                System.out.println("Previous support: "+previous_support);
                System.out.println("Result mono: "+t1);
                System.out.println("Reesult multi: "+t2);
            }
            assert t1.vals[i]==t2.vals[i];
        }
        return t2;
    }
    
    tuple seekNextSupport_mono(pa partial, tuple previous_support)
    {
        tuple new_support;
        
        if(previous_support!=null)
        {
            //System.out.println("Calling 1");
            nextTuple(partial, previous_support, variables.length-1);
            new_support=returnsigma;
        }
        else
        {
            int [] tuplearray=new int[variables.length];
            int partialindex=0;
            
            for(int i=0; i<variables.length; i++)
            {
                mid_domain v=variables[i];
                
                if(partialindex<partial.vars.length && partial.vars[partialindex] == i)
                {
                    tuplearray[i]=partial.vals[partialindex];
                    partialindex++;
                    continue;
                }
                
                // lowest valid value
                tuplearray[i]=v.lowerbound();
            }
            new_support=new tuple(tuplearray);
        }
        
        // Changed from here to eliminate multidirectionality.
        
        while(new_support!=null)
        {
            if(pred.predicate(new_support)) 
            {
                return new_support;
            }
            else
            {
                //System.out.println("Calling 2");
                nextTuple(partial, new_support, variables.length-1);
                new_support=returnsigma;
            }
        }
        
        return null;
    }
}
