// A constraint which implements gac element. c&p from minion.

package queso.constraints;

//import gnu.trove.*;
import java.util.*;
//import gnu.math.*;
import java.io.*;
import queso.core.*;

// note on variables: numerical constraints can use both hash_var
// and bound_var types, but the other constraints can only use
// hash_var because they prune from the middle of the domains.


// the basic class, not directly used.
public final class gacelement_constraint extends constraint implements make_ac
{
    public gacelement_constraint(mid_domain [] var_array, mid_domain indexvar, mid_domain resultvar, qcsp problem)
    // xi is the variable which is true iff the disjunction of all the others
    {
        super(problem);
        this.var_array=var_array;
        this.indexvar=indexvar;
        this.resultvar=resultvar;
    }
    
    final mid_domain [] var_array;
    final mid_domain indexvar;
    final mid_domain resultvar;
    
    int var_array_min_val;
    int var_array_max_val;
    
    public boolean establish()
    {
        for(mid_domain temp : var_array)
        {
            temp.add_wakeup(this);
        }
        indexvar.add_wakeup(this);
        resultvar.add_wakeup(this);
        
        int array_size = var_array.length;
        int min_val = var_array[0].lowerbound();
        int max_val = var_array[0].upperbound();
        for(int i = 1; i < array_size; ++i)
        {
          min_val = min(min_val, var_array[i].lowerbound());
          max_val = max(max_val, var_array[i].upperbound());
        }
        
        var_array_min_val = min_val;
        var_array_max_val = max_val;
        
        if(!indexvar.exclude_lower(0, this) ||
        !indexvar.exclude_upper(var_array.length - 1, this) ||
        !resultvar.exclude_lower(var_array_min_val, this) ||
        !resultvar.exclude_upper(var_array_max_val, this))
        {
            return false;
        }
        
        return make_ac();
    }
    
    boolean index_assigned()
    {
        int index = indexvar.lowerbound();
        
        if(index < 0 || index >= var_array.length)
        {
          return false;
        }
        
        if(!var_array[index].exclude_lower(resultvar.lowerbound(), this)) return false;
        if(!var_array[index].exclude_upper(resultvar.upperbound(), this)) return false;
        
        int min_val = max(var_array[index].lowerbound(), resultvar.lowerbound());
        int max_val = min(var_array[index].upperbound(), resultvar.upperbound());
        
        for(int i = min_val; i <= max_val; ++i)
        {
          if(!resultvar.is_present(i))
          {
            if(!var_array[index].exclude(i, this)) return false;
          }
        }
        return true;
    }
  
  boolean support_for_val_in_result(int val)
  {
    for(int i = 0; i < var_array.length; ++i)
	{
	  if(indexvar.is_present(i) && var_array[i].is_present(val))
	    return true;
	}
    return false;
  }
  
  boolean support_for_val_in_index(int index)
  {
	int min_val = max(var_array[index].lowerbound(), resultvar.lowerbound());
	int max_val = min(var_array[index].upperbound(), resultvar.upperbound());
	for(int i = min_val; i <= max_val; ++i)
	{
	  if(var_array[index].is_present(i) && resultvar.is_present(i))
	    return true;
	}
    return false;
  }
  
  boolean propagate(int prop_val)
  {
	if(indexvar.lowerbound()==indexvar.upperbound())
	{ if(!index_assigned()) return false; }
	
    if(prop_val < var_array.length)
	{
	  if(indexvar.is_present(prop_val) && !support_for_val_in_index(prop_val))
	  {
	    if(!indexvar.exclude(prop_val, this)) return false;
	  }
	  
	  mid_domain var = var_array[prop_val];
	  
	  int min_val = var.lowerbound();
	  int max_val = var.upperbound();
	  for(int val = min_val; val <= max_val; ++val)
	  {
	    if(!var.is_present(val) && resultvar.is_present(val) &&
		   !support_for_val_in_result(val))
	    {
	      if(!resultvar.exclude(val, this)) return false;
	    }
	  }
	  return true;
	}
	
	if(prop_val == var_array.length)
	{ // Value got removed from index. Basically have to check everything.
	  
	  for(int i = var_array_min_val; i <= var_array_max_val; ++i)
	  {
		if(resultvar.is_present(i) && !support_for_val_in_result(i))
        {
		  if(!resultvar.exclude(i, this)) return false;
        }
	  }
	  return true;
	}
	
	//D_ASSERT(prop_val == array_size + 1);
	assert prop_val == var_array.length+1;
    
	for(int var = 0; var < var_array.length; ++var)
	{
	  if(indexvar.is_present(var) && !support_for_val_in_index(var))
	  {
		//D_INFO(2, DI_GACELEMENT, "No support for var in index");
		if(!indexvar.exclude(var, this)) return false;
	  }
	}
    return true;
  }
  
  // note: all excludes should be checked to see if they return false.
  
  int max(int a, int b)
  {
      if(a>b)
      {
          return a;
      }
      else
      {
          return b;
      }
  }
  
  int min(int a, int b)
  {
      if(a<b)
      {
          return a;
      }
      else
      {
          return b;
      }
  }
  
  // derived from full_propagate
  public boolean make_ac()
  {
    for(int i = 0; i < var_array.length + 2; ++i)
    {
        if(!propagate(i))
            return false;
    }
    return true;
  }
  
    
    
    public variable_iface [] variables()
    {
        ArrayList<variable_iface> l=new ArrayList<variable_iface>();
        for(int i=0; i<var_array.length; i++)
        {
            l.add((variable_iface) var_array[i]);
        }
        l.add(indexvar);
        l.add(resultvar);
        
        return l.toArray(new variable_iface[0]);
    }
    
    public boolean entailed()
    {
        return false;
    }
    
}

