package queso.constraints;

import queso.core.*;
import java.util.*;

public class nightingaletuples extends gac_schema implements stateful
{
  // mode
  public final boolean hologramlist;  // use a simple or hologram list.
  public final boolean listperliteral; // use one list (false) or a list for each literal (true)
  
  private class ntuple
  {
    // no need for nextPointer
    int [] values;
    int [] nextDifferent;          // nextDifferent[i] is the next tuple containing a different value for entry i.
    
    ntuple(int [] values)
    {
        this.values=values;
        if(hologramlist)
        {
            nextDifferent=new int[values.length];
            Arrays.fill(nextDifferent, -1);
        }
    }
    
    public String toString()
    {
        String st="values: ";
        st+=tuples.atos(values);
        if(nextDifferent!=null)
        {
            st+=" nextDifferent: ";
            st+=tuples.atos(nextDifferent);
        }
        return st;
    }
  }
  
  ntuple [] tuplelist;
  ntuple [][] tuplelistperlit;
  
  final int arity;
  final int [] last_tuple_pointer;   // non-backtracking last indices
  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     Constructor
	 
	 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  public nightingaletuples(mid_domain [] vars, qcsp prob, predicate_wrapper pred)
  {
        super(vars, prob);
        this.listperliteral=true;
        hologramlist=true;
        int [][] tups=tuples.pred2table(pred, variables);
        this.pred=pred;
        arity = tups[0].length ;

        TupleComparator2 tc = new TupleComparator2() ;
        Arrays.sort( (Object []) tups, tc);

        last_tuple_pointer=new int[numpa];
        Arrays.fill(last_tuple_pointer, -1);
        
        if(listperliteral)
        {
            tuplelistperlit=new ntuple[numpa][];

            int [][][] goods=new int[numpa][][];

            splittuples(goods, tups);

            for(int i=0; i<numpa; i++)
            {
                ntuple [] tlpl=buildhologram(goods[i]);
                tuplelistperlit[i]=tlpl;
            }
        }
        else
        {
            tuplelist=buildhologram(tups);
        }
  }
  
  public nightingaletuples(mid_domain [] vars, qcsp prob, int [][]tups)
  {
        super(vars, prob);
        this.listperliteral=true;
        hologramlist=true;

        arity = tups[0].length ;

        TupleComparator2 tc = new TupleComparator2() ;
        Arrays.sort( (Object []) tups, tc);

        last_tuple_pointer=new int[numpa];
        Arrays.fill(last_tuple_pointer, -1);
        
        if(listperliteral)
        {
            tuplelistperlit=new ntuple[numpa][];
            
            int [][][] goods=new int[numpa][][];
            
            splittuples(goods, tups);
            
            for(int i=0; i<numpa; i++)
            {
                ntuple [] tlpl=buildhologram(goods[i]);
                tuplelistperlit[i]=tlpl;
            }
        }
        else
        {
            tuplelist=buildhologram(tups);
        }
  }
  
  public nightingaletuples(mid_domain [] vars, qcsp prob, predicate_wrapper pred, boolean listperliteral, boolean hologram)
  {
        super(vars, prob);
        this.listperliteral=listperliteral;
        this.hologramlist=hologram;
        this.pred=pred;
        int [][] tups=tuples.pred2table(pred, variables);
        
        arity = tups[0].length ;
        
        TupleComparator2 tc = new TupleComparator2() ;
        Arrays.sort( (Object []) tups, tc);
        
        last_tuple_pointer=new int[numpa];
        Arrays.fill(last_tuple_pointer, -1);
        
        if(listperliteral)
        {
            tuplelistperlit=new ntuple[numpa][];
            
            int [][][] goods=new int[numpa][][];
            
            splittuples(goods, tups);
            
            for(int i=0; i<numpa; i++)
            {
                ntuple [] tlpl=buildhologram(goods[i]);
                tuplelistperlit[i]=tlpl;
            }
        }
        else
        {
            tuplelist=buildhologram(tups);
        }
  }
  
  public nightingaletuples(mid_domain [] vars, qcsp prob, int [][] tups, boolean listperliteral, boolean hologram)
  {
        super(vars, prob);
        this.listperliteral=listperliteral;
        this.hologramlist=hologram;
        
        arity = tups[0].length ;

        TupleComparator2 tc = new TupleComparator2() ;
        Arrays.sort( (Object []) tups, tc);

        last_tuple_pointer=new int[numpa];
        Arrays.fill(last_tuple_pointer, -1);
        
        if(listperliteral)
        {
            tuplelistperlit=new ntuple[numpa][];
            
            int [][][] goods=new int[numpa][][];
            
            splittuples(goods, tups);
            
            for(int i=0; i<numpa; i++)
            {
                ntuple [] tlpl=buildhologram(goods[i]);
                tuplelistperlit[i]=tlpl;
            }
        }
        else
        {
            tuplelist=buildhologram(tups);
        }
  }
  
  ntuple [] buildhologram(int [][] tuples)
  {
    return buildhologram(Arrays.asList(tuples));
  }
  
  ntuple [] buildhologram(List tuples)
  {
    // turn a list of int [] into an n-holo
    ntuple [] tlist=new ntuple[tuples.size()];
        
        for(int tupleIndex = 0; tupleIndex < tuples.size(); tupleIndex++)
        {
            int [] values=(int [])tuples.get(tupleIndex);
            
            tlist[tupleIndex]=new ntuple(values);
            if(hologramlist)
            {
                // Now iterate backwards through the tuplelist, setting the appropriate forward pointers
                int numproc=arity;
                
                // check how many are the same for the last tuple.
                if(tupleIndex>=1)
                for(int valIndex=0; valIndex<values.length; valIndex++)
                {
                    if(values[valIndex]==tlist[tupleIndex-1].values[valIndex])
                        numproc--;
                }
                
                for(int i=tupleIndex-1; i>=0; i--)
                {
                    ntuple backtuple=tlist[i];
                    // if backtuple has a value i which is different to curtuple, make the forward link.
                    
                    //boolean allfilled=true;
                    
                    // fill in any entries in nextDifferent
                    for(int valIndex=0; valIndex<values.length; valIndex++)
                    {
                        if(backtuple.nextDifferent[valIndex]==-1)
                        {
                            if(backtuple.values[valIndex]!=values[valIndex])
                            {
                                numproc--;
                                backtuple.nextDifferent[valIndex]=tupleIndex;
                                // now iterate backwards and fill in any others in the same column
                                for(int j=i-1; j>=0; j--)
                                {
                                    if(tlist[j].nextDifferent[valIndex]==-1)
                                    {
                                        tlist[j].nextDifferent[valIndex]=tupleIndex;
                                    }
                                    else
                                        break;
                                }
                            }
                            else
                            {
                                //allfilled=false;
                            }
                        }
                    }
                    
                    if(numproc==0)//allfilled)
                    {
                        break;  // suspicious about this. 
                        //What about 1 1 5, 1 2 5, 1 2 6. var 3, nextD only set for second tuple, not first.
                    }
                }
            }
        }
        return tlist;
  }
  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     toString
	 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  public String toString() 
  {
    StringBuffer result = new StringBuffer() ;
    result.append(super.toString());
	if(!listperliteral)
    {
        for (int i=0; i<tuplelist.length; i++) 
        {
	      result.append("index: "+i+" "+tuplelist[i]+"\n");
	    }
    }
    else
    {
        for(int i=0; i<tuplelistperlit.length; i++)
        {
            
            result.append("scindex: "+i+"\n");
            for(int j=0; j<tuplelistperlit[i].length; j++)
            {
                result.append("index: "+j+" "+tuplelistperlit[i][j]+"\n");
            }
        }
    }
    return result.toString();
  }
  
  /* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     nextSupportingTuple
	 Assumes tuple is supporting the ancestor at trieLevel 0.
	 index is into last level of trie.
	 Find highest lvl where domelem in tuple gone. Search from here.
 	 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
  
  tuple seekNextSupport(pa partial, tuple previous_support)
  {
    // don't actually use previous_support
    //assert partial.vals.length==1;  // only works for all-existential constraints.
    int [] vars=partial.vars;
    int [] vals=partial.vals;
    
    //System.out.println("Finding support for var:"+var+" val:"+val);
    // find a support which conforms to var and val, and the current domains,
    // and is after the support in watches unless we reach the end and wrap.
    // Else return null.
    int ltp=last_tuple_pointer[partial.scindex];
    
    //int index=ltp+1;  // place to start.
    int index=ltp; if(index==-1) index=0;
    
    // select the list to search through.
    ntuple [] tuplelist;
    if(listperliteral)
        tuplelist=tuplelistperlit[partial.scindex];
    else
        tuplelist=this.tuplelist;
    
    boolean firstpass=true;
    for(int pass=0; pass<2; pass++)
    {
        firstpass=(pass==0)?true:false;
        if(!firstpass) index=0;
        while((firstpass && index<tuplelist.length && index!=-1) || (!firstpass && index<=ltp && index!=-1))
        {
            ntuple curtuple=tuplelist[index];
            //System.out.println("Looking at tuple "+curtuple);
            // iterate from most to least significant digit
            // because most sig digit probably allows greatest jump.
            // Remember that var gets treated specially, as if its domain is just {val}
            
            boolean matchAll=true;
            int paindex=0;   // assume vars and vals are sorted by var.
            int var=vars[0];
            int val=vals[0];
            for(int valIndex=0; valIndex<variables.length; valIndex++)
            {
                int curvalue=curtuple.values[valIndex];
                if(var<valIndex)
                {   // update var and val to the next one in the pa.
                    paindex++;
                    if(paindex<vars.length)
                    {
                        var=vars[paindex];
                        val=vals[paindex];
                    }
                }
                if( (valIndex!=var && !variables[valIndex].is_present(curvalue)) || 
                    (valIndex==var && curvalue!=val))
                {
                    matchAll=false;
                    if(hologramlist)
                    {
                        // attempt to jump forward
                        index=curtuple.nextDifferent[valIndex];
                    }
                    else
                    {
                        index++;
                    }
                    break;
                }
            }
            
            if(matchAll)
            {
                // success
                // set watch
                last_tuple_pointer[partial.scindex]=index;
                //System.out.println("Support found:"+new tuple(curtuple.values));
                return new tuple(curtuple.values);
            }
        }
    }
    
    return null;
  }
  
  public predicate_wrapper pred;
  tuple entail_watch=null;
  // this is bad because it assumes a predicate was used to set up this constraint.
    public boolean entailed()
    {
        // if all vars unit
        boolean flag=true;
        for(int i=0; i<variables.length; i++)
        {
            if(!variables[i].unit())
            {
                flag=false;
                break;
            }
        }
        if(flag) return true;
        
        // check the watch against current domains
        if(entail_watch!=null && tuples.valid(entail_watch.vals, variables))
        {
            return false;
        }
        
        // throttled at 50 tests.
        // generate the first 50 tuples (lex-order)
        // and test them. If we get to the end (i.e. the lex-last in-domain tuple)
        // without finding a false, then return true.
        // If we reach 50 without finding a false, assume there is one later. and return false.
        
        int [] tuplearray=new int[variables.length];
        int [] pavarsvals=new int[0];
        
        tuple tau=new tuple(tuplearray);
        
        // set the tuplearray to lowest val in all domains.
        for(int i=0; i<variables.length; i++)
        {
            tuplearray[i]=variables[i].lowerbound();
        }
        
        for(int i=0; i<50; i++)
        {
            if(!pred.predicate(tau))
            {
                entail_watch=tau;
                return false;
            }
            
            if(!tuples.increment(tuplearray, variables))
            {
                // if no next tuple, then constraint is entailed.
                return true;
            }
        }
        
        return false;  // default is assume not entailed.
    }
}

